untrusted comment: verify with openbsd-67-base.pub
RWRmkIA877Io3rhAYbns9JzHXc4CF0+cm8IIaZy6m56N3uQ4JA6z1IAKbIt6yYr+B35rp18+CGJzccFoKZasVPbHO9K4p77ceg4=

OpenBSD 6.7 errata 018, August 07, 2020:

The recent security errata 016 broke X11 input methods.

Apply by doing:
    signify -Vep /etc/signify/openbsd-67-base.pub -x 018_ximcp.patch.sig \
        -m - | (cd /usr/xenocara && patch -p0)

And then compile and rebuild the X11 library
    cd /usr/xenocara/lib/libX11
    make -f Makefile.bsd-wrapper obj
    make -f Makefile.bsd-wrapper build

Index: lib/libX11/modules/im/ximcp/imRmAttr.c
===================================================================
RCS file: /cvs/xenocara/lib/libX11/modules/im/ximcp/imRmAttr.c,v
retrieving revision 1.9.20.1
diff -u -p -r1.9.20.1 imRmAttr.c
--- lib/libX11/modules/im/ximcp/imRmAttr.c	31 Jul 2020 18:42:58 -0000	1.9.20.1
+++ lib/libX11/modules/im/ximcp/imRmAttr.c	4 Aug 2020 19:40:38 -0000
@@ -265,7 +265,7 @@ _XimAttributeToValue(
 
 	    if (num > (USHRT_MAX / sizeof(XIMStyle)))
 		return False;
-	    if ((sizeof(num) + (num * sizeof(XIMStyle))) > data_len)
+	    if ((2 * sizeof(CARD16) + (num * sizeof(CARD32))) > data_len)
 		return False;
 	    alloc_len = sizeof(XIMStyles) + sizeof(XIMStyle) * num;
 	    if (alloc_len < sizeof(XIMStyles))
@@ -379,7 +379,7 @@ _XimAttributeToValue(
 
 	    if (num > (UINT_MAX / sizeof(XIMHotKeyTrigger)))
 		return False;
-	    if ((sizeof(num) + (num * sizeof(XIMHotKeyTrigger))) > data_len)
+	    if ((2 * sizeof(CARD16) + (num * 3 * sizeof(CARD32))) > data_len)
 		return False;
 	    alloc_len = sizeof(XIMHotKeyTriggers)
 		      + sizeof(XIMHotKeyTrigger) * num;
