"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setupDetectorRoutes = setupDetectorRoutes;
var _configSchema = require("@osd/config-schema");
var _constants = require("../utils/constants");
var _helpers = require("../utils/helpers");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function setupDetectorRoutes(services, router) {
  const {
    detectorsService
  } = services;
  router.post({
    path: _constants.API.DETECTORS_BASE,
    validate: {
      body: _configSchema.schema.any(),
      query: (0, _helpers.createQueryValidationSchema)()
    }
  }, detectorsService.createDetector);
  router.get({
    path: `${_constants.API.DETECTORS_BASE}/{detectorId}`,
    validate: {
      params: _configSchema.schema.object({
        detectorId: _configSchema.schema.string()
      }),
      query: (0, _helpers.createQueryValidationSchema)()
    }
  }, detectorsService.getDetector);
  router.post({
    path: `${_constants.API.SEARCH_DETECTORS}`,
    validate: {
      body: _configSchema.schema.any(),
      query: (0, _helpers.createQueryValidationSchema)()
    }
  }, detectorsService.searchDetectors);
  router.put({
    path: `${_constants.API.DETECTORS_BASE}/{detectorId}`,
    validate: {
      params: _configSchema.schema.object({
        detectorId: _configSchema.schema.string()
      }),
      body: _configSchema.schema.any(),
      query: (0, _helpers.createQueryValidationSchema)()
    }
  }, detectorsService.updateDetector);
  router.delete({
    path: `${_constants.API.DETECTORS_BASE}/{detectorId}`,
    validate: {
      params: _configSchema.schema.object({
        detectorId: _configSchema.schema.string()
      }),
      body: _configSchema.schema.any(),
      query: (0, _helpers.createQueryValidationSchema)()
    }
  }, detectorsService.deleteDetector);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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