/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.crypto.ec;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.crypto.ec.RFC7748Curve;
import java.math.BigInteger;
import org.apache.commons.lang3.ArrayUtils;

public class EllipticCurveX25519
extends RFC7748Curve {
    public EllipticCurveX25519() {
        super(new BigInteger("76D06", 16), new BigInteger("1", 16), new BigInteger("7FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFED", 16), new BigInteger("9", 16), new BigInteger("5F51E65E475F794B1FE122D388B72EB36DC2B28192839E4DD6163A5D81312C14", 16), new BigInteger("1000000000000000000000000000000014DEF9DEA2F79CD65812631A5CF5D3ED", 16));
    }

    @Override
    public BigInteger decodeScalar(BigInteger scalar) {
        byte[] scalarA = ArrayConverter.bigIntegerToNullPaddedByteArray((BigInteger)scalar, (int)ArrayConverter.bigIntegerToByteArray((BigInteger)this.getModulus()).length);
        scalarA[0] = (byte)(scalarA[0] & 0xF8);
        scalarA[31] = (byte)(scalarA[31] & 0x7F);
        scalarA[31] = (byte)(scalarA[31] | 0x40);
        ArrayUtils.reverse((byte[])scalarA);
        return new BigInteger(1, scalarA);
    }

    @Override
    public BigInteger decodeCoordinate(BigInteger encCoordinate) {
        byte[] coordinate = ArrayConverter.bigIntegerToNullPaddedByteArray((BigInteger)encCoordinate, (int)ArrayConverter.bigIntegerToByteArray((BigInteger)this.getModulus()).length);
        coordinate[31] = (byte)(coordinate[31] & 0x7F);
        ArrayUtils.reverse((byte[])coordinate);
        return new BigInteger(1, coordinate).mod(this.getModulus());
    }

    @Override
    public byte[] encodeCoordinate(BigInteger coordinate) {
        byte[] xEnc = ArrayConverter.bigIntegerToNullPaddedByteArray((BigInteger)coordinate, (int)ArrayConverter.bigIntegerToByteArray((BigInteger)this.getModulus()).length);
        ArrayUtils.reverse((byte[])xEnc);
        return xEnc;
    }
}

