/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.applet;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;
import org.lwjgl.opengl.AWTGLCanvas;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;
import org.lwjgl.test.applet.Test;
import org.lwjgl.util.WaveData;

public class OpenAL
extends AWTGLCanvas
implements Test {
    float angle;
    IntBuffer buffers = BufferUtils.createIntBuffer((int)1);
    IntBuffer sources = BufferUtils.createIntBuffer((int)1);

    public OpenAL() throws LWJGLException {
        try {
            AL.create();
        }
        catch (Exception e) {
            System.out.println("Unable to create OpenAL.\nPlease make sure that OpenAL is available on this system. Exception: " + e);
            return;
        }
        Thread t = new Thread(){

            @Override
            public void run() {
                while (true) {
                    if (OpenAL.this.isVisible()) {
                        OpenAL.this.repaint();
                    }
                    Display.sync((int)60);
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }

    private void playOpenAL() {
        this.buffers.position(0).limit(1);
        AL10.alGenBuffers((IntBuffer)this.buffers);
        int lastError = AL10.alGetError();
        if (lastError != 0) {
            this.exit(lastError);
        }
        this.sources.position(0).limit(1);
        AL10.alGenSources((IntBuffer)this.sources);
        lastError = AL10.alGetError();
        if (lastError != 0) {
            this.exit(lastError);
        }
        WaveData wavefile = WaveData.create((InputStream)this.getClass().getClassLoader().getResourceAsStream("Footsteps.wav"));
        AL10.alBufferData((int)this.buffers.get(0), (int)wavefile.format, (ByteBuffer)wavefile.data, (int)wavefile.samplerate);
        wavefile.dispose();
        lastError = AL10.alGetError();
        if (lastError != 0) {
            this.exit(lastError);
        }
        AL10.alSourcei((int)this.sources.get(0), (int)4105, (int)this.buffers.get(0));
        lastError = AL10.alGetError();
        if (lastError != 0) {
            this.exit(lastError);
        }
        AL10.alSourcei((int)this.sources.get(0), (int)4103, (int)1);
        lastError = AL10.alGetError();
        if (lastError != 0) {
            this.exit(lastError);
        }
        AL10.alSourcePlay((int)this.sources.get(0));
        lastError = AL10.alGetError();
        if (lastError != 0) {
            this.exit(lastError);
        }
    }

    private void exit(int error) {
        System.out.println("OpenAL Error: " + AL10.alGetString((int)error));
    }

    public void paintGL() {
        GL11.glClear((int)16384);
        GL11.glMatrixMode((int)2983);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)640.0, (double)0.0, (double)480.0, (double)1.0, (double)-1.0);
        GL11.glMatrixMode((int)2982);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)320.0f, (float)240.0f, (float)0.0f);
        GL11.glRotatef((float)this.angle, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glBegin((int)7);
        GL11.glVertex2i((int)-50, (int)-50);
        GL11.glVertex2i((int)50, (int)-50);
        GL11.glVertex2i((int)50, (int)50);
        GL11.glVertex2i((int)-50, (int)50);
        GL11.glEnd();
        GL11.glPopMatrix();
        this.angle += 1.0f;
        try {
            this.swapBuffers();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void start() {
        this.playOpenAL();
    }

    @Override
    public void stop() {
        AL10.alSourceStop((int)this.sources.get(0));
        int lastError = AL10.alGetError();
        if (lastError != 0) {
            this.exit(lastError);
        }
        this.sources.position(0).limit(1);
        AL10.alDeleteSources((IntBuffer)this.sources);
        lastError = AL10.alGetError();
        if (lastError != 0) {
            this.exit(lastError);
        }
        this.buffers.position(0).limit(1);
        AL10.alDeleteBuffers((IntBuffer)this.buffers);
        lastError = AL10.alGetError();
        if (lastError != 0) {
            this.exit(lastError);
        }
        AL.destroy();
    }
}

