/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.tenant;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InjectableInstance;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.ManagedContext;
import io.quarkus.hibernate.orm.runtime.PersistenceUnitUtil;
import io.quarkus.hibernate.orm.runtime.tenant.TenantConnectionResolver;
import io.quarkus.hibernate.orm.runtime.tenant.TenantResolver;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.context.SessionScoped;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.engine.jdbc.connections.spi.AbstractMultiTenantConnectionProvider;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.jboss.logging.Logger;

public final class HibernateMultiTenantConnectionProvider
extends AbstractMultiTenantConnectionProvider<String> {
    private static final Logger LOG = Logger.getLogger(HibernateMultiTenantConnectionProvider.class);
    private final String persistenceUnitName;
    private final Map<String, ConnectionProvider> providerMap = new ConcurrentHashMap<String, ConnectionProvider>();

    public HibernateMultiTenantConnectionProvider(String persistenceUnitName) {
        this.persistenceUnitName = persistenceUnitName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConnectionProvider getAnyConnectionProvider() {
        String tenantId;
        InstanceHandle<TenantResolver> tenantResolver = HibernateMultiTenantConnectionProvider.tenantResolver(this.persistenceUnitName);
        ManagedContext requestContext = Arc.container().requestContext();
        Class tenantScope = tenantResolver.getBean().getScope();
        boolean requiresRequestScope = tenantScope == RequestScoped.class || tenantScope == SessionScoped.class;
        boolean forceRequestActivation = !requestContext.isActive() && requiresRequestScope;
        try {
            if (forceRequestActivation) {
                requestContext.activate();
            }
            tenantId = ((TenantResolver)tenantResolver.get()).getDefaultTenantId();
        }
        finally {
            if (forceRequestActivation) {
                requestContext.deactivate();
            }
        }
        if (tenantId == null) {
            throw new IllegalStateException("Method 'TenantResolver.getDefaultTenantId()' returned a null value. This violates the contract of the interface!");
        }
        return this.selectConnectionProvider(tenantId);
    }

    protected ConnectionProvider selectConnectionProvider(String tenantIdentifier) {
        LOG.debugv("selectConnectionProvider(persistenceUnitName={0}, tenantIdentifier={1})", (Object)this.persistenceUnitName, (Object)tenantIdentifier);
        ConnectionProvider provider = this.providerMap.get(tenantIdentifier);
        if (provider == null) {
            ConnectionProvider connectionProvider = HibernateMultiTenantConnectionProvider.resolveConnectionProvider(this.persistenceUnitName, tenantIdentifier);
            this.providerMap.put(tenantIdentifier, connectionProvider);
            return connectionProvider;
        }
        return provider;
    }

    private static ConnectionProvider resolveConnectionProvider(String persistenceUnitName, String tenantIdentifier) {
        LOG.debugv("resolveConnectionProvider(persistenceUnitName={0}, tenantIdentifier={1})", (Object)persistenceUnitName, (Object)tenantIdentifier);
        InjectableInstance<TenantConnectionResolver> instance = PersistenceUnitUtil.legacySingleExtensionInstanceForPersistenceUnit(TenantConnectionResolver.class, persistenceUnitName);
        if (instance.isUnsatisfied()) {
            throw new IllegalStateException(String.format(Locale.ROOT, "No instance of %1$s was found for persistence unit %2$s. You need to create an implementation for this interface to allow resolving the current tenant connection.", TenantConnectionResolver.class.getSimpleName(), persistenceUnitName));
        }
        TenantConnectionResolver resolver = (TenantConnectionResolver)instance.get();
        ConnectionProvider cp = resolver.resolve(tenantIdentifier);
        if (cp == null) {
            throw new IllegalStateException("Method 'TenantConnectionResolver.resolve(String)' returned a null value. This violates the contract of the interface!");
        }
        return cp;
    }

    private static InstanceHandle<TenantResolver> tenantResolver(String persistenceUnitName) {
        InjectableInstance<TenantResolver> instance = PersistenceUnitUtil.legacySingleExtensionInstanceForPersistenceUnit(TenantResolver.class, persistenceUnitName);
        if (instance.isUnsatisfied()) {
            throw new IllegalStateException(String.format(Locale.ROOT, "No instance of %1$s was found for persistence unit %2$s. You need to create an implementation for this interface to allow resolving the current tenant identifier.", TenantResolver.class.getSimpleName(), persistenceUnitName));
        }
        return instance.getHandle();
    }
}

