/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.internal;

import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.bytecode.spi.BytecodeProvider;
import org.hibernate.bytecode.spi.ReflectionOptimizer;
import org.hibernate.engine.internal.ManagedTypeHelper;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Subclass;
import org.hibernate.metamodel.RepresentationMode;
import org.hibernate.metamodel.internal.EmbeddableRepresentationStrategyPojo;
import org.hibernate.metamodel.internal.EntityInstantiatorPojoOptimized;
import org.hibernate.metamodel.internal.EntityInstantiatorPojoStandard;
import org.hibernate.metamodel.internal.PropertyAccessHelper;
import org.hibernate.metamodel.spi.EntityInstantiator;
import org.hibernate.metamodel.spi.EntityRepresentationStrategy;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.property.access.spi.PropertyAccessStrategy;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.ProxyFactory;
import org.hibernate.proxy.pojo.ProxyFactoryHelper;
import org.hibernate.tuple.entity.EntityMetamodel;
import org.hibernate.type.CompositeType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.spi.JavaTypeRegistry;
import org.hibernate.type.spi.CompositeTypeImplementor;

public class EntityRepresentationStrategyPojoStandard
implements EntityRepresentationStrategy {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(EntityRepresentationStrategyPojoStandard.class);
    private final JavaType<?> mappedJtd;
    private final JavaType<?> proxyJtd;
    private final boolean isBytecodeEnhanced;
    private final ReflectionOptimizer reflectionOptimizer;
    private final ProxyFactory proxyFactory;
    private final EntityInstantiator instantiator;
    private final StrategySelector strategySelector;
    private final String identifierPropertyName;
    private final PropertyAccess identifierPropertyAccess;
    private final Map<String, PropertyAccess> propertyAccessMap;
    private final EmbeddableRepresentationStrategyPojo mapsIdRepresentationStrategy;

    public EntityRepresentationStrategyPojoStandard(PersistentClass bootDescriptor, EntityPersister runtimeDescriptor, RuntimeModelCreationContext creationContext) {
        JavaTypeRegistry registry = creationContext.getTypeConfiguration().getJavaTypeRegistry();
        Class<?> mappedJavaType = bootDescriptor.getMappedClass();
        this.mappedJtd = registry.resolveEntityTypeDescriptor(mappedJavaType);
        Class<?> proxyJavaType = bootDescriptor.getProxyInterface();
        this.proxyJtd = proxyJavaType != null ? registry.getDescriptor(proxyJavaType) : null;
        this.isBytecodeEnhanced = ManagedTypeHelper.isPersistentAttributeInterceptableType(mappedJavaType);
        Property identifierProperty = bootDescriptor.getIdentifierProperty();
        if (identifierProperty == null) {
            this.identifierPropertyName = null;
            this.identifierPropertyAccess = null;
            KeyValue keyValue = bootDescriptor.getIdentifier();
            if (keyValue instanceof Component) {
                Component descriptorIdentifierComponent = (Component)keyValue;
                Component identifierMapper = bootDescriptor.getIdentifierMapper();
                this.mapsIdRepresentationStrategy = new EmbeddableRepresentationStrategyPojo(identifierMapper == null ? descriptorIdentifierComponent : identifierMapper, () -> {
                    CompositeTypeImplementor type = (CompositeTypeImplementor)bootDescriptor.getIdentifierMapper().getType();
                    return type.getMappingModelPart().getEmbeddableTypeDescriptor();
                }, null, null, creationContext);
            } else {
                this.mapsIdRepresentationStrategy = null;
            }
        } else {
            this.mapsIdRepresentationStrategy = null;
            this.identifierPropertyName = identifierProperty.getName();
            this.identifierPropertyAccess = this.makePropertyAccess(identifierProperty);
        }
        this.strategySelector = creationContext.getServiceRegistry().getService(StrategySelector.class);
        BytecodeProvider bytecodeProvider = creationContext.getBootstrapContext().getServiceRegistry().requireService(BytecodeProvider.class);
        this.proxyFactory = this.resolveProxyFactory(bootDescriptor, runtimeDescriptor, this.proxyJtd, bytecodeProvider, creationContext);
        this.propertyAccessMap = this.buildPropertyAccessMap(bootDescriptor);
        this.reflectionOptimizer = this.resolveReflectionOptimizer(bytecodeProvider);
        this.instantiator = this.determineInstantiator(bootDescriptor, runtimeDescriptor.getEntityMetamodel());
    }

    private ProxyFactory resolveProxyFactory(PersistentClass bootDescriptor, EntityPersister entityPersister, JavaType<?> proxyJavaType, BytecodeProvider bytecodeProvider, RuntimeModelCreationContext creationContext) {
        if (entityPersister.getBytecodeEnhancementMetadata().isEnhancedForLazyLoading() && bootDescriptor.getRootClass() == bootDescriptor && !bootDescriptor.hasSubclasses()) {
            return null;
        }
        EntityMetamodel entityMetamodel = entityPersister.getEntityMetamodel();
        if (proxyJavaType != null && entityMetamodel.isLazy()) {
            ProxyFactory proxyFactory = this.createProxyFactory(bootDescriptor, bytecodeProvider, creationContext);
            if (proxyFactory == null) {
                entityMetamodel.setLazy(false);
            }
            return proxyFactory;
        }
        return null;
    }

    private Map<String, PropertyAccess> buildPropertyAccessMap(PersistentClass bootDescriptor) {
        LinkedHashMap<String, PropertyAccess> propertyAccessMap = new LinkedHashMap<String, PropertyAccess>();
        for (Property property : bootDescriptor.getPropertyClosure()) {
            propertyAccessMap.put(property.getName(), this.makePropertyAccess(property));
        }
        return propertyAccessMap;
    }

    private EntityInstantiator determineInstantiator(PersistentClass bootDescriptor, EntityMetamodel entityMetamodel) {
        if (this.reflectionOptimizer != null && this.reflectionOptimizer.getInstantiationOptimizer() != null) {
            return new EntityInstantiatorPojoOptimized(entityMetamodel, bootDescriptor, this.mappedJtd, this.reflectionOptimizer.getInstantiationOptimizer());
        }
        return new EntityInstantiatorPojoStandard(entityMetamodel, bootDescriptor, this.mappedJtd);
    }

    private ProxyFactory createProxyFactory(PersistentClass bootDescriptor, BytecodeProvider bytecodeProvider, RuntimeModelCreationContext creationContext) {
        Method idSetterMethod;
        Method idGetterMethod;
        Class<?> mappedClass = this.mappedJtd.getJavaTypeClass();
        Class<?> proxyInterface = this.proxyJtd == null ? null : this.proxyJtd.getJavaTypeClass();
        Set<Class<?>> proxyInterfaces = EntityRepresentationStrategyPojoStandard.proxyInterfaces(bootDescriptor, proxyInterface, mappedClass);
        Class<?> clazz = bootDescriptor.getMappedClass();
        try {
            for (Property property : bootDescriptor.getProperties()) {
                ProxyFactoryHelper.validateGetterSetterMethodProxyability("Getter", property.getGetter(clazz).getMethod());
                ProxyFactoryHelper.validateGetterSetterMethodProxyability("Setter", property.getSetter(clazz).getMethod());
            }
            if (this.identifierPropertyAccess != null) {
                idGetterMethod = this.identifierPropertyAccess.getGetter().getMethod();
                idSetterMethod = this.identifierPropertyAccess.getSetter().getMethod();
                ProxyFactoryHelper.validateGetterSetterMethodProxyability("Getter", idGetterMethod);
                ProxyFactoryHelper.validateGetterSetterMethodProxyability("Setter", idSetterMethod);
            } else {
                idGetterMethod = null;
                idSetterMethod = null;
            }
        }
        catch (HibernateException he) {
            LOG.unableToCreateProxyFactory(clazz.getName(), he);
            return null;
        }
        Method proxyGetIdentifierMethod = idGetterMethod == null || proxyInterface == null ? null : ReflectHelper.getMethod(proxyInterface, idGetterMethod);
        Method proxySetIdentifierMethod = idSetterMethod == null || proxyInterface == null ? null : ReflectHelper.getMethod(proxyInterface, idSetterMethod);
        return EntityRepresentationStrategyPojoStandard.instantiateProxyFactory(bootDescriptor, bytecodeProvider, creationContext, proxyGetIdentifierMethod, proxySetIdentifierMethod, mappedClass, proxyInterfaces);
    }

    private static Set<Class<?>> proxyInterfaces(PersistentClass bootDescriptor, Class<?> proxyInterface, Class<?> mappedClass) {
        LinkedHashSet proxyInterfaces = new LinkedHashSet();
        if (proxyInterface != null && !mappedClass.equals(proxyInterface)) {
            if (!proxyInterface.isInterface()) {
                throw new MappingException("proxy must be either an interface, or the class itself: " + bootDescriptor.getEntityName());
            }
            proxyInterfaces.add(proxyInterface);
        }
        if (mappedClass.isInterface()) {
            proxyInterfaces.add(mappedClass);
        }
        for (Subclass subclass : bootDescriptor.getSubclasses()) {
            Class<?> subclassProxy = subclass.getProxyInterface();
            Class<?> subclassClass = subclass.getMappedClass();
            if (subclassProxy == null || subclassClass.equals(subclassProxy)) continue;
            if (!subclassProxy.isInterface()) {
                throw new MappingException("proxy must be either an interface, or the class itself: " + subclass.getEntityName());
            }
            proxyInterfaces.add(subclassProxy);
        }
        proxyInterfaces.add(HibernateProxy.class);
        return proxyInterfaces;
    }

    private static ProxyFactory instantiateProxyFactory(PersistentClass bootDescriptor, BytecodeProvider bytecodeProvider, RuntimeModelCreationContext creationContext, Method proxyGetIdentifierMethod, Method proxySetIdentifierMethod, Class<?> mappedClass, Set<Class<?>> proxyInterfaces) {
        ProxyFactory proxyFactory = bytecodeProvider.getProxyFactoryFactory().buildProxyFactory(creationContext.getSessionFactory());
        String entityName = bootDescriptor.getEntityName();
        try {
            proxyFactory.postInstantiate(entityName, mappedClass, proxyInterfaces, proxyGetIdentifierMethod, proxySetIdentifierMethod, bootDescriptor.hasEmbeddedIdentifier() ? (CompositeType)bootDescriptor.getIdentifier().getType() : null);
        }
        catch (HibernateException he) {
            LOG.unableToCreateProxyFactory(entityName, he);
            return null;
        }
        return proxyFactory;
    }

    private ReflectionOptimizer resolveReflectionOptimizer(BytecodeProvider bytecodeProvider) {
        return bytecodeProvider.getReflectionOptimizer(this.mappedJtd.getJavaTypeClass(), this.propertyAccessMap);
    }

    private PropertyAccess makePropertyAccess(Property bootAttributeDescriptor) {
        Class<?> mappedClass = this.mappedJtd.getJavaTypeClass();
        String descriptorName = bootAttributeDescriptor.getName();
        PropertyAccessStrategy strategy = PropertyAccessHelper.propertyAccessStrategy(bootAttributeDescriptor, mappedClass, this.strategySelector);
        if (strategy == null) {
            throw new HibernateException(String.format(Locale.ROOT, "Could not resolve PropertyAccess for attribute `%s#%s`", this.mappedJtd.getTypeName(), descriptorName));
        }
        return strategy.buildPropertyAccess(mappedClass, descriptorName, true);
    }

    @Override
    public RepresentationMode getMode() {
        return RepresentationMode.POJO;
    }

    @Override
    public ReflectionOptimizer getReflectionOptimizer() {
        return this.reflectionOptimizer;
    }

    @Override
    public EntityInstantiator getInstantiator() {
        return this.instantiator;
    }

    @Override
    public ProxyFactory getProxyFactory() {
        return this.proxyFactory;
    }

    @Override
    public boolean isBytecodeEnhanced() {
        return this.isBytecodeEnhanced;
    }

    @Override
    public JavaType<?> getMappedJavaType() {
        return this.mappedJtd;
    }

    @Override
    public JavaType<?> getProxyJavaType() {
        return this.proxyJtd;
    }

    @Override
    public PropertyAccess resolvePropertyAccess(Property bootAttributeDescriptor) {
        if (bootAttributeDescriptor.getName().equals(this.identifierPropertyName)) {
            return this.identifierPropertyAccess;
        }
        PropertyAccess propertyAccess = this.propertyAccessMap.get(bootAttributeDescriptor.getName());
        if (propertyAccess != null) {
            return propertyAccess;
        }
        if (this.mapsIdRepresentationStrategy != null) {
            return this.mapsIdRepresentationStrategy.resolvePropertyAccess(bootAttributeDescriptor);
        }
        return null;
    }
}

