"""Generated client library for connectors version v1."""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.py import base_api
from googlecloudsdk.generated_clients.apis.connectors.v1 import connectors_v1_messages as messages


class ConnectorsV1(base_api.BaseApiClient):
  """Generated client library for service connectors version v1."""

  MESSAGES_MODULE = messages
  BASE_URL = 'https://connectors.googleapis.com/'
  MTLS_BASE_URL = 'https://connectors.mtls.googleapis.com/'

  _PACKAGE = 'connectors'
  _SCOPES = ['https://www.googleapis.com/auth/cloud-platform']
  _VERSION = 'v1'
  _CLIENT_ID = 'CLIENT_ID'
  _CLIENT_SECRET = 'CLIENT_SECRET'
  _USER_AGENT = 'google-cloud-sdk'
  _CLIENT_CLASS_NAME = 'ConnectorsV1'
  _URL_VERSION = 'v1'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new connectors handle."""
    url = url or self.BASE_URL
    super(ConnectorsV1, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.projects_locations_connections_connectionSchemaMetadata = self.ProjectsLocationsConnectionsConnectionSchemaMetadataService(self)
    self.projects_locations_connections_eventSubscriptions = self.ProjectsLocationsConnectionsEventSubscriptionsService(self)
    self.projects_locations_connections_runtimeActionSchemas = self.ProjectsLocationsConnectionsRuntimeActionSchemasService(self)
    self.projects_locations_connections_runtimeEntitySchemas = self.ProjectsLocationsConnectionsRuntimeEntitySchemasService(self)
    self.projects_locations_connections = self.ProjectsLocationsConnectionsService(self)
    self.projects_locations_endpointAttachments = self.ProjectsLocationsEndpointAttachmentsService(self)
    self.projects_locations_global_managedZones = self.ProjectsLocationsGlobalManagedZonesService(self)
    self.projects_locations_global = self.ProjectsLocationsGlobalService(self)
    self.projects_locations_operations = self.ProjectsLocationsOperationsService(self)
    self.projects_locations_providers_connectors_versions_eventtypes = self.ProjectsLocationsProvidersConnectorsVersionsEventtypesService(self)
    self.projects_locations_providers_connectors_versions = self.ProjectsLocationsProvidersConnectorsVersionsService(self)
    self.projects_locations_providers_connectors = self.ProjectsLocationsProvidersConnectorsService(self)
    self.projects_locations_providers = self.ProjectsLocationsProvidersService(self)
    self.projects_locations = self.ProjectsLocationsService(self)
    self.projects = self.ProjectsService(self)

  class ProjectsLocationsConnectionsConnectionSchemaMetadataService(base_api.BaseApiService):
    """Service class for the projects_locations_connections_connectionSchemaMetadata resource."""

    _NAME = 'projects_locations_connections_connectionSchemaMetadata'

    def __init__(self, client):
      super(ConnectorsV1.ProjectsLocationsConnectionsConnectionSchemaMetadataService, self).__init__(client)
      self._upload_configs = {
          }

    def Refresh(self, request, global_params=None):
      r"""Refresh runtime schema of a connection.

      Args:
        request: (ConnectorsProjectsLocationsConnectionsConnectionSchemaMetadataRefreshRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Refresh')
      return self._RunMethod(
          config, request, global_params=global_params)

    Refresh.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/connections/{connectionsId}/connectionSchemaMetadata:refresh',
        http_method='POST',
        method_id='connectors.projects.locations.connections.connectionSchemaMetadata.refresh',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}:refresh',
        request_field='refreshConnectionSchemaMetadataRequest',
        request_type_name='ConnectorsProjectsLocationsConnectionsConnectionSchemaMetadataRefreshRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsLocationsConnectionsEventSubscriptionsService(base_api.BaseApiService):
    """Service class for the projects_locations_connections_eventSubscriptions resource."""

    _NAME = 'projects_locations_connections_eventSubscriptions'

    def __init__(self, client):
      super(ConnectorsV1.ProjectsLocationsConnectionsEventSubscriptionsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new EventSubscription in a given project,location and connection.

      Args:
        request: (ConnectorsProjectsLocationsConnectionsEventSubscriptionsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/connections/{connectionsId}/eventSubscriptions',
        http_method='POST',
        method_id='connectors.projects.locations.connections.eventSubscriptions.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['eventSubscriptionId'],
        relative_path='v1/{+parent}/eventSubscriptions',
        request_field='eventSubscription',
        request_type_name='ConnectorsProjectsLocationsConnectionsEventSubscriptionsCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single EventSubscription.

      Args:
        request: (ConnectorsProjectsLocationsConnectionsEventSubscriptionsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/connections/{connectionsId}/eventSubscriptions/{eventSubscriptionsId}',
        http_method='DELETE',
        method_id='connectors.projects.locations.connections.eventSubscriptions.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ConnectorsProjectsLocationsConnectionsEventSubscriptionsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single EventSubscription.

      Args:
        request: (ConnectorsProjectsLocationsConnectionsEventSubscriptionsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (EventSubscription) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/connections/{connectionsId}/eventSubscriptions/{eventSubscriptionsId}',
        http_method='GET',
        method_id='connectors.projects.locations.connections.eventSubscriptions.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ConnectorsProjectsLocationsConnectionsEventSubscriptionsGetRequest',
        response_type_name='EventSubscription',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""List EventSubscriptions in a given project,location and connection.

      Args:
        request: (ConnectorsProjectsLocationsConnectionsEventSubscriptionsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListEventSubscriptionsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/connections/{connectionsId}/eventSubscriptions',
        http_method='GET',
        method_id='connectors.projects.locations.connections.eventSubscriptions.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1/{+parent}/eventSubscriptions',
        request_field='',
        request_type_name='ConnectorsProjectsLocationsConnectionsEventSubscriptionsListRequest',
        response_type_name='ListEventSubscriptionsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the parameters of a single EventSubscription.

      Args:
        request: (ConnectorsProjectsLocationsConnectionsEventSubscriptionsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/connections/{connectionsId}/eventSubscriptions/{eventSubscriptionsId}',
        http_method='PATCH',
        method_id='connectors.projects.locations.connections.eventSubscriptions.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1/{+name}',
        request_field='eventSubscription',
        request_type_name='ConnectorsProjectsLocationsConnectionsEventSubscriptionsPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Retry(self, request, global_params=None):
      r"""RetryEventSubscription retries the registration of Subscription.

      Args:
        request: (ConnectorsProjectsLocationsConnectionsEventSubscriptionsRetryRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Retry')
      return self._RunMethod(
          config, request, global_params=global_params)

    Retry.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/connections/{connectionsId}/eventSubscriptions/{eventSubscriptionsId}:retry',
        http_method='POST',
        method_id='connectors.projects.locations.connections.eventSubscriptions.retry',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}:retry',
        request_field='retryEventSubscriptionRequest',
        request_type_name='ConnectorsProjectsLocationsConnectionsEventSubscriptionsRetryRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsLocationsConnectionsRuntimeActionSchemasService(base_api.BaseApiService):
    """Service class for the projects_locations_connections_runtimeActionSchemas resource."""

    _NAME = 'projects_locations_connections_runtimeActionSchemas'

    def __init__(self, client):
      super(ConnectorsV1.ProjectsLocationsConnectionsRuntimeActionSchemasService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""List schema of a runtime actions filtered by action name.

      Args:
        request: (ConnectorsProjectsLocationsConnectionsRuntimeActionSchemasListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListRuntimeActionSchemasResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/connections/{connectionsId}/runtimeActionSchemas',
        http_method='GET',
        method_id='connectors.projects.locations.connections.runtimeActionSchemas.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v1/{+parent}/runtimeActionSchemas',
        request_field='',
        request_type_name='ConnectorsProjectsLocationsConnectionsRuntimeActionSchemasListRequest',
        response_type_name='ListRuntimeActionSchemasResponse',
        supports_download=False,
    )

  class ProjectsLocationsConnectionsRuntimeEntitySchemasService(base_api.BaseApiService):
    """Service class for the projects_locations_connections_runtimeEntitySchemas resource."""

    _NAME = 'projects_locations_connections_runtimeEntitySchemas'

    def __init__(self, client):
      super(ConnectorsV1.ProjectsLocationsConnectionsRuntimeEntitySchemasService, self).__init__(client)
      self._upload_configs = {
          }

    def List(self, request, global_params=None):
      r"""List schema of a runtime entities filtered by entity name.

      Args:
        request: (ConnectorsProjectsLocationsConnectionsRuntimeEntitySchemasListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListRuntimeEntitySchemasResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/connections/{connectionsId}/runtimeEntitySchemas',
        http_method='GET',
        method_id='connectors.projects.locations.connections.runtimeEntitySchemas.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v1/{+parent}/runtimeEntitySchemas',
        request_field='',
        request_type_name='ConnectorsProjectsLocationsConnectionsRuntimeEntitySchemasListRequest',
        response_type_name='ListRuntimeEntitySchemasResponse',
        supports_download=False,
    )

  class ProjectsLocationsConnectionsService(base_api.BaseApiService):
    """Service class for the projects_locations_connections resource."""

    _NAME = 'projects_locations_connections'

    def __init__(self, client):
      super(ConnectorsV1.ProjectsLocationsConnectionsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new Connection in a given project and location.

      Args:
        request: (ConnectorsProjectsLocationsConnectionsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/connections',
        http_method='POST',
        method_id='connectors.projects.locations.connections.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['connectionId'],
        relative_path='v1/{+parent}/connections',
        request_field='connection',
        request_type_name='ConnectorsProjectsLocationsConnectionsCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single Connection.

      Args:
        request: (ConnectorsProjectsLocationsConnectionsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/connections/{connectionsId}',
        http_method='DELETE',
        method_id='connectors.projects.locations.connections.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ConnectorsProjectsLocationsConnectionsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single Connection.

      Args:
        request: (ConnectorsProjectsLocationsConnectionsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Connection) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/connections/{connectionsId}',
        http_method='GET',
        method_id='connectors.projects.locations.connections.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['view'],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ConnectorsProjectsLocationsConnectionsGetRequest',
        response_type_name='Connection',
        supports_download=False,
    )

    def GetConnectionSchemaMetadata(self, request, global_params=None):
      r"""Gets schema metadata of a connection. SchemaMetadata is a singleton resource for each connection.

      Args:
        request: (ConnectorsProjectsLocationsConnectionsGetConnectionSchemaMetadataRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ConnectionSchemaMetadata) The response message.
      """
      config = self.GetMethodConfig('GetConnectionSchemaMetadata')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetConnectionSchemaMetadata.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/connections/{connectionsId}/connectionSchemaMetadata',
        http_method='GET',
        method_id='connectors.projects.locations.connections.getConnectionSchemaMetadata',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ConnectorsProjectsLocationsConnectionsGetConnectionSchemaMetadataRequest',
        response_type_name='ConnectionSchemaMetadata',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. Returns an empty policy if the resource exists and does not have a policy set.

      Args:
        request: (ConnectorsProjectsLocationsConnectionsGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/connections/{connectionsId}:getIamPolicy',
        http_method='GET',
        method_id='connectors.projects.locations.connections.getIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=['options_requestedPolicyVersion'],
        relative_path='v1/{+resource}:getIamPolicy',
        request_field='',
        request_type_name='ConnectorsProjectsLocationsConnectionsGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists Connections in a given project and location.

      Args:
        request: (ConnectorsProjectsLocationsConnectionsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListConnectionsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/connections',
        http_method='GET',
        method_id='connectors.projects.locations.connections.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken', 'view'],
        relative_path='v1/{+parent}/connections',
        request_field='',
        request_type_name='ConnectorsProjectsLocationsConnectionsListRequest',
        response_type_name='ListConnectionsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the parameters of a single Connection.

      Args:
        request: (ConnectorsProjectsLocationsConnectionsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/connections/{connectionsId}',
        http_method='PATCH',
        method_id='connectors.projects.locations.connections.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1/{+name}',
        request_field='connection',
        request_type_name='ConnectorsProjectsLocationsConnectionsPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def RepairEventing(self, request, global_params=None):
      r"""RepaiEventing tries to repair eventing related event subscriptions.

      Args:
        request: (ConnectorsProjectsLocationsConnectionsRepairEventingRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('RepairEventing')
      return self._RunMethod(
          config, request, global_params=global_params)

    RepairEventing.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/connections/{connectionsId}:repairEventing',
        http_method='POST',
        method_id='connectors.projects.locations.connections.repairEventing',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}:repairEventing',
        request_field='repairEventingRequest',
        request_type_name='ConnectorsProjectsLocationsConnectionsRepairEventingRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.

      Args:
        request: (ConnectorsProjectsLocationsConnectionsSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/connections/{connectionsId}:setIamPolicy',
        http_method='POST',
        method_id='connectors.projects.locations.connections.setIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1/{+resource}:setIamPolicy',
        request_field='setIamPolicyRequest',
        request_type_name='ConnectorsProjectsLocationsConnectionsSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource. If the resource does not exist, this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This operation is designed to be used for building permission-aware UIs and command-line tools, not for authorization checking. This operation may "fail open" without warning.

      Args:
        request: (ConnectorsProjectsLocationsConnectionsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/connections/{connectionsId}:testIamPermissions',
        http_method='POST',
        method_id='connectors.projects.locations.connections.testIamPermissions',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1/{+resource}:testIamPermissions',
        request_field='testIamPermissionsRequest',
        request_type_name='ConnectorsProjectsLocationsConnectionsTestIamPermissionsRequest',
        response_type_name='TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsEndpointAttachmentsService(base_api.BaseApiService):
    """Service class for the projects_locations_endpointAttachments resource."""

    _NAME = 'projects_locations_endpointAttachments'

    def __init__(self, client):
      super(ConnectorsV1.ProjectsLocationsEndpointAttachmentsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new EndpointAttachment in a given project and location.

      Args:
        request: (ConnectorsProjectsLocationsEndpointAttachmentsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/endpointAttachments',
        http_method='POST',
        method_id='connectors.projects.locations.endpointAttachments.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['endpointAttachmentId'],
        relative_path='v1/{+parent}/endpointAttachments',
        request_field='endpointAttachment',
        request_type_name='ConnectorsProjectsLocationsEndpointAttachmentsCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single EndpointAttachment.

      Args:
        request: (ConnectorsProjectsLocationsEndpointAttachmentsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/endpointAttachments/{endpointAttachmentsId}',
        http_method='DELETE',
        method_id='connectors.projects.locations.endpointAttachments.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ConnectorsProjectsLocationsEndpointAttachmentsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single EndpointAttachment.

      Args:
        request: (ConnectorsProjectsLocationsEndpointAttachmentsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (EndpointAttachment) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/endpointAttachments/{endpointAttachmentsId}',
        http_method='GET',
        method_id='connectors.projects.locations.endpointAttachments.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ConnectorsProjectsLocationsEndpointAttachmentsGetRequest',
        response_type_name='EndpointAttachment',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""List EndpointAttachments in a given project.

      Args:
        request: (ConnectorsProjectsLocationsEndpointAttachmentsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListEndpointAttachmentsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/endpointAttachments',
        http_method='GET',
        method_id='connectors.projects.locations.endpointAttachments.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1/{+parent}/endpointAttachments',
        request_field='',
        request_type_name='ConnectorsProjectsLocationsEndpointAttachmentsListRequest',
        response_type_name='ListEndpointAttachmentsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the parameters of a single EndpointAttachment.

      Args:
        request: (ConnectorsProjectsLocationsEndpointAttachmentsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/endpointAttachments/{endpointAttachmentsId}',
        http_method='PATCH',
        method_id='connectors.projects.locations.endpointAttachments.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1/{+name}',
        request_field='endpointAttachment',
        request_type_name='ConnectorsProjectsLocationsEndpointAttachmentsPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsLocationsGlobalManagedZonesService(base_api.BaseApiService):
    """Service class for the projects_locations_global_managedZones resource."""

    _NAME = 'projects_locations_global_managedZones'

    def __init__(self, client):
      super(ConnectorsV1.ProjectsLocationsGlobalManagedZonesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new ManagedZone in a given project and location.

      Args:
        request: (ConnectorsProjectsLocationsGlobalManagedZonesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/global/managedZones',
        http_method='POST',
        method_id='connectors.projects.locations.global.managedZones.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['managedZoneId'],
        relative_path='v1/{+parent}/managedZones',
        request_field='managedZone',
        request_type_name='ConnectorsProjectsLocationsGlobalManagedZonesCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single ManagedZone.

      Args:
        request: (ConnectorsProjectsLocationsGlobalManagedZonesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/global/managedZones/{managedZonesId}',
        http_method='DELETE',
        method_id='connectors.projects.locations.global.managedZones.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ConnectorsProjectsLocationsGlobalManagedZonesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single ManagedZone.

      Args:
        request: (ConnectorsProjectsLocationsGlobalManagedZonesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ManagedZone) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/global/managedZones/{managedZonesId}',
        http_method='GET',
        method_id='connectors.projects.locations.global.managedZones.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ConnectorsProjectsLocationsGlobalManagedZonesGetRequest',
        response_type_name='ManagedZone',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""List ManagedZones in a given project.

      Args:
        request: (ConnectorsProjectsLocationsGlobalManagedZonesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListManagedZonesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/global/managedZones',
        http_method='GET',
        method_id='connectors.projects.locations.global.managedZones.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1/{+parent}/managedZones',
        request_field='',
        request_type_name='ConnectorsProjectsLocationsGlobalManagedZonesListRequest',
        response_type_name='ListManagedZonesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the parameters of a single ManagedZone.

      Args:
        request: (ConnectorsProjectsLocationsGlobalManagedZonesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/global/managedZones/{managedZonesId}',
        http_method='PATCH',
        method_id='connectors.projects.locations.global.managedZones.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1/{+name}',
        request_field='managedZone',
        request_type_name='ConnectorsProjectsLocationsGlobalManagedZonesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsLocationsGlobalService(base_api.BaseApiService):
    """Service class for the projects_locations_global resource."""

    _NAME = 'projects_locations_global'

    def __init__(self, client):
      super(ConnectorsV1.ProjectsLocationsGlobalService, self).__init__(client)
      self._upload_configs = {
          }

    def GetSettings(self, request, global_params=None):
      r"""GetGlobalSettings gets settings of a project. GlobalSettings is a singleton resource.

      Args:
        request: (ConnectorsProjectsLocationsGlobalGetSettingsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Settings) The response message.
      """
      config = self.GetMethodConfig('GetSettings')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetSettings.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/global/settings',
        http_method='GET',
        method_id='connectors.projects.locations.global.getSettings',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ConnectorsProjectsLocationsGlobalGetSettingsRequest',
        response_type_name='Settings',
        supports_download=False,
    )

    def UpdateSettings(self, request, global_params=None):
      r"""Update the global settings of a project.

      Args:
        request: (ConnectorsProjectsLocationsGlobalUpdateSettingsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('UpdateSettings')
      return self._RunMethod(
          config, request, global_params=global_params)

    UpdateSettings.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/global/settings',
        http_method='PATCH',
        method_id='connectors.projects.locations.global.updateSettings',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['updateMask'],
        relative_path='v1/{+name}',
        request_field='settings',
        request_type_name='ConnectorsProjectsLocationsGlobalUpdateSettingsRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsLocationsOperationsService(base_api.BaseApiService):
    """Service class for the projects_locations_operations resource."""

    _NAME = 'projects_locations_operations'

    def __init__(self, client):
      super(ConnectorsV1.ProjectsLocationsOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Cancel(self, request, global_params=None):
      r"""Starts asynchronous cancellation on a long-running operation. The server makes a best effort to cancel the operation, but success is not guaranteed. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or other methods to check whether the cancellation succeeded or whether the operation completed despite cancellation. On successful cancellation, the operation is not deleted; instead, it becomes an operation with an Operation.error value with a google.rpc.Status.code of 1, corresponding to `Code.CANCELLED`.

      Args:
        request: (ConnectorsProjectsLocationsOperationsCancelRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Cancel')
      return self._RunMethod(
          config, request, global_params=global_params)

    Cancel.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}:cancel',
        http_method='POST',
        method_id='connectors.projects.locations.operations.cancel',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}:cancel',
        request_field='cancelOperationRequest',
        request_type_name='ConnectorsProjectsLocationsOperationsCancelRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a long-running operation. This method indicates that the client is no longer interested in the operation result. It does not cancel the operation. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.

      Args:
        request: (ConnectorsProjectsLocationsOperationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}',
        http_method='DELETE',
        method_id='connectors.projects.locations.operations.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ConnectorsProjectsLocationsOperationsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.

      Args:
        request: (ConnectorsProjectsLocationsOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}',
        http_method='GET',
        method_id='connectors.projects.locations.operations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ConnectorsProjectsLocationsOperationsGetRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.

      Args:
        request: (ConnectorsProjectsLocationsOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListOperationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/operations',
        http_method='GET',
        method_id='connectors.projects.locations.operations.list',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v1/{+name}/operations',
        request_field='',
        request_type_name='ConnectorsProjectsLocationsOperationsListRequest',
        response_type_name='ListOperationsResponse',
        supports_download=False,
    )

  class ProjectsLocationsProvidersConnectorsVersionsEventtypesService(base_api.BaseApiService):
    """Service class for the projects_locations_providers_connectors_versions_eventtypes resource."""

    _NAME = 'projects_locations_providers_connectors_versions_eventtypes'

    def __init__(self, client):
      super(ConnectorsV1.ProjectsLocationsProvidersConnectorsVersionsEventtypesService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets details of a single event type.

      Args:
        request: (ConnectorsProjectsLocationsProvidersConnectorsVersionsEventtypesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (EventType) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/providers/{providersId}/connectors/{connectorsId}/versions/{versionsId}/eventtypes/{eventtypesId}',
        http_method='GET',
        method_id='connectors.projects.locations.providers.connectors.versions.eventtypes.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ConnectorsProjectsLocationsProvidersConnectorsVersionsEventtypesGetRequest',
        response_type_name='EventType',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists Event Types in a given Connector Version.

      Args:
        request: (ConnectorsProjectsLocationsProvidersConnectorsVersionsEventtypesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListEventTypesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/providers/{providersId}/connectors/{connectorsId}/versions/{versionsId}/eventtypes',
        http_method='GET',
        method_id='connectors.projects.locations.providers.connectors.versions.eventtypes.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1/{+parent}/eventtypes',
        request_field='',
        request_type_name='ConnectorsProjectsLocationsProvidersConnectorsVersionsEventtypesListRequest',
        response_type_name='ListEventTypesResponse',
        supports_download=False,
    )

  class ProjectsLocationsProvidersConnectorsVersionsService(base_api.BaseApiService):
    """Service class for the projects_locations_providers_connectors_versions resource."""

    _NAME = 'projects_locations_providers_connectors_versions'

    def __init__(self, client):
      super(ConnectorsV1.ProjectsLocationsProvidersConnectorsVersionsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets details of a single connector version.

      Args:
        request: (ConnectorsProjectsLocationsProvidersConnectorsVersionsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ConnectorVersion) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/providers/{providersId}/connectors/{connectorsId}/versions/{versionsId}',
        http_method='GET',
        method_id='connectors.projects.locations.providers.connectors.versions.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['view'],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ConnectorsProjectsLocationsProvidersConnectorsVersionsGetRequest',
        response_type_name='ConnectorVersion',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists Connector Versions in a given project and location.

      Args:
        request: (ConnectorsProjectsLocationsProvidersConnectorsVersionsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListConnectorVersionsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/providers/{providersId}/connectors/{connectorsId}/versions',
        http_method='GET',
        method_id='connectors.projects.locations.providers.connectors.versions.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken', 'view'],
        relative_path='v1/{+parent}/versions',
        request_field='',
        request_type_name='ConnectorsProjectsLocationsProvidersConnectorsVersionsListRequest',
        response_type_name='ListConnectorVersionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsProvidersConnectorsService(base_api.BaseApiService):
    """Service class for the projects_locations_providers_connectors resource."""

    _NAME = 'projects_locations_providers_connectors'

    def __init__(self, client):
      super(ConnectorsV1.ProjectsLocationsProvidersConnectorsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets details of a single Connector.

      Args:
        request: (ConnectorsProjectsLocationsProvidersConnectorsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Connector) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/providers/{providersId}/connectors/{connectorsId}',
        http_method='GET',
        method_id='connectors.projects.locations.providers.connectors.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ConnectorsProjectsLocationsProvidersConnectorsGetRequest',
        response_type_name='Connector',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists Connectors in a given project and location.

      Args:
        request: (ConnectorsProjectsLocationsProvidersConnectorsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListConnectorsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/providers/{providersId}/connectors',
        http_method='GET',
        method_id='connectors.projects.locations.providers.connectors.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v1/{+parent}/connectors',
        request_field='',
        request_type_name='ConnectorsProjectsLocationsProvidersConnectorsListRequest',
        response_type_name='ListConnectorsResponse',
        supports_download=False,
    )

  class ProjectsLocationsProvidersService(base_api.BaseApiService):
    """Service class for the projects_locations_providers resource."""

    _NAME = 'projects_locations_providers'

    def __init__(self, client):
      super(ConnectorsV1.ProjectsLocationsProvidersService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets details of a provider.

      Args:
        request: (ConnectorsProjectsLocationsProvidersGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Provider) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/providers/{providersId}',
        http_method='GET',
        method_id='connectors.projects.locations.providers.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ConnectorsProjectsLocationsProvidersGetRequest',
        response_type_name='Provider',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. Returns an empty policy if the resource exists and does not have a policy set.

      Args:
        request: (ConnectorsProjectsLocationsProvidersGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/providers/{providersId}:getIamPolicy',
        http_method='GET',
        method_id='connectors.projects.locations.providers.getIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=['options_requestedPolicyVersion'],
        relative_path='v1/{+resource}:getIamPolicy',
        request_field='',
        request_type_name='ConnectorsProjectsLocationsProvidersGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists Providers in a given project and location.

      Args:
        request: (ConnectorsProjectsLocationsProvidersListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListProvidersResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/providers',
        http_method='GET',
        method_id='connectors.projects.locations.providers.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1/{+parent}/providers',
        request_field='',
        request_type_name='ConnectorsProjectsLocationsProvidersListRequest',
        response_type_name='ListProvidersResponse',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.

      Args:
        request: (ConnectorsProjectsLocationsProvidersSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/providers/{providersId}:setIamPolicy',
        http_method='POST',
        method_id='connectors.projects.locations.providers.setIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1/{+resource}:setIamPolicy',
        request_field='setIamPolicyRequest',
        request_type_name='ConnectorsProjectsLocationsProvidersSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource. If the resource does not exist, this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This operation is designed to be used for building permission-aware UIs and command-line tools, not for authorization checking. This operation may "fail open" without warning.

      Args:
        request: (ConnectorsProjectsLocationsProvidersTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/providers/{providersId}:testIamPermissions',
        http_method='POST',
        method_id='connectors.projects.locations.providers.testIamPermissions',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1/{+resource}:testIamPermissions',
        request_field='testIamPermissionsRequest',
        request_type_name='ConnectorsProjectsLocationsProvidersTestIamPermissionsRequest',
        response_type_name='TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsService(base_api.BaseApiService):
    """Service class for the projects_locations resource."""

    _NAME = 'projects_locations'

    def __init__(self, client):
      super(ConnectorsV1.ProjectsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets information about a location.

      Args:
        request: (ConnectorsProjectsLocationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Location) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}',
        http_method='GET',
        method_id='connectors.projects.locations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ConnectorsProjectsLocationsGetRequest',
        response_type_name='Location',
        supports_download=False,
    )

    def GetRuntimeConfig(self, request, global_params=None):
      r"""Gets the runtimeConfig of a location. RuntimeConfig is a singleton resource for each location.

      Args:
        request: (ConnectorsProjectsLocationsGetRuntimeConfigRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (RuntimeConfig) The response message.
      """
      config = self.GetMethodConfig('GetRuntimeConfig')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetRuntimeConfig.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations/{locationsId}/runtimeConfig',
        http_method='GET',
        method_id='connectors.projects.locations.getRuntimeConfig',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1/{+name}',
        request_field='',
        request_type_name='ConnectorsProjectsLocationsGetRuntimeConfigRequest',
        response_type_name='RuntimeConfig',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists information about the supported locations for this service.

      Args:
        request: (ConnectorsProjectsLocationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListLocationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1/projects/{projectsId}/locations',
        http_method='GET',
        method_id='connectors.projects.locations.list',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['filter', 'pageSize', 'pageToken'],
        relative_path='v1/{+name}/locations',
        request_field='',
        request_type_name='ConnectorsProjectsLocationsListRequest',
        response_type_name='ListLocationsResponse',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = 'projects'

    def __init__(self, client):
      super(ConnectorsV1.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }
