/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.event;

import edu.umd.cs.piccolo.activities.PActivity;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.util.PUtil;
import java.awt.geom.Point2D;

public abstract class PDragSequenceEventHandler
extends PBasicInputEventHandler {
    private double minDragStartDistance = 0.0;
    private transient boolean isDragging = false;
    private transient Point2D mousePressedCanvasPoint;
    private transient PActivity dragActivity;
    private transient PInputEvent dragEvent;
    private transient int sequenceInitiatedButton = 0;

    public boolean isDragging() {
        return this.isDragging;
    }

    public void setIsDragging(boolean bl) {
        this.isDragging = bl;
    }

    public double getMinDragStartDistance() {
        return this.minDragStartDistance;
    }

    public void setMinDragStartDistance(double d) {
        this.minDragStartDistance = d;
    }

    public Point2D getMousePressedCanvasPoint() {
        if (this.mousePressedCanvasPoint == null) {
            this.mousePressedCanvasPoint = new Point2D.Double();
        }
        return this.mousePressedCanvasPoint;
    }

    protected void startDrag(PInputEvent pInputEvent) {
        this.dragEvent = pInputEvent;
        this.startDragActivity(pInputEvent);
        this.setIsDragging(true);
        pInputEvent.getComponent().setInteracting(true);
    }

    protected void drag(PInputEvent pInputEvent) {
        this.dragEvent = pInputEvent;
    }

    protected void endDrag(PInputEvent pInputEvent) {
        this.stopDragActivity(pInputEvent);
        this.dragEvent = null;
        pInputEvent.getComponent().setInteracting(false);
        this.setIsDragging(false);
    }

    protected boolean shouldStartDragInteraction(PInputEvent pInputEvent) {
        return this.getMousePressedCanvasPoint().distance(pInputEvent.getCanvasPosition()) >= this.getMinDragStartDistance();
    }

    protected PActivity getDragActivity() {
        return this.dragActivity;
    }

    protected void startDragActivity(PInputEvent pInputEvent) {
        this.dragActivity = new PActivity(-1L, PUtil.DEFAULT_ACTIVITY_STEP_RATE);
        this.dragActivity.setDelegate(new PActivity.PActivityDelegate(){

            public void activityStarted(PActivity pActivity) {
                PDragSequenceEventHandler.this.dragActivityFirstStep(PDragSequenceEventHandler.this.dragEvent);
            }

            public void activityStepped(PActivity pActivity) {
                PDragSequenceEventHandler.this.dragActivityStep(PDragSequenceEventHandler.this.dragEvent);
            }

            public void activityFinished(PActivity pActivity) {
                PDragSequenceEventHandler.this.dragActivityFinalStep(PDragSequenceEventHandler.this.dragEvent);
            }
        });
        pInputEvent.getCamera().getRoot().addActivity(this.dragActivity);
    }

    protected void stopDragActivity(PInputEvent pInputEvent) {
        this.dragActivity.terminate();
        this.dragActivity = null;
    }

    protected void dragActivityFirstStep(PInputEvent pInputEvent) {
    }

    protected void dragActivityStep(PInputEvent pInputEvent) {
    }

    protected void dragActivityFinalStep(PInputEvent pInputEvent) {
    }

    public void mousePressed(PInputEvent pInputEvent) {
        super.mousePressed(pInputEvent);
        if (this.sequenceInitiatedButton != 0) {
            return;
        }
        this.sequenceInitiatedButton = pInputEvent.getButton();
        this.getMousePressedCanvasPoint().setLocation(pInputEvent.getCanvasPosition());
        if (!this.isDragging() && this.shouldStartDragInteraction(pInputEvent)) {
            this.startDrag(pInputEvent);
        }
    }

    public void mouseDragged(PInputEvent pInputEvent) {
        super.mouseDragged(pInputEvent);
        if (this.sequenceInitiatedButton != 0) {
            if (!this.isDragging()) {
                if (this.shouldStartDragInteraction(pInputEvent)) {
                    this.startDrag(pInputEvent);
                }
                return;
            }
            this.drag(pInputEvent);
        }
    }

    public void mouseReleased(PInputEvent pInputEvent) {
        super.mouseReleased(pInputEvent);
        if (this.sequenceInitiatedButton == pInputEvent.getButton()) {
            if (this.isDragging()) {
                this.endDrag(pInputEvent);
            }
            this.sequenceInitiatedButton = 0;
        }
    }

    protected String paramString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("minDragStartDistance=" + this.minDragStartDistance);
        stringBuffer.append(",mousePressedCanvasPoint=" + (this.mousePressedCanvasPoint == null ? "null" : this.mousePressedCanvasPoint.toString()));
        stringBuffer.append(",sequenceInitiatedButton=" + this.sequenceInitiatedButton);
        if (this.isDragging) {
            stringBuffer.append(",dragging");
        }
        stringBuffer.append(',');
        stringBuffer.append(super.paramString());
        return stringBuffer.toString();
    }
}

