/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.firestore.collection;

import com.google.api.core.InternalApi;
import java.util.Comparator;

@InternalApi
public interface LLRBNode<K, V> {
    public LLRBNode<K, V> copy(K var1, V var2, Color var3, LLRBNode<K, V> var4, LLRBNode<K, V> var5);

    public LLRBNode<K, V> insert(K var1, V var2, Comparator<K> var3);

    public LLRBNode<K, V> remove(K var1, Comparator<K> var2);

    public boolean isEmpty();

    public boolean isRed();

    public K getKey();

    public V getValue();

    public LLRBNode<K, V> getLeft();

    public LLRBNode<K, V> getRight();

    public LLRBNode<K, V> getMin();

    public LLRBNode<K, V> getMax();

    public int size();

    public void inOrderTraversal(NodeVisitor<K, V> var1);

    public boolean shortCircuitingInOrderTraversal(ShortCircuitingNodeVisitor<K, V> var1);

    public boolean shortCircuitingReverseOrderTraversal(ShortCircuitingNodeVisitor<K, V> var1);

    public static enum Color {
        RED,
        BLACK;

    }

    public static abstract class NodeVisitor<K, V>
    implements ShortCircuitingNodeVisitor<K, V> {
        @Override
        public boolean shouldContinue(K key, V value) {
            this.visitEntry(key, value);
            return true;
        }

        public abstract void visitEntry(K var1, V var2);
    }

    public static interface ShortCircuitingNodeVisitor<K, V> {
        public boolean shouldContinue(K var1, V var2);
    }
}

