/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.fasttrack;

import java.io.PrintWriter;
import net.sf.mpxj.fasttrack.AbstractColumn;
import net.sf.mpxj.fasttrack.FastTrackUtility;
import net.sf.mpxj.fasttrack.FixedSizeItemsBlock;
import net.sf.mpxj.fasttrack.StringsWithLengthBlock;

class CalendarColumn
extends AbstractColumn {
    private String[] m_options;

    CalendarColumn() {
    }

    @Override
    protected int postHeaderSkipBytes() {
        return 34;
    }

    @Override
    protected int readData(byte[] byArray, int n) {
        StringsWithLengthBlock stringsWithLengthBlock = new StringsWithLengthBlock().read(byArray, n, false);
        this.m_options = stringsWithLengthBlock.getData();
        n = stringsWithLengthBlock.getOffset();
        FixedSizeItemsBlock fixedSizeItemsBlock = new FixedSizeItemsBlock().read(byArray, n += 10);
        n = fixedSizeItemsBlock.getOffset();
        byte[][] byArray2 = fixedSizeItemsBlock.getData();
        this.m_data = new String[byArray2.length];
        for (int i = 0; i < byArray2.length; ++i) {
            int n2 = FastTrackUtility.getInt(byArray2[i], 0);
            if (n2 < 0 || n2 >= this.m_options.length) continue;
            this.m_data[i] = this.m_options[n2];
        }
        return n;
    }

    @Override
    protected void dumpData(PrintWriter printWriter) {
        printWriter.println("  [Options");
        for (String object : this.m_options) {
            printWriter.println("    " + object);
        }
        printWriter.println("  ]");
        printWriter.println("  [Data");
        for (Object object : this.m_data) {
            printWriter.println("    " + String.valueOf(object));
        }
        printWriter.println("  ]");
    }
}

