/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.dialog.util;

import com.projectlibre1.dialog.LookupDialog;
import com.projectlibre1.field.Field;
import com.projectlibre1.pm.graphic.IconManager;
import com.projectlibre1.strings.Messages;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class LookupField
extends JPanel {
    JLabel display;
    JButton button;
    String value;
    protected EventListenerList listenerList = new EventListenerList();

    public LookupField(Field field, Object object) {
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.setLayout(new BoxLayout(this, 0));
        this.value = (String)object;
        this.button = this.createLookupButton(field);
        this.add(this.button);
        this.button.setAlignmentY(0.5f);
        this.button.setAlignmentX(0.0f);
        this.display = new JLabel();
        this.add(this.display);
        this.setText(this.value);
    }

    public void setText(String string) {
        if (string == null) {
            this.display.setText("");
        } else {
            int n = string.indexOf("\\") + 1;
            String string2 = string.substring(n);
            this.display.setText(string2);
        }
    }

    private JButton createLookupButton(final Field field) {
        JButton jButton = new JButton();
        jButton.setToolTipText(Messages.getString("LookupField.LookupAValue"));
        ImageIcon imageIcon = IconManager.getIcon("menu.find");
        jButton.setIcon(imageIcon);
        jButton.addActionListener(new ActionListener(){
            final /* synthetic */ LookupField this$0;
            {
                this.this$0 = lookupField;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String[] stringArray = LookupDialog.getKeyAndValue(field);
                if (stringArray == null) {
                    return;
                }
                this.this$0.value = stringArray[0] == null ? null : stringArray[0] + "\\" + stringArray[1];
                this.this$0.setText(this.this$0.value);
                this.this$0.fire();
            }
        });
        return jButton;
    }

    public String getValue() {
        return this.value;
    }

    public String getText() {
        return this.value;
    }

    public JLabel getDisplay() {
        return this.display;
    }

    public void setDisplay(JLabel jLabel) {
        this.display = jLabel;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    private void fire() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }
}

