/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (12 & (- ivec3(-36, 32, -88))) => ivec3(4, 0, 8)
 * (12 & (- ivec3(36, 32, 88))) => ivec3(12, 0, 8)
 * (12 & (- ivec3(59, 77, 68))) => ivec3(4, 0, 12)
 * (-6 & (- ivec3(-36, 32, -88))) => ivec3(32, -32, 88)
 * (-6 & (- ivec3(36, 32, 88))) => ivec3(-40, -32, -88)
 * (-6 & (- ivec3(59, 77, 68))) => ivec3(-64, -78, -72)
 * (76 & (- ivec3(-36, 32, -88))) => ivec3(4, 64, 72)
 * (76 & (- ivec3(36, 32, 88))) => ivec3(76, 64, 8)
 * (76 & (- ivec3(59, 77, 68))) => ivec3(68, 0, 12)
 * (-32 & (- ivec3(-36, 32, -88))) => ivec3(32, -32, 64)
 * (-32 & (- ivec3(36, 32, 88))) => ivec3(-64, -32, -96)
 * (-32 & (- ivec3(59, 77, 68))) => ivec3(-64, -96, -96)
 * (0 & (- ivec3(-36, 32, -88))) => ivec3(0, 0, 0)
 * (0 & (- ivec3(36, 32, 88))) => ivec3(0, 0, 0)
 * (0 & (- ivec3(59, 77, 68))) => ivec3(0, 0, 0)
 */
#version 150

void main()
{
  float[all(equal((12 & (- ivec3(-36, 32, -88))), ivec3(4, 0, 8))) ? 1 : -1] array0;
  float[all(equal((12 & (- ivec3(36, 32, 88))), ivec3(12, 0, 8))) ? 1 : -1] array1;
  float[all(equal((12 & (- ivec3(59, 77, 68))), ivec3(4, 0, 12))) ? 1 : -1] array2;
  float[all(equal((-6 & (- ivec3(-36, 32, -88))), ivec3(32, -32, 88))) ? 1 : -1] array3;
  float[all(equal((-6 & (- ivec3(36, 32, 88))), ivec3(-40, -32, -88))) ? 1 : -1] array4;
  float[all(equal((-6 & (- ivec3(59, 77, 68))), ivec3(-64, -78, -72))) ? 1 : -1] array5;
  float[all(equal((76 & (- ivec3(-36, 32, -88))), ivec3(4, 64, 72))) ? 1 : -1] array6;
  float[all(equal((76 & (- ivec3(36, 32, 88))), ivec3(76, 64, 8))) ? 1 : -1] array7;
  float[all(equal((76 & (- ivec3(59, 77, 68))), ivec3(68, 0, 12))) ? 1 : -1] array8;
  float[all(equal((-32 & (- ivec3(-36, 32, -88))), ivec3(32, -32, 64))) ? 1 : -1] array9;
  float[all(equal((-32 & (- ivec3(36, 32, 88))), ivec3(-64, -32, -96))) ? 1 : -1] array10;
  float[all(equal((-32 & (- ivec3(59, 77, 68))), ivec3(-64, -96, -96))) ? 1 : -1] array11;
  float[all(equal((0 & (- ivec3(-36, 32, -88))), ivec3(0, 0, 0))) ? 1 : -1] array12;
  float[all(equal((0 & (- ivec3(36, 32, 88))), ivec3(0, 0, 0))) ? 1 : -1] array13;
  float[all(equal((0 & (- ivec3(59, 77, 68))), ivec3(0, 0, 0))) ? 1 : -1] array14;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length());
}
