/*
 * Decompiled with CFR 0.152.
 */
package javax.comm;

import java.io.FileDescriptor;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.comm.CommDriver;
import javax.comm.CommPort;
import javax.comm.CommPortOwnershipListener;
import javax.comm.NoSuchPortException;
import javax.comm.PortInUseException;
import javax.comm.UnsupportedCommOperationException;
import org.eclipse.soda.dk.comm.NSCommDriver;
import org.eclipse.soda.dk.comm.internal.Library;

public class CommPortIdentifier {
    public static final int pollingTime = 1;
    public static final int PORT_SERIAL = 1;
    public static final int PORT_PARALLEL = 2;
    static CommDriver commDriver = null;
    static boolean initialized = false;
    static Hashtable identifiers = new Hashtable(4);
    String name = null;
    String currentOwner = null;
    boolean currentlyOwned = false;
    private List listeners;
    CommPort commPort = null;
    int type = 0;

    public static void addPortName(String portName, int portType, CommDriver commDriver) {
        identifiers.put(portName, new CommPortIdentifier(portName, portType));
    }

    public static CommPortIdentifier getPortIdentifier(CommPort port) throws NoSuchPortException {
        return CommPortIdentifier.getPortIdentifier(port.getName());
    }

    public static CommPortIdentifier getPortIdentifier(String portName) throws NoSuchPortException {
        Object comPortId = identifiers.get(portName);
        if (comPortId == null) {
            throw new NoSuchPortException();
        }
        return (CommPortIdentifier)comPortId;
    }

    public static Enumeration getPortIdentifiers() {
        return identifiers.elements();
    }

    private CommPortIdentifier(String id, int type) {
        this.name = id;
        this.type = type;
        this.listeners = new Vector();
    }

    public void addPortOwnershipListener(CommPortOwnershipListener listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public synchronized void closePort() {
        this.currentlyOwned = false;
        this.currentOwner = null;
        this.commPort = null;
        this.fireOwnershipEvent(2);
    }

    void fireOwnershipEvent(int eventType) {
        for (CommPortOwnershipListener listener : this.listeners) {
            listener.ownershipChange(eventType);
        }
    }

    public String getCurrentOwner() {
        return this.currentOwner;
    }

    public String getName() {
        return this.name;
    }

    public int getPortType() {
        return this.type;
    }

    synchronized void internalClosePort() {
        this.closePort();
    }

    public boolean isCurrentlyOwned() {
        return this.currentlyOwned;
    }

    public CommPort open(FileDescriptor fileDescriptor) throws UnsupportedCommOperationException {
        throw new UnsupportedCommOperationException("Opening port with FileDescriptor is not supported!");
    }

    public synchronized CommPort open(String appName, int timeout) throws PortInUseException {
        if (this.isCurrentlyOwned()) {
            PortInUseException piux = new PortInUseException(appName);
            piux.currentOwner = this.getCurrentOwner();
            throw piux;
        }
        this.currentOwner = appName;
        this.currentlyOwned = true;
        this.fireOwnershipEvent(3);
        return commDriver.getCommPort(this.getName(), this.getPortType());
    }

    public void removePortOwnershipListener(CommPortOwnershipListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    static {
        try {
            Library.load_dkcomm();
        }
        catch (UnsatisfiedLinkError e) {
            e.printStackTrace();
            System.exit(1);
        }
        if (!initialized) {
            commDriver = new NSCommDriver();
            commDriver.initialize();
            initialized = true;
        }
    }
}

