/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openxr;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.openxr.XrVector3f;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class XrSceneSphereBoundMSFT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CENTER;
    public static final int RADIUS;

    public XrSceneSphereBoundMSFT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), XrSceneSphereBoundMSFT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public XrVector3f center() {
        return XrSceneSphereBoundMSFT.ncenter(this.address());
    }

    public float radius() {
        return XrSceneSphereBoundMSFT.nradius(this.address());
    }

    public XrSceneSphereBoundMSFT center(XrVector3f value) {
        XrSceneSphereBoundMSFT.ncenter(this.address(), value);
        return this;
    }

    public XrSceneSphereBoundMSFT center(Consumer<XrVector3f> consumer) {
        consumer.accept(this.center());
        return this;
    }

    public XrSceneSphereBoundMSFT radius(float value) {
        XrSceneSphereBoundMSFT.nradius(this.address(), value);
        return this;
    }

    public XrSceneSphereBoundMSFT set(XrVector3f center, float radius) {
        this.center(center);
        this.radius(radius);
        return this;
    }

    public XrSceneSphereBoundMSFT set(XrSceneSphereBoundMSFT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static XrSceneSphereBoundMSFT malloc() {
        return (XrSceneSphereBoundMSFT)XrSceneSphereBoundMSFT.wrap(XrSceneSphereBoundMSFT.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static XrSceneSphereBoundMSFT calloc() {
        return (XrSceneSphereBoundMSFT)XrSceneSphereBoundMSFT.wrap(XrSceneSphereBoundMSFT.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static XrSceneSphereBoundMSFT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (XrSceneSphereBoundMSFT)XrSceneSphereBoundMSFT.wrap(XrSceneSphereBoundMSFT.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static XrSceneSphereBoundMSFT create(long address) {
        return (XrSceneSphereBoundMSFT)XrSceneSphereBoundMSFT.wrap(XrSceneSphereBoundMSFT.class, (long)address);
    }

    @Nullable
    public static XrSceneSphereBoundMSFT createSafe(long address) {
        return address == 0L ? null : (XrSceneSphereBoundMSFT)XrSceneSphereBoundMSFT.wrap(XrSceneSphereBoundMSFT.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)XrSceneSphereBoundMSFT.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)XrSceneSphereBoundMSFT.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)XrSceneSphereBoundMSFT.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = XrSceneSphereBoundMSFT.__create((int)capacity, (int)SIZEOF);
        return (Buffer)XrSceneSphereBoundMSFT.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)XrSceneSphereBoundMSFT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)XrSceneSphereBoundMSFT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static XrSceneSphereBoundMSFT malloc(MemoryStack stack) {
        return (XrSceneSphereBoundMSFT)XrSceneSphereBoundMSFT.wrap(XrSceneSphereBoundMSFT.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static XrSceneSphereBoundMSFT calloc(MemoryStack stack) {
        return (XrSceneSphereBoundMSFT)XrSceneSphereBoundMSFT.wrap(XrSceneSphereBoundMSFT.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)XrSceneSphereBoundMSFT.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)XrSceneSphereBoundMSFT.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static XrVector3f ncenter(long struct) {
        return XrVector3f.create(struct + (long)CENTER);
    }

    public static float nradius(long struct) {
        return UNSAFE.getFloat(null, struct + (long)RADIUS);
    }

    public static void ncenter(long struct, XrVector3f value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)CENTER), (long)XrVector3f.SIZEOF);
    }

    public static void nradius(long struct, float value) {
        UNSAFE.putFloat(null, struct + (long)RADIUS, value);
    }

    static {
        Struct.Layout layout = XrSceneSphereBoundMSFT.__struct((Struct.Member[])new Struct.Member[]{XrSceneSphereBoundMSFT.__member((int)XrVector3f.SIZEOF, (int)XrVector3f.ALIGNOF), XrSceneSphereBoundMSFT.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CENTER = layout.offsetof(0);
        RADIUS = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<XrSceneSphereBoundMSFT, Buffer>
    implements NativeResource {
        private static final XrSceneSphereBoundMSFT ELEMENT_FACTORY = XrSceneSphereBoundMSFT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected XrSceneSphereBoundMSFT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public XrVector3f center() {
            return XrSceneSphereBoundMSFT.ncenter(this.address());
        }

        public float radius() {
            return XrSceneSphereBoundMSFT.nradius(this.address());
        }

        public Buffer center(XrVector3f value) {
            XrSceneSphereBoundMSFT.ncenter(this.address(), value);
            return this;
        }

        public Buffer center(Consumer<XrVector3f> consumer) {
            consumer.accept(this.center());
            return this;
        }

        public Buffer radius(float value) {
            XrSceneSphereBoundMSFT.nradius(this.address(), value);
            return this;
        }
    }
}

