/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.binder.mpmetrics;

import io.quarkus.arc.ArcInvocationContext;
import io.quarkus.micrometer.runtime.binder.mpmetrics.ConcurrentGaugeImpl;
import io.quarkus.micrometer.runtime.binder.mpmetrics.MetricRegistryAdapter;
import io.quarkus.micrometer.runtime.binder.mpmetrics.MpMetadata;
import jakarta.annotation.Priority;
import jakarta.interceptor.AroundConstruct;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.annotation.ConcurrentGauge;

@ConcurrentGauge
@Interceptor
@Priority(value=1010)
class ConcurrentGaugeInterceptor {
    final MetricRegistryAdapter mpRegistry;

    ConcurrentGaugeInterceptor(MetricRegistryAdapter mpRegistry) {
        this.mpRegistry = mpRegistry;
    }

    @AroundConstruct
    Object cGaugeConstructor(ArcInvocationContext context) throws Exception {
        return this.cGauge(context, context.getConstructor().getDeclaringClass().getSimpleName());
    }

    @AroundInvoke
    Object cGaugeMethod(ArcInvocationContext context) throws Exception {
        return this.cGauge(context, context.getMethod().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object cGauge(ArcInvocationContext context, String methodName) throws Exception {
        ConcurrentGauge annotation = (ConcurrentGauge)context.findIterceptorBinding(ConcurrentGauge.class);
        if (annotation != null) {
            MpMetadata metadata = new MpMetadata(annotation.name().replace("<method>", methodName), annotation.description().replace("<method>", methodName), annotation.unit(), MetricType.CONCURRENT_GAUGE);
            ConcurrentGaugeImpl impl = this.mpRegistry.interceptorConcurrentGauge(metadata, annotation.tags());
            try {
                impl.inc();
                Object object = context.proceed();
                return object;
            }
            finally {
                impl.dec();
            }
        }
        return context.proceed();
    }
}

