/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.configuration.parsing.Element;
import org.infinispan.conflict.EntryMergePolicy;
import org.infinispan.conflict.MergePolicy;
import org.infinispan.partitionhandling.PartitionHandling;

public class PartitionHandlingConfiguration
extends ConfigurationElement<PartitionHandlingConfiguration> {
    public static final AttributeDefinition<PartitionHandling> WHEN_SPLIT = AttributeDefinition.builder((Enum)Attribute.WHEN_SPLIT, (Object)((Object)PartitionHandling.ALLOW_READ_WRITES)).immutable().build();
    public static final AttributeDefinition<EntryMergePolicy> MERGE_POLICY = AttributeDefinition.builder((Enum)Attribute.MERGE_POLICY, (Object)MergePolicy.NONE, EntryMergePolicy.class).immutable().build();

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(PartitionHandlingConfiguration.class, new AttributeDefinition[]{WHEN_SPLIT, MERGE_POLICY});
    }

    public PartitionHandlingConfiguration(AttributeSet attributes) {
        super((Enum)Element.PARTITION_HANDLING, attributes, new ConfigurationElement[0]);
    }

    public PartitionHandling whenSplit() {
        return (PartitionHandling)((Object)this.attributes.attribute(WHEN_SPLIT).get());
    }

    public EntryMergePolicy mergePolicy() {
        return (EntryMergePolicy)this.attributes.attribute(MERGE_POLICY).get();
    }

    public boolean resolveConflictsOnMerge() {
        EntryMergePolicy policy = this.mergePolicy();
        if (policy == MergePolicy.NONE) {
            return false;
        }
        return policy != null;
    }
}

