/*
 * Decompiled with CFR 0.152.
 */
package io.github.dmlloyd.classfile;

import io.github.dmlloyd.classfile.ClassFileTransform;
import io.github.dmlloyd.classfile.FieldBuilder;
import io.github.dmlloyd.classfile.FieldElement;
import io.github.dmlloyd.classfile.impl.TransformImpl;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;

@FunctionalInterface
public interface FieldTransform
extends ClassFileTransform<FieldTransform, FieldElement, FieldBuilder> {
    public static final FieldTransform ACCEPT_ALL = new FieldTransform(){

        @Override
        public void accept(FieldBuilder builder, FieldElement element) {
            builder.with(element);
        }
    };

    public static FieldTransform ofStateful(Supplier<FieldTransform> supplier) {
        return new TransformImpl.SupplierFieldTransform(Objects.requireNonNull(supplier));
    }

    public static FieldTransform endHandler(final Consumer<FieldBuilder> finisher) {
        Objects.requireNonNull(finisher);
        return new FieldTransform(){

            @Override
            public void accept(FieldBuilder builder, FieldElement element) {
                builder.with(element);
            }

            @Override
            public void atEnd(FieldBuilder builder) {
                finisher.accept(builder);
            }
        };
    }

    public static FieldTransform dropping(Predicate<FieldElement> filter) {
        Objects.requireNonNull(filter);
        return (b, e) -> {
            if (!filter.test((FieldElement)e)) {
                b.with(e);
            }
        };
    }

    @Override
    default public FieldTransform andThen(FieldTransform t) {
        return new TransformImpl.ChainedFieldTransform(this, Objects.requireNonNull(t));
    }
}

