/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.sql.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.metamodel.mapping.DiscriminatedAssociationModelPart;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.query.sqm.sql.SqmToSqlAstConverter;
import org.hibernate.query.sqm.sql.internal.AbstractSqmPathInterpretation;
import org.hibernate.query.sqm.tree.domain.SqmAnyValuedSimplePath;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.SqlTupleContainer;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.update.Assignable;

public class DiscriminatedAssociationPathInterpretation<T>
extends AbstractSqmPathInterpretation<T>
implements SqlTupleContainer,
Assignable {
    private final SqlTuple sqlTuple;

    public static <T> DiscriminatedAssociationPathInterpretation<T> from(SqmAnyValuedSimplePath<T> sqmPath, SqmToSqlAstConverter converter) {
        TableGroup tableGroup = converter.getFromClauseAccess().findTableGroup(sqmPath.getLhs().getNavigablePath());
        DiscriminatedAssociationModelPart mapping = (DiscriminatedAssociationModelPart)tableGroup.getModelPart().findSubPart(sqmPath.getReferencedPathSource().getPathName(), null);
        ArrayList tupleExpressions = new ArrayList();
        mapping.forEachSelectable((selectionIndex, selectableMapping) -> {
            TableReference tableReference = tableGroup.resolveTableReference(sqmPath.getNavigablePath(), selectableMapping.getContainingTableExpression());
            Expression expression = converter.getSqlExpressionResolver().resolveSqlExpression(tableReference, selectableMapping);
            tupleExpressions.add(expression);
        });
        return new DiscriminatedAssociationPathInterpretation<T>(sqmPath.getNavigablePath(), mapping, tableGroup, new SqlTuple(tupleExpressions, mapping));
    }

    private DiscriminatedAssociationPathInterpretation(NavigablePath navigablePath, ModelPart mapping, TableGroup tableGroup, SqlTuple sqlTuple) {
        super(navigablePath, mapping, tableGroup);
        this.sqlTuple = sqlTuple;
    }

    @Override
    public SqlTuple getSqlExpression() {
        return this.sqlTuple;
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        this.sqlTuple.accept(sqlTreeWalker);
    }

    @Override
    public SqlTuple getSqlTuple() {
        return this.sqlTuple;
    }

    @Override
    public List<ColumnReference> getColumnReferences() {
        ArrayList<ColumnReference> results = new ArrayList<ColumnReference>();
        this.visitColumnReferences(results::add);
        return results;
    }

    @Override
    public void visitColumnReferences(Consumer<ColumnReference> columnReferenceConsumer) {
        for (Expression expression : this.sqlTuple.getExpressions()) {
            if (!(expression instanceof ColumnReference)) {
                throw new IllegalArgumentException("Expecting ColumnReference, found : " + String.valueOf(expression));
            }
            columnReferenceConsumer.accept((ColumnReference)expression);
        }
    }
}

