/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.common.networking.ObjectMessage;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;

public class SpySettlementMessage
extends ObjectMessage {
    public static final String TAG = "spySettlement";
    private static final String SETTLEMENT_TAG = "settlement";
    private static final String UNIT_TAG = "unit";

    public SpySettlementMessage(Unit unit, Settlement settlement) {
        super(TAG, SETTLEMENT_TAG, settlement.getId(), UNIT_TAG, unit.getId());
        this.appendChild(settlement.getTile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpySettlementMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, SETTLEMENT_TAG, UNIT_TAG);
        FreeColXMLReader.ReadScope rs = xr.replaceScope(FreeColXMLReader.ReadScope.NOINTERN);
        Tile spyTile = null;
        try {
            while (xr.moreTags()) {
                String tag = xr.getLocalName();
                if ("tile".equals(tag)) {
                    if (spyTile == null) {
                        spyTile = xr.readFreeColObject(game, Tile.class);
                    } else {
                        this.expected(TAG, tag);
                    }
                } else {
                    this.expected("tile", tag);
                }
                xr.expectTag(tag);
            }
            xr.expectTag(TAG);
        }
        finally {
            xr.replaceScope(rs);
        }
        this.appendChild(spyTile);
    }

    private Tile getSpyTile() {
        return this.getChild(0, Tile.class);
    }

    private Unit getUnit(Player player) {
        return player.getOurFreeColGameObject(this.getStringAttribute(UNIT_TAG), Unit.class);
    }

    private Colony getColony(Game game) {
        return game.getFreeColGameObject(this.getStringAttribute(SETTLEMENT_TAG), Colony.class);
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.NORMAL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        Tile spyTile = this.getSpyTile();
        if (spyTile != null) {
            FreeColXMLWriter.WriteScope ws = xw.getWriteScope();
            if (xw.getClientPlayer() != null) {
                ws = xw.replaceScope(FreeColXMLWriter.WriteScope.toServer());
            }
            try {
                spyTile.toXML(xw);
            }
            finally {
                xw.replaceScope(ws);
            }
        }
    }

    @Override
    public void clientHandler(FreeColClient freeColClient) {
        Tile spyTile = this.getSpyTile();
        this.igc(freeColClient).spySettlementHandler(spyTile);
        this.clientGeneric(freeColClient);
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        Unit unit;
        ServerGame game = freeColServer.getGame();
        String unitId = this.getStringAttribute(UNIT_TAG);
        try {
            unit = this.getUnit(serverPlayer);
        }
        catch (Exception e) {
            return serverPlayer.clientError(e.getMessage());
        }
        if (!unit.hasAbility("model.ability.spyOnColony")) {
            return serverPlayer.clientError("Unit lacks ability to spy on colony: " + unitId);
        }
        String settlementId = this.getStringAttribute(SETTLEMENT_TAG);
        Colony colony = this.getColony(game);
        if (colony == null) {
            return serverPlayer.clientError("Not a colony: " + settlementId);
        }
        Tile tile = colony.getTile();
        if (!unit.getTile().isAdjacent(tile)) {
            return serverPlayer.clientError("Unit " + unitId + " not adjacent to colony: " + settlementId);
        }
        Unit.MoveType type = unit.getMoveType(tile);
        if (type != Unit.MoveType.ENTER_FOREIGN_COLONY_WITH_SCOUT) {
            return serverPlayer.clientError("Unable to enter at: " + colony.getName() + ": " + type.whyIllegal());
        }
        return this.igc(freeColServer).spySettlement(serverPlayer, unit, colony);
    }
}

