/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.internal.common;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Vector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class CombinedClassLoader
extends ClassLoader {
    private final Logger logger = LoggerFactory.getLogger(CombinedClassLoader.class);
    private final Map<ClassLoader, Set<Class<?>>> delegateClassLoaders;

    private static String info(ClassLoader classLoader, Set<Class<?>> clazzes) {
        return String.format("classloader \"%s\" for \"%s\"", classLoader, clazzes);
    }

    public static CombinedClassLoader fromClasses(ClassLoader parent, Stream<Class<?>> delegateClasses) {
        HashMap cls = new HashMap();
        delegateClasses.forEach(clazz -> {
            ClassLoader classLoader = clazz.getClassLoader();
            if (classLoader != null) {
                cls.compute(classLoader, (k, v) -> {
                    if (v == null) {
                        HashSet<Class> set = new HashSet<Class>();
                        set.add((Class)clazz);
                        return set;
                    }
                    v.add(clazz);
                    return v;
                });
            }
        });
        return new CombinedClassLoader(parent, cls);
    }

    public static CombinedClassLoader fromClassLoaders(ClassLoader parent, ClassLoader ... delegateClassLoaders) {
        return CombinedClassLoader.fromClassLoaders(parent, Arrays.stream(delegateClassLoaders));
    }

    public static CombinedClassLoader fromClassLoaders(ClassLoader parent, Stream<ClassLoader> delegateClassLoaders) {
        return new CombinedClassLoader(parent, delegateClassLoaders.collect(Collectors.toMap(cl -> cl, cl -> Set.of())));
    }

    private CombinedClassLoader(ClassLoader parent, Map<ClassLoader, Set<Class<?>>> delegateClassLoaders) {
        super(parent);
        this.delegateClassLoaders = Collections.unmodifiableMap(delegateClassLoaders);
    }

    @Override
    protected Class<?> findClass(@Nullable String name) throws ClassNotFoundException {
        if (name == null) {
            throw new ClassNotFoundException("Cannot load class with null name");
        }
        for (Map.Entry<ClassLoader, Set<Class<?>>> entry : this.delegateClassLoaders.entrySet()) {
            try {
                Class<?> clazz = entry.getKey().loadClass(name);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Loaded class \"{}\" by {}", (Object)name, (Object)CombinedClassLoader.info(entry.getKey(), entry.getValue()));
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException("Delegates cannot load class with name: " + name);
    }

    @Override
    protected @Nullable URL findResource(@Nullable String name) {
        if (name == null) {
            return null;
        }
        return this.delegateClassLoaders.keySet().stream().map(cl -> cl.getResource(name)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    @Override
    protected Enumeration<URL> findResources(@Nullable String name) throws IOException {
        if (name == null) {
            return Collections.emptyEnumeration();
        }
        Vector<URL> vector = new Vector<URL>();
        for (ClassLoader delegate : this.delegateClassLoaders.keySet()) {
            Enumeration<URL> enumeration = delegate.getResources(name);
            while (enumeration.hasMoreElements()) {
                vector.add(enumeration.nextElement());
            }
        }
        return vector.elements();
    }
}

