/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.xtext.JvmMemberInitializableResource;
import org.eclipse.xtext.resource.DerivedStateAwareResource;
import org.eclipse.xtext.xbase.typesystem.internal.DefaultBatchTypeResolver;

public class LogicalContainerAwareBatchTypeResolver
extends DefaultBatchTypeResolver {
    private static final Logger LOG = Logger.getLogger(LogicalContainerAwareBatchTypeResolver.class);

    @Override
    protected void validateResourceState(Resource resource) {
        super.validateResourceState(resource);
        if (resource instanceof DerivedStateAwareResource && ((DerivedStateAwareResource)resource).isInitializing()) {
            LOG.error((Object)("Discouraged attempt to compute types during model inference. Resource was : " + String.valueOf(resource.getURI())), (Throwable)new Exception());
        }
        if (resource instanceof JvmMemberInitializableResource && ((JvmMemberInitializableResource)resource).isInitializingJvmMembers()) {
            LOG.error((Object)("Discouraged attempt to compute types during JvmMember initialization. Resource was : " + String.valueOf(resource.getURI())), (Throwable)new Exception());
        }
    }

    @Override
    protected List<EObject> getEntryPoints(EObject object) {
        Resource resource = object.eResource();
        EList contents = resource.getContents();
        ArrayList result = Lists.newArrayList();
        for (EObject content : contents) {
            if (!(content instanceof JvmType)) continue;
            result.add(content);
        }
        if (result.isEmpty()) {
            return super.getEntryPoints(object);
        }
        return result;
    }
}

