/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.registry;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import org.jupnp.model.DiscoveryOptions;
import org.jupnp.model.gena.CancelReason;
import org.jupnp.model.gena.LocalGENASubscription;
import org.jupnp.model.meta.Device;
import org.jupnp.model.meta.DeviceIdentity;
import org.jupnp.model.meta.LocalDevice;
import org.jupnp.model.meta.LocalService;
import org.jupnp.model.resource.Resource;
import org.jupnp.model.types.UDN;
import org.jupnp.protocol.async.SendingNotificationByebye;
import org.jupnp.registry.RegistrationException;
import org.jupnp.registry.Registry;
import org.jupnp.registry.RegistryImpl;
import org.jupnp.registry.RegistryItem;
import org.jupnp.registry.RegistryItems;
import org.jupnp.registry.RegistryListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LocalItems
extends RegistryItems<LocalDevice, LocalGENASubscription> {
    private final Logger logger = LoggerFactory.getLogger(Registry.class);
    protected Map<UDN, DiscoveryOptions> discoveryOptions = new HashMap<UDN, DiscoveryOptions>();
    protected long lastAliveIntervalTimestamp = 0L;
    protected Random randomGenerator = new Random();

    LocalItems(RegistryImpl registry) {
        super(registry);
    }

    protected void setDiscoveryOptions(UDN udn, DiscoveryOptions options) {
        if (options != null) {
            this.discoveryOptions.put(udn, options);
        } else {
            this.discoveryOptions.remove(udn);
        }
    }

    protected DiscoveryOptions getDiscoveryOptions(UDN udn) {
        return this.discoveryOptions.get(udn);
    }

    protected boolean isAdvertised(UDN udn) {
        return this.getDiscoveryOptions(udn) == null || this.getDiscoveryOptions(udn).isAdvertised();
    }

    protected boolean isByeByeBeforeFirstAlive(UDN udn) {
        return this.getDiscoveryOptions(udn) != null && this.getDiscoveryOptions(udn).isByeByeBeforeFirstAlive();
    }

    @Override
    void add(LocalDevice localDevice) throws RegistrationException {
        this.add(localDevice, null);
    }

    void add(LocalDevice localDevice, DiscoveryOptions options) throws RegistrationException {
        this.setDiscoveryOptions(((DeviceIdentity)localDevice.getIdentity()).getUdn(), options);
        if (this.registry.getDevice(((DeviceIdentity)localDevice.getIdentity()).getUdn(), false) != null) {
            this.logger.trace("Ignoring addition, device already registered: {}", (Object)localDevice);
            return;
        }
        this.logger.trace("Adding local device to registry: {}", (Object)localDevice);
        Resource[] resourceArray = this.getResources(localDevice);
        int n = resourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            Resource deviceResource = resourceArray[n2];
            if (this.registry.getResource(deviceResource.getPathQuery()) != null) {
                throw new RegistrationException("URI namespace conflict with already registered resource: " + String.valueOf(deviceResource));
            }
            this.registry.addResource(deviceResource);
            this.logger.trace("Registered resource: {}", (Object)deviceResource);
            ++n2;
        }
        this.logger.trace("Adding item to registry with expiration in seconds: {}", (Object)((DeviceIdentity)localDevice.getIdentity()).getMaxAgeSeconds());
        RegistryItem<UDN, LocalDevice> localItem = new RegistryItem<UDN, LocalDevice>(((DeviceIdentity)localDevice.getIdentity()).getUdn(), localDevice, ((DeviceIdentity)localDevice.getIdentity()).getMaxAgeSeconds());
        this.getDeviceItems().add(localItem);
        this.logger.trace("Registered local device: {}", localItem);
        if (this.isByeByeBeforeFirstAlive(localItem.getKey())) {
            this.advertiseByebye(localDevice, true);
        }
        if (this.isAdvertised(localItem.getKey())) {
            this.advertiseAlive(localDevice);
        }
        for (RegistryListener listener : this.registry.getListeners()) {
            this.registry.getConfiguration().getRegistryListenerExecutor().execute(() -> listener.localDeviceAdded(this.registry, localDevice));
        }
    }

    @Override
    Collection<LocalDevice> get() {
        HashSet<LocalDevice> c = new HashSet<LocalDevice>();
        for (RegistryItem item : this.getDeviceItems()) {
            c.add((LocalDevice)item.getItem());
        }
        return Collections.unmodifiableCollection(c);
    }

    @Override
    boolean remove(LocalDevice localDevice) throws RegistrationException {
        return this.remove(localDevice, false);
    }

    boolean remove(LocalDevice localDevice, boolean shuttingDown) throws RegistrationException {
        LocalDevice registeredDevice = (LocalDevice)this.get(((DeviceIdentity)localDevice.getIdentity()).getUdn(), true);
        if (registeredDevice != null) {
            this.logger.trace("Removing local device from registry: {}", (Object)localDevice);
            this.setDiscoveryOptions(((DeviceIdentity)localDevice.getIdentity()).getUdn(), null);
            this.getDeviceItems().remove(new RegistryItem(((DeviceIdentity)localDevice.getIdentity()).getUdn()));
            Resource[] resourceArray = this.getResources(localDevice);
            int n = resourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                Resource deviceResource = resourceArray[n2];
                if (this.registry.removeResource(deviceResource)) {
                    this.logger.trace("Unregistered resource: {}", (Object)deviceResource);
                }
                ++n2;
            }
            Iterator it = this.getSubscriptionItems().iterator();
            while (it.hasNext()) {
                RegistryItem incomingSubscription = it.next();
                UDN subscriptionForUDN = ((DeviceIdentity)((Device)((LocalService)((LocalGENASubscription)incomingSubscription.getItem()).getService()).getDevice()).getIdentity()).getUdn();
                if (!subscriptionForUDN.equals(((DeviceIdentity)registeredDevice.getIdentity()).getUdn())) continue;
                this.logger.trace("Removing incoming subscription: {}", (Object)incomingSubscription.getKey());
                it.remove();
                if (shuttingDown) continue;
                this.registry.getConfiguration().getRegistryListenerExecutor().execute(() -> ((LocalGENASubscription)incomingSubscription.getItem()).end(CancelReason.DEVICE_WAS_REMOVED));
            }
            if (this.isAdvertised(((DeviceIdentity)localDevice.getIdentity()).getUdn())) {
                this.advertiseByebye(localDevice, !shuttingDown);
            }
            if (!shuttingDown) {
                for (RegistryListener listener : this.registry.getListeners()) {
                    this.registry.getConfiguration().getRegistryListenerExecutor().execute(() -> listener.localDeviceRemoved(this.registry, localDevice));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    void removeAll() {
        this.removeAll(false);
    }

    void removeAll(boolean shuttingDown) {
        LocalDevice[] allDevices;
        LocalDevice[] localDeviceArray = allDevices = this.get().toArray(new LocalDevice[this.get().size()]);
        int n = allDevices.length;
        int n2 = 0;
        while (n2 < n) {
            LocalDevice device = localDeviceArray[n2];
            this.remove(device, shuttingDown);
            ++n2;
        }
    }

    public void advertiseLocalDevices() {
        for (RegistryItem localItem : this.deviceItems) {
            if (!this.isAdvertised((UDN)localItem.getKey())) continue;
            this.advertiseAlive((LocalDevice)localItem.getItem());
        }
    }

    @Override
    void maintain() {
        if (this.getDeviceItems().isEmpty()) {
            return;
        }
        HashSet expiredLocalItems = new HashSet();
        int aliveIntervalMillis = this.registry.getConfiguration().getAliveIntervalMillis();
        if (aliveIntervalMillis > 0) {
            long l = System.currentTimeMillis();
            if (l - this.lastAliveIntervalTimestamp > (long)aliveIntervalMillis) {
                this.lastAliveIntervalTimestamp = l;
                for (RegistryItem localItem : this.getDeviceItems()) {
                    if (!this.isAdvertised(localItem.getKey())) continue;
                    this.logger.trace("Flooding advertisement of local item: {}", localItem);
                    expiredLocalItems.add(localItem);
                }
            }
        } else {
            this.lastAliveIntervalTimestamp = 0L;
            for (RegistryItem registryItem : this.getDeviceItems()) {
                if (!this.isAdvertised(registryItem.getKey()) || !registryItem.getExpirationDetails().hasExpired(true)) continue;
                this.logger.trace("Local item has expired: {}", registryItem);
                expiredLocalItems.add(registryItem);
            }
        }
        for (RegistryItem registryItem : expiredLocalItems) {
            this.logger.trace("Refreshing local device advertisement: {}", registryItem.getItem());
            this.advertiseAlive((LocalDevice)registryItem.getItem());
            registryItem.getExpirationDetails().stampLastRefresh();
        }
        HashSet hashSet = new HashSet();
        for (RegistryItem registryItem : this.getSubscriptionItems()) {
            if (!registryItem.getExpirationDetails().hasExpired(false)) continue;
            hashSet.add(registryItem);
        }
        for (RegistryItem<String, Object> registryItem : hashSet) {
            this.logger.trace("Removing expired: {}", registryItem);
            this.removeSubscription((LocalGENASubscription)registryItem.getItem());
            ((LocalGENASubscription)registryItem.getItem()).end(CancelReason.EXPIRED);
        }
    }

    @Override
    void shutdown() {
        this.logger.trace("Clearing all registered subscriptions to local devices during shutdown");
        this.getSubscriptionItems().clear();
        this.logger.trace("Removing all local devices from registry during shutdown");
        this.removeAll(true);
    }

    protected void advertiseAlive(LocalDevice localDevice) {
        this.registry.executeAsyncProtocol(() -> {
            try {
                this.logger.trace("Sleeping some milliseconds to avoid flooding the network with ALIVE msgs");
                Thread.sleep(this.randomGenerator.nextInt(100));
            }
            catch (InterruptedException e) {
                this.logger.error("Background execution interrupted", (Throwable)e);
            }
            this.registry.getProtocolFactory().createSendingNotificationAlive(localDevice).run();
        });
    }

    protected void advertiseByebye(LocalDevice localDevice, boolean asynchronous) {
        SendingNotificationByebye prot = this.registry.getProtocolFactory().createSendingNotificationByebye(localDevice);
        if (asynchronous) {
            this.registry.executeAsyncProtocol(prot);
        } else {
            prot.run();
        }
    }
}

