/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.property.access.spi;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.Internal;
import org.hibernate.PropertyAccessException;
import org.hibernate.PropertySetterAccessException;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.property.access.internal.AbstractSetterMethodSerialForm;
import org.hibernate.property.access.spi.Setter;

@Internal
public class SetterMethodImpl
implements Setter {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(SetterMethodImpl.class);
    private final Class<?> containerClass;
    private final String propertyName;
    private final Method setterMethod;
    private final boolean isPrimitive;

    public SetterMethodImpl(Class<?> containerClass, String propertyName, Method setterMethod) {
        this.containerClass = containerClass;
        this.propertyName = propertyName;
        this.setterMethod = setterMethod;
        this.isPrimitive = setterMethod.getParameterTypes()[0].isPrimitive();
    }

    @Override
    public void set(Object target, @Nullable Object value) {
        try {
            this.setterMethod.invoke(target, value);
        }
        catch (NullPointerException npe) {
            if (value == null && this.isPrimitive) {
                throw new PropertyAccessException(npe, "Null value was assigned to a property of primitive type", true, this.containerClass, this.propertyName);
            }
            throw new PropertyAccessException(npe, "NullPointerException occurred while calling", true, this.containerClass, this.propertyName);
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ite.getCause();
            if (cause instanceof Error) {
                Error error = (Error)cause;
                throw error;
            }
            throw new PropertyAccessException(cause, "Exception occurred inside", true, this.containerClass, this.propertyName);
        }
        catch (IllegalAccessException iae) {
            throw new PropertyAccessException(iae, "IllegalAccessException occurred while calling", true, this.containerClass, this.propertyName);
        }
        catch (IllegalArgumentException iae) {
            if (value == null && this.isPrimitive) {
                throw new PropertyAccessException(iae, "Null value was assigned to a property of primitive type", true, this.containerClass, this.propertyName);
            }
            Class<?> expectedType = this.setterMethod.getParameterTypes()[0];
            LOG.illegalPropertySetterArgument(this.containerClass.getName(), this.propertyName);
            LOG.expectedType(expectedType.getName(), value == null ? null : value.getClass().getName());
            throw new PropertySetterAccessException(iae, this.containerClass, this.propertyName, expectedType, target, value);
        }
    }

    public Class<?> getContainerClass() {
        return this.containerClass;
    }

    @Override
    public String getMethodName() {
        return this.setterMethod.getName();
    }

    @Override
    public Method getMethod() {
        return this.setterMethod;
    }

    private Object writeReplace() {
        return new SerialForm(this.containerClass, this.propertyName, this.setterMethod);
    }

    private static class SerialForm
    extends AbstractSetterMethodSerialForm
    implements Serializable {
        private SerialForm(Class<?> containerClass, String propertyName, Method method) {
            super(containerClass, propertyName, method);
        }

        private Object readResolve() {
            return new SetterMethodImpl(this.getContainerClass(), this.getPropertyName(), this.resolveMethod());
        }
    }
}

