"""Generated message classes for cloudaicompanion version v1.

The AI-powered assistant for Google Cloud.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'cloudaicompanion'


class APIToken(_messages.Message):
  r"""Message for API Token based authentication.

  Fields:
    tokenSecretResource: Required. The secret key for the API token. Example:
      projects//secrets//versions/
    username: Required. The username for the API token.
  """

  tokenSecretResource = _messages.StringField(1)
  username = _messages.StringField(2)


class AttemptStats(_messages.Message):
  r"""Status for the execution attempt.

  Fields:
    endTime: The end time of the execution for the current attempt.
    startTime: The start time of the execution for the current attempt. This
      could be in the future if it's been scheduled.
  """

  endTime = _messages.StringField(1)
  startTime = _messages.StringField(2)


class AuditConfig(_messages.Message):
  r"""Specifies the audit configuration for a service. The configuration
  determines which permission types are logged, and what identities, if any,
  are exempted from logging. An AuditConfig must have one or more
  AuditLogConfigs. If there are AuditConfigs for both `allServices` and a
  specific service, the union of the two AuditConfigs is used for that
  service: the log_types specified in each AuditConfig are enabled, and the
  exempted_members in each AuditLogConfig are exempted. Example Policy with
  multiple AuditConfigs: { "audit_configs": [ { "service": "allServices",
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type":
  "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com",
  "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type":
  "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For
  sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ
  logging. It also exempts `jose@example.com` from DATA_READ logging, and
  `aliya@example.com` from DATA_WRITE logging.

  Fields:
    auditLogConfigs: The configuration for logging of each type of permission.
    service: Specifies a service that will be enabled for audit logging. For
      example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
      `allServices` is a special value that covers all services.
  """

  auditLogConfigs = _messages.MessageField('AuditLogConfig', 1, repeated=True)
  service = _messages.StringField(2)


class AuditLogConfig(_messages.Message):
  r"""Provides the configuration for logging a type of permissions. Example: {
  "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
  "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables
  'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from
  DATA_READ logging.

  Enums:
    LogTypeValueValuesEnum: The log type that this config enables.

  Fields:
    exemptedMembers: Specifies the identities that do not cause logging for
      this type of permission. Follows the same format of Binding.members.
    logType: The log type that this config enables.
  """

  class LogTypeValueValuesEnum(_messages.Enum):
    r"""The log type that this config enables.

    Values:
      LOG_TYPE_UNSPECIFIED: Default case. Should never be this.
      ADMIN_READ: Admin reads. Example: CloudIAM getIamPolicy
      DATA_WRITE: Data writes. Example: CloudSQL Users create
      DATA_READ: Data reads. Example: CloudSQL Users list
    """
    LOG_TYPE_UNSPECIFIED = 0
    ADMIN_READ = 1
    DATA_WRITE = 2
    DATA_READ = 3

  exemptedMembers = _messages.StringField(1, repeated=True)
  logType = _messages.EnumField('LogTypeValueValuesEnum', 2)


class AuthConfig(_messages.Message):
  r"""The AuthConfig resource use to hold channels and connection config data.

  Enums:
    CredentialTypeValueValuesEnum: Optional. Credential type of the auth
      config.
    StateValueValuesEnum: Output only. The status of the auth config.

  Fields:
    credentialType: Optional. Credential type of the auth config.
    description: Optional. A description of the auth config.
    displayName: Optional. The name of the auth config.
    name: Optional. Resource name of the auth config. For more information,
      see https://cloud.google.com/application-integration/docs/configure-
      authentication-profiles"
      projects/{project}/locations/{location}/authConfigs/{authConfig}
    overrideValidTime: Optional. User provided expiry time to override. For
      the example of Salesforce, username/password credentials can be valid
      for 6 months depending on the instance settings.
    reason: Output only. The reason / details of the current status.
    state: Output only. The status of the auth config.
    validTime: Optional. The time until the auth config is valid. Empty or max
      value is considered the auth config won't expire.
  """

  class CredentialTypeValueValuesEnum(_messages.Enum):
    r"""Optional. Credential type of the auth config.

    Values:
      CREDENTIAL_TYPE_UNSPECIFIED: Unspecified credential type
      USERNAME_AND_PASSWORD: Regular username/password pair.
      API_KEY: API key.
      OAUTH2_AUTHORIZATION_CODE: OAuth 2.0 Authorization Code Grant Type.
      OAUTH2_IMPLICIT: OAuth 2.0 Implicit Grant Type.
      OAUTH2_CLIENT_CREDENTIALS: OAuth 2.0 Client Credentials Grant Type.
      OAUTH2_RESOURCE_OWNER_CREDENTIALS: OAuth 2.0 Resource Owner Credentials
        Grant Type.
      JWT: JWT Token.
      AUTH_TOKEN: Auth Token, e.g. bearer token.
      SERVICE_ACCOUNT: Service Account which can be used to generate token for
        authentication.
      CLIENT_CERTIFICATE_ONLY: Client Certificate only.
      OIDC_TOKEN: Google OIDC ID Token
    """
    CREDENTIAL_TYPE_UNSPECIFIED = 0
    USERNAME_AND_PASSWORD = 1
    API_KEY = 2
    OAUTH2_AUTHORIZATION_CODE = 3
    OAUTH2_IMPLICIT = 4
    OAUTH2_CLIENT_CREDENTIALS = 5
    OAUTH2_RESOURCE_OWNER_CREDENTIALS = 6
    JWT = 7
    AUTH_TOKEN = 8
    SERVICE_ACCOUNT = 9
    CLIENT_CERTIFICATE_ONLY = 10
    OIDC_TOKEN = 11

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The status of the auth config.

    Values:
      STATE_UNSPECIFIED: Status not specified.
      VALID: Valid Auth config.
      INVALID: General invalidity, if it doesn't fits in the detailed issue
        below.
      SOFT_DELETED: Auth config soft deleted.
      EXPIRED: Auth config expired.
      UNAUTHORIZED: Auth config unauthorized.
      UNSUPPORTED: Auth config not supported.
    """
    STATE_UNSPECIFIED = 0
    VALID = 1
    INVALID = 2
    SOFT_DELETED = 3
    EXPIRED = 4
    UNAUTHORIZED = 5
    UNSUPPORTED = 6

  credentialType = _messages.EnumField('CredentialTypeValueValuesEnum', 1)
  description = _messages.StringField(2)
  displayName = _messages.StringField(3)
  name = _messages.StringField(4)
  overrideValidTime = _messages.StringField(5)
  reason = _messages.StringField(6)
  state = _messages.EnumField('StateValueValuesEnum', 7)
  validTime = _messages.StringField(8)


class Binding(_messages.Message):
  r"""Associates `members`, or principals, with a `role`.

  Fields:
    condition: The condition that is associated with this binding. If the
      condition evaluates to `true`, then this binding applies to the current
      request. If the condition evaluates to `false`, then this binding does
      not apply to the current request. However, a different role binding
      might grant the same role to one or more of the principals in this
      binding. To learn which resources support conditions in their IAM
      policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    members: Specifies the principals requesting access for a Google Cloud
      resource. `members` can have the following values: * `allUsers`: A
      special identifier that represents anyone who is on the internet; with
      or without a Google account. * `allAuthenticatedUsers`: A special
      identifier that represents anyone who is authenticated with a Google
      account or a service account. Does not include identities that come from
      external identity providers (IdPs) through identity federation. *
      `user:{emailid}`: An email address that represents a specific Google
      account. For example, `alice@example.com` . *
      `serviceAccount:{emailid}`: An email address that represents a Google
      service account. For example, `my-other-
      app@appspot.gserviceaccount.com`. *
      `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`:
      An identifier for a [Kubernetes service
      account](https://cloud.google.com/kubernetes-engine/docs/how-
      to/kubernetes-service-accounts). For example, `my-
      project.svc.id.goog[my-namespace/my-kubernetes-sa]`. *
      `group:{emailid}`: An email address that represents a Google group. For
      example, `admins@example.com`. * `domain:{domain}`: The G Suite domain
      (primary) that represents all the users of that domain. For example,
      `google.com` or `example.com`. * `principal://iam.googleapis.com/locatio
      ns/global/workforcePools/{pool_id}/subject/{subject_attribute_value}`: A
      single identity in a workforce identity pool. * `principalSet://iam.goog
      leapis.com/locations/global/workforcePools/{pool_id}/group/{group_id}`:
      All workforce identities in a group. * `principalSet://iam.googleapis.co
      m/locations/global/workforcePools/{pool_id}/attribute.{attribute_name}/{
      attribute_value}`: All workforce identities with a specific attribute
      value. * `principalSet://iam.googleapis.com/locations/global/workforcePo
      ols/{pool_id}/*`: All identities in a workforce identity pool. * `princi
      pal://iam.googleapis.com/projects/{project_number}/locations/global/work
      loadIdentityPools/{pool_id}/subject/{subject_attribute_value}`: A single
      identity in a workload identity pool. * `principalSet://iam.googleapis.c
      om/projects/{project_number}/locations/global/workloadIdentityPools/{poo
      l_id}/group/{group_id}`: A workload identity pool group. * `principalSet
      ://iam.googleapis.com/projects/{project_number}/locations/global/workloa
      dIdentityPools/{pool_id}/attribute.{attribute_name}/{attribute_value}`:
      All identities in a workload identity pool with a certain attribute. * `
      principalSet://iam.googleapis.com/projects/{project_number}/locations/gl
      obal/workloadIdentityPools/{pool_id}/*`: All identities in a workload
      identity pool. * `deleted:user:{emailid}?uid={uniqueid}`: An email
      address (plus unique identifier) representing a user that has been
      recently deleted. For example,
      `alice@example.com?uid=123456789012345678901`. If the user is recovered,
      this value reverts to `user:{emailid}` and the recovered user retains
      the role in the binding. *
      `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address
      (plus unique identifier) representing a service account that has been
      recently deleted. For example, `my-other-
      app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the
      service account is undeleted, this value reverts to
      `serviceAccount:{emailid}` and the undeleted service account retains the
      role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An
      email address (plus unique identifier) representing a Google group that
      has been recently deleted. For example,
      `admins@example.com?uid=123456789012345678901`. If the group is
      recovered, this value reverts to `group:{emailid}` and the recovered
      group retains the role in the binding. * `deleted:principal://iam.google
      apis.com/locations/global/workforcePools/{pool_id}/subject/{subject_attr
      ibute_value}`: Deleted single identity in a workforce identity pool. For
      example, `deleted:principal://iam.googleapis.com/locations/global/workfo
      rcePools/my-pool-id/subject/my-subject-attribute-value`.
    role: Role that is assigned to the list of `members`, or principals. For
      example, `roles/viewer`, `roles/editor`, or `roles/owner`. For an
      overview of the IAM roles and permissions, see the [IAM
      documentation](https://cloud.google.com/iam/docs/roles-overview). For a
      list of the available pre-defined roles, see
      [here](https://cloud.google.com/iam/docs/understanding-roles).
  """

  condition = _messages.MessageField('Expr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class BooleanParameterArray(_messages.Message):
  r"""This message only contains a field of boolean array.

  Fields:
    booleanValues: Boolean array.
  """

  booleanValues = _messages.BooleanField(1, repeated=True)


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class CloudLoggingDetails(_messages.Message):
  r"""Cloud Logging details for execution info

  Enums:
    CloudLoggingSeverityValueValuesEnum: Optional. Severity selected by the
      customer for the logs to be sent to Cloud Logging, for the integration
      version getting executed.

  Fields:
    cloudLoggingSeverity: Optional. Severity selected by the customer for the
      logs to be sent to Cloud Logging, for the integration version getting
      executed.
    enableCloudLogging: Optional. Status of whether Cloud Logging is enabled
      or not for the integration version getting executed.
  """

  class CloudLoggingSeverityValueValuesEnum(_messages.Enum):
    r"""Optional. Severity selected by the customer for the logs to be sent to
    Cloud Logging, for the integration version getting executed.

    Values:
      CLOUD_LOGGING_SEVERITY_UNSPECIFIED: Unspecified
      INFO: If Severity selected is `INFO`, then all the Integration Execution
        States (`IN_PROCESS`, `ON_HOLD`, `SUCCEEDED`, `SUSPENDED`, `ERROR`,
        `CANCELLED`) will be sent to Cloud Logging.
      ERROR: If Severity selected is `ERROR`, then only the following
        Integration Execution States (`ERROR`, `CANCELLED`) will be sent to
        Cloud Logging.
      WARNING: If Severity selected is `WARNING`, then only the following
        Integration Execution States (`ERROR`, `CANCELLED`) will be sent to
        Cloud Logging.
    """
    CLOUD_LOGGING_SEVERITY_UNSPECIFIED = 0
    INFO = 1
    ERROR = 2
    WARNING = 3

  cloudLoggingSeverity = _messages.EnumField('CloudLoggingSeverityValueValuesEnum', 1)
  enableCloudLogging = _messages.BooleanField(2)


class CloudSchedulerConfig(_messages.Message):
  r"""Cloud Scheduler Trigger configuration

  Fields:
    cronTab: Required. The cron tab of cloud scheduler trigger.
    errorMessage: Optional. When the job was deleted from Pantheon UI,
      error_message will be populated when Get/List integrations
    location: Required. The location where associated cloud scheduler job will
      be created
    serviceAccountEmail: Required. Service account used by Cloud Scheduler to
      trigger the integration at scheduled time
  """

  cronTab = _messages.StringField(1)
  errorMessage = _messages.StringField(2)
  location = _messages.StringField(3)
  serviceAccountEmail = _messages.StringField(4)


class CloudaicompanionProjectsLocationsCodeRepositoryIndexesCreateRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsCodeRepositoryIndexesCreateRequest
  object.

  Fields:
    codeRepositoryIndex: A CodeRepositoryIndex resource to be passed as the
      request body.
    codeRepositoryIndexId: Required. Id of the requesting object
    parent: Required. Value for parent.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. The request ID must be a valid UUID with the exception that
      zero UUID is not supported (00000000-0000-0000-0000-000000000000).
  """

  codeRepositoryIndex = _messages.MessageField('CodeRepositoryIndex', 1)
  codeRepositoryIndexId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class CloudaicompanionProjectsLocationsCodeRepositoryIndexesDeleteRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsCodeRepositoryIndexesDeleteRequest
  object.

  Fields:
    force: Optional. If set to true, any RepositoryGroups from this
      CodeRepositoryIndex will also be deleted. (Otherwise, the request will
      only work if the CodeRepositoryIndex has no RepositoryGroups.)
    name: Required. Name of the resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. The request ID must be a valid UUID with the exception that
      zero UUID is not supported (00000000-0000-0000-0000-000000000000).
  """

  force = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class CloudaicompanionProjectsLocationsCodeRepositoryIndexesGetRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsCodeRepositoryIndexesGetRequest
  object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class CloudaicompanionProjectsLocationsCodeRepositoryIndexesListRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsCodeRepositoryIndexesListRequest
  object.

  Fields:
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Parent value for ListCodeRepositoryIndexesRequest
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class CloudaicompanionProjectsLocationsCodeRepositoryIndexesPatchRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsCodeRepositoryIndexesPatchRequest
  object.

  Fields:
    codeRepositoryIndex: A CodeRepositoryIndex resource to be passed as the
      request body.
    name: Immutable. Identifier. name of resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. The request ID must be a valid UUID with the exception that
      zero UUID is not supported (00000000-0000-0000-0000-000000000000).
    updateMask: Optional. Field mask is used to specify the fields to be
      overwritten in the CodeRepositoryIndex resource by the update. The
      fields specified in the update_mask are relative to the resource, not
      the full request. A field will be overwritten if it is in the mask. If
      the user does not provide a mask then all fields will be overwritten.
  """

  codeRepositoryIndex = _messages.MessageField('CodeRepositoryIndex', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroupsCreateRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroups
  CreateRequest object.

  Fields:
    parent: Required. Value for parent.
    repositoryGroup: A RepositoryGroup resource to be passed as the request
      body.
    repositoryGroupId: Required. Id of the requesting object
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. The request ID must be a valid UUID with the exception that
      zero UUID is not supported (00000000-0000-0000-0000-000000000000).
  """

  parent = _messages.StringField(1, required=True)
  repositoryGroup = _messages.MessageField('RepositoryGroup', 2)
  repositoryGroupId = _messages.StringField(3)
  requestId = _messages.StringField(4)


class CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroupsDeleteRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroups
  DeleteRequest object.

  Fields:
    name: Required. Name of the resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. The request ID must be a valid UUID with the exception that
      zero UUID is not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroupsGetIamPolicyRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroups
  GetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroupsGetRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroups
  GetRequest object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroupsListRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroups
  ListRequest object.

  Fields:
    filter: Optional. Filtering results
    orderBy: Optional. Hint for how to order the results
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Parent value for ListRepositoryGroupsRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroupsPatchRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroups
  PatchRequest object.

  Fields:
    name: Immutable. Identifier. name of resource
    repositoryGroup: A RepositoryGroup resource to be passed as the request
      body.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. The request ID must be a valid UUID with the exception that
      zero UUID is not supported (00000000-0000-0000-0000-000000000000).
    updateMask: Optional. Field mask is used to specify the fields to be
      overwritten in the RepositoryGroup resource by the update. The fields
      specified in the update_mask are relative to the resource, not the full
      request. A field will be overwritten if it is in the mask. If the user
      does not provide a mask then all fields will be overwritten.
  """

  name = _messages.StringField(1, required=True)
  repositoryGroup = _messages.MessageField('RepositoryGroup', 2)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroupsSetIamPolicyRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroups
  SetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroupsTestIamPermissionsRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroups
  TestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class CloudaicompanionProjectsLocationsCodeToolsSettingsCreateRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsCodeToolsSettingsCreateRequest
  object.

  Fields:
    codeToolsSetting: A CodeToolsSetting resource to be passed as the request
      body.
    codeToolsSettingId: Required. Id of the requesting object. If auto-
      generating Id server-side, remove this field and code_tools_setting_id
      from the method_signature of Create RPC
    parent: Required. Value for parent.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  codeToolsSetting = _messages.MessageField('CodeToolsSetting', 1)
  codeToolsSettingId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class CloudaicompanionProjectsLocationsCodeToolsSettingsDeleteRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsCodeToolsSettingsDeleteRequest
  object.

  Fields:
    force: Optional. If set to true, any code tools settings from this
      publisher will also be deleted. (Otherwise, the request will only work
      if the publisher has no books.)
    name: Required. Name of the resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  force = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)


class CloudaicompanionProjectsLocationsCodeToolsSettingsGetRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsCodeToolsSettingsGetRequest object.

  Fields:
    name: Required. Name of the resource.
  """

  name = _messages.StringField(1, required=True)


class CloudaicompanionProjectsLocationsCodeToolsSettingsListRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsCodeToolsSettingsListRequest object.

  Fields:
    filter: Optional. Filtering results.
    orderBy: Optional. Hint for how to order the results.
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Parent value for ListCodeToolsSettingsRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class CloudaicompanionProjectsLocationsCodeToolsSettingsPatchRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsCodeToolsSettingsPatchRequest object.

  Fields:
    codeToolsSetting: A CodeToolsSetting resource to be passed as the request
      body.
    name: Identifier. Name of the resource. Format:projects/{project}/location
      s/{location}/codeToolsSettings/{codeToolsSetting}
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    updateMask: Optional. Field mask is used to specify the fields to be
      overwritten in the CodeToolsSetting resource by the update. The fields
      specified in the update_mask are relative to the resource, not the full
      request. A field will be overwritten if it is in the mask. If the user
      does not provide a mask then all fields present in the request will be
      overwritten.
  """

  codeToolsSetting = _messages.MessageField('CodeToolsSetting', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class CloudaicompanionProjectsLocationsCodeToolsSettingsSettingBindingsCreateRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsCodeToolsSettingsSettingBindingsCreat
  eRequest object.

  Fields:
    parent: Required. Value for parent.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    settingBinding: A SettingBinding resource to be passed as the request
      body.
    settingBindingId: Required. Id of the requesting object. If auto-
      generating Id server-side, remove this field and setting_id from the
      method_signature of Create RPC.
  """

  parent = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  settingBinding = _messages.MessageField('SettingBinding', 3)
  settingBindingId = _messages.StringField(4)


class CloudaicompanionProjectsLocationsCodeToolsSettingsSettingBindingsDeleteRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsCodeToolsSettingsSettingBindingsDelet
  eRequest object.

  Fields:
    name: Required. Name of the resource.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class CloudaicompanionProjectsLocationsCodeToolsSettingsSettingBindingsGetRequest(_messages.Message):
  r"""A
  CloudaicompanionProjectsLocationsCodeToolsSettingsSettingBindingsGetRequest
  object.

  Fields:
    name: Required. Name of the resource.
  """

  name = _messages.StringField(1, required=True)


class CloudaicompanionProjectsLocationsCodeToolsSettingsSettingBindingsListRequest(_messages.Message):
  r"""A
  CloudaicompanionProjectsLocationsCodeToolsSettingsSettingBindingsListRequest
  object.

  Fields:
    filter: Optional. Filtering results.
    orderBy: Optional. Hint for how to order the results.
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Parent value for ListSettingBindingsRequest.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class CloudaicompanionProjectsLocationsCodeToolsSettingsSettingBindingsPatchRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsCodeToolsSettingsSettingBindingsPatch
  Request object.

  Fields:
    name: Identifier. Name of the resource. Format:projects/{project}/location
      s/{location}/{settingType}/{setting}/settingBindings/{setting_binding}
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    settingBinding: A SettingBinding resource to be passed as the request
      body.
    updateMask: Optional. Field mask is used to specify the fields to be
      overwritten in the SettingBinding resource by the update. The fields
      specified in the update_mask are relative to the resource, not the full
      request. A field will be overwritten if it is in the mask. If the user
      does not provide a mask then all fields present in the request will be
      overwritten.
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  settingBinding = _messages.MessageField('SettingBinding', 3)
  updateMask = _messages.StringField(4)


class CloudaicompanionProjectsLocationsDataSharingWithGoogleSettingsCreateRequest(_messages.Message):
  r"""A
  CloudaicompanionProjectsLocationsDataSharingWithGoogleSettingsCreateRequest
  object.

  Fields:
    dataSharingWithGoogleSetting: A DataSharingWithGoogleSetting resource to
      be passed as the request body.
    dataSharingWithGoogleSettingId: Required. Id of the requesting object. If
      auto-generating Id server-side, remove this field and
      data_sharing_with_google_setting_id from the method_signature of Create
      RPC
    parent: Required. Value for parent.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  dataSharingWithGoogleSetting = _messages.MessageField('DataSharingWithGoogleSetting', 1)
  dataSharingWithGoogleSettingId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class CloudaicompanionProjectsLocationsDataSharingWithGoogleSettingsDeleteRequest(_messages.Message):
  r"""A
  CloudaicompanionProjectsLocationsDataSharingWithGoogleSettingsDeleteRequest
  object.

  Fields:
    name: Required. Name of the resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class CloudaicompanionProjectsLocationsDataSharingWithGoogleSettingsGetRequest(_messages.Message):
  r"""A
  CloudaicompanionProjectsLocationsDataSharingWithGoogleSettingsGetRequest
  object.

  Fields:
    name: Required. Name of the resource.
  """

  name = _messages.StringField(1, required=True)


class CloudaicompanionProjectsLocationsDataSharingWithGoogleSettingsListRequest(_messages.Message):
  r"""A
  CloudaicompanionProjectsLocationsDataSharingWithGoogleSettingsListRequest
  object.

  Fields:
    filter: Optional. Filtering results.
    orderBy: Optional. Hint for how to order the results.
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Parent value for
      ListDataSharingWithGoogleSettingsRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class CloudaicompanionProjectsLocationsDataSharingWithGoogleSettingsPatchRequest(_messages.Message):
  r"""A
  CloudaicompanionProjectsLocationsDataSharingWithGoogleSettingsPatchRequest
  object.

  Fields:
    dataSharingWithGoogleSetting: A DataSharingWithGoogleSetting resource to
      be passed as the request body.
    name: Identifier. Name of the resource. Format:projects/{project}/location
      s/{location}/dataSharingWithGoogleSettings/{dataSharingWithGoogleSetting
      }
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    updateMask: Optional. Field mask is used to specify the fields to be
      overwritten in the DataSharingWithGoogleSetting resource by the update.
      The fields specified in the update_mask are relative to the resource,
      not the full request. A field will be overwritten if it is in the mask.
      If the user does not provide a mask then all fields present in the
      request will be overwritten.
  """

  dataSharingWithGoogleSetting = _messages.MessageField('DataSharingWithGoogleSetting', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class CloudaicompanionProjectsLocationsDataSharingWithGoogleSettingsSettingBindingsCreateRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsDataSharingWithGoogleSettingsSettingB
  indingsCreateRequest object.

  Fields:
    parent: Required. Value for parent.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    settingBinding: A SettingBinding resource to be passed as the request
      body.
    settingBindingId: Required. Id of the requesting object. If auto-
      generating Id server-side, remove this field and setting_id from the
      method_signature of Create RPC.
  """

  parent = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  settingBinding = _messages.MessageField('SettingBinding', 3)
  settingBindingId = _messages.StringField(4)


class CloudaicompanionProjectsLocationsDataSharingWithGoogleSettingsSettingBindingsDeleteRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsDataSharingWithGoogleSettingsSettingB
  indingsDeleteRequest object.

  Fields:
    name: Required. Name of the resource.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class CloudaicompanionProjectsLocationsDataSharingWithGoogleSettingsSettingBindingsGetRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsDataSharingWithGoogleSettingsSettingB
  indingsGetRequest object.

  Fields:
    name: Required. Name of the resource.
  """

  name = _messages.StringField(1, required=True)


class CloudaicompanionProjectsLocationsDataSharingWithGoogleSettingsSettingBindingsListRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsDataSharingWithGoogleSettingsSettingB
  indingsListRequest object.

  Fields:
    filter: Optional. Filtering results.
    orderBy: Optional. Hint for how to order the results.
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Parent value for ListSettingBindingsRequest.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class CloudaicompanionProjectsLocationsDataSharingWithGoogleSettingsSettingBindingsPatchRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsDataSharingWithGoogleSettingsSettingB
  indingsPatchRequest object.

  Fields:
    name: Identifier. Name of the resource. Format:projects/{project}/location
      s/{location}/{settingType}/{setting}/settingBindings/{setting_binding}
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    settingBinding: A SettingBinding resource to be passed as the request
      body.
    updateMask: Optional. Field mask is used to specify the fields to be
      overwritten in the SettingBinding resource by the update. The fields
      specified in the update_mask are relative to the resource, not the full
      request. A field will be overwritten if it is in the mask. If the user
      does not provide a mask then all fields present in the request will be
      overwritten.
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  settingBinding = _messages.MessageField('SettingBinding', 3)
  updateMask = _messages.StringField(4)


class CloudaicompanionProjectsLocationsGeminiGcpEnablementSettingsCreateRequest(_messages.Message):
  r"""A
  CloudaicompanionProjectsLocationsGeminiGcpEnablementSettingsCreateRequest
  object.

  Fields:
    geminiGcpEnablementSetting: A GeminiGcpEnablementSetting resource to be
      passed as the request body.
    geminiGcpEnablementSettingId: Required. Id of the requesting object. If
      auto-generating Id server-side, remove this field and
      gemini_gcp_enablement_setting_id from the method_signature of Create RPC
    parent: Required. Value for parent.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  geminiGcpEnablementSetting = _messages.MessageField('GeminiGcpEnablementSetting', 1)
  geminiGcpEnablementSettingId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class CloudaicompanionProjectsLocationsGeminiGcpEnablementSettingsDeleteRequest(_messages.Message):
  r"""A
  CloudaicompanionProjectsLocationsGeminiGcpEnablementSettingsDeleteRequest
  object.

  Fields:
    name: Required. Name of the resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class CloudaicompanionProjectsLocationsGeminiGcpEnablementSettingsGetRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsGeminiGcpEnablementSettingsGetRequest
  object.

  Fields:
    name: Required. Name of the resource.
  """

  name = _messages.StringField(1, required=True)


class CloudaicompanionProjectsLocationsGeminiGcpEnablementSettingsListRequest(_messages.Message):
  r"""A
  CloudaicompanionProjectsLocationsGeminiGcpEnablementSettingsListRequest
  object.

  Fields:
    filter: Optional. Filtering results.
    orderBy: Optional. Hint for how to order the results.
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Parent value for ListGeminiGcpEnablementSettingsRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class CloudaicompanionProjectsLocationsGeminiGcpEnablementSettingsPatchRequest(_messages.Message):
  r"""A
  CloudaicompanionProjectsLocationsGeminiGcpEnablementSettingsPatchRequest
  object.

  Fields:
    geminiGcpEnablementSetting: A GeminiGcpEnablementSetting resource to be
      passed as the request body.
    name: Identifier. Name of the resource. Format:projects/{project}/location
      s/{location}/geminiGcpEnablementSettings/{geminiGcpEnablementSetting}
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    updateMask: Optional. Field mask is used to specify the fields to be
      overwritten in the GeminiGcpEnablementSetting resource by the update.
      The fields specified in the update_mask are relative to the resource,
      not the full request. A field will be overwritten if it is in the mask.
      If the user does not provide a mask then all fields present in the
      request will be overwritten.
  """

  geminiGcpEnablementSetting = _messages.MessageField('GeminiGcpEnablementSetting', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class CloudaicompanionProjectsLocationsGeminiGcpEnablementSettingsSettingBindingsCreateRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsGeminiGcpEnablementSettingsSettingBin
  dingsCreateRequest object.

  Fields:
    parent: Required. Value for parent.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    settingBinding: A SettingBinding resource to be passed as the request
      body.
    settingBindingId: Required. Id of the requesting object. If auto-
      generating Id server-side, remove this field and setting_id from the
      method_signature of Create RPC.
  """

  parent = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  settingBinding = _messages.MessageField('SettingBinding', 3)
  settingBindingId = _messages.StringField(4)


class CloudaicompanionProjectsLocationsGeminiGcpEnablementSettingsSettingBindingsDeleteRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsGeminiGcpEnablementSettingsSettingBin
  dingsDeleteRequest object.

  Fields:
    name: Required. Name of the resource.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class CloudaicompanionProjectsLocationsGeminiGcpEnablementSettingsSettingBindingsGetRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsGeminiGcpEnablementSettingsSettingBin
  dingsGetRequest object.

  Fields:
    name: Required. Name of the resource.
  """

  name = _messages.StringField(1, required=True)


class CloudaicompanionProjectsLocationsGeminiGcpEnablementSettingsSettingBindingsListRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsGeminiGcpEnablementSettingsSettingBin
  dingsListRequest object.

  Fields:
    filter: Optional. Filtering results.
    orderBy: Optional. Hint for how to order the results.
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Parent value for ListSettingBindingsRequest.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class CloudaicompanionProjectsLocationsGeminiGcpEnablementSettingsSettingBindingsPatchRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsGeminiGcpEnablementSettingsSettingBin
  dingsPatchRequest object.

  Fields:
    name: Identifier. Name of the resource. Format:projects/{project}/location
      s/{location}/{settingType}/{setting}/settingBindings/{setting_binding}
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    settingBinding: A SettingBinding resource to be passed as the request
      body.
    updateMask: Optional. Field mask is used to specify the fields to be
      overwritten in the SettingBinding resource by the update. The fields
      specified in the update_mask are relative to the resource, not the full
      request. A field will be overwritten if it is in the mask. If the user
      does not provide a mask then all fields present in the request will be
      overwritten.
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  settingBinding = _messages.MessageField('SettingBinding', 3)
  updateMask = _messages.StringField(4)


class CloudaicompanionProjectsLocationsGetRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class CloudaicompanionProjectsLocationsLoggingSettingsCreateRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsLoggingSettingsCreateRequest object.

  Fields:
    loggingSetting: A LoggingSetting resource to be passed as the request
      body.
    loggingSettingId: Required. Id of the requesting object. If auto-
      generating Id server-side, remove this field and setting_id from the
      method_signature of Create RPC.
    parent: Required. Value for parent.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  loggingSetting = _messages.MessageField('LoggingSetting', 1)
  loggingSettingId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class CloudaicompanionProjectsLocationsLoggingSettingsDeleteRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsLoggingSettingsDeleteRequest object.

  Fields:
    name: Required. Name of the resource.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class CloudaicompanionProjectsLocationsLoggingSettingsGetRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsLoggingSettingsGetRequest object.

  Fields:
    name: Required. Name of the resource.
  """

  name = _messages.StringField(1, required=True)


class CloudaicompanionProjectsLocationsLoggingSettingsListRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsLoggingSettingsListRequest object.

  Fields:
    filter: Optional. Filtering results.
    orderBy: Optional. Hint for how to order the results.
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Parent value for ListLoggingSettingsRequest.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class CloudaicompanionProjectsLocationsLoggingSettingsPatchRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsLoggingSettingsPatchRequest object.

  Fields:
    loggingSetting: A LoggingSetting resource to be passed as the request
      body.
    name: Identifier. Name of the resource. Format:projects/{project}/location
      s/{location}/loggingsettings/{loggingsetting}
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    updateMask: Optional. Field mask is used to specify the fields to be
      overwritten in the LoggingSetting resource by the update. The fields
      specified in the update_mask are relative to the resource, not the full
      request. A field will be overwritten if it is in the mask. If the user
      does not provide a mask then all fields present in the request will be
      overwritten.
  """

  loggingSetting = _messages.MessageField('LoggingSetting', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class CloudaicompanionProjectsLocationsLoggingSettingsSettingBindingsCreateRequest(_messages.Message):
  r"""A
  CloudaicompanionProjectsLocationsLoggingSettingsSettingBindingsCreateRequest
  object.

  Fields:
    parent: Required. Value for parent.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    settingBinding: A SettingBinding resource to be passed as the request
      body.
    settingBindingId: Required. Id of the requesting object. If auto-
      generating Id server-side, remove this field and setting_id from the
      method_signature of Create RPC.
  """

  parent = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  settingBinding = _messages.MessageField('SettingBinding', 3)
  settingBindingId = _messages.StringField(4)


class CloudaicompanionProjectsLocationsLoggingSettingsSettingBindingsDeleteRequest(_messages.Message):
  r"""A
  CloudaicompanionProjectsLocationsLoggingSettingsSettingBindingsDeleteRequest
  object.

  Fields:
    name: Required. Name of the resource.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class CloudaicompanionProjectsLocationsLoggingSettingsSettingBindingsGetRequest(_messages.Message):
  r"""A
  CloudaicompanionProjectsLocationsLoggingSettingsSettingBindingsGetRequest
  object.

  Fields:
    name: Required. Name of the resource.
  """

  name = _messages.StringField(1, required=True)


class CloudaicompanionProjectsLocationsLoggingSettingsSettingBindingsListRequest(_messages.Message):
  r"""A
  CloudaicompanionProjectsLocationsLoggingSettingsSettingBindingsListRequest
  object.

  Fields:
    filter: Optional. Filtering results.
    orderBy: Optional. Hint for how to order the results.
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Parent value for ListSettingBindingsRequest.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class CloudaicompanionProjectsLocationsLoggingSettingsSettingBindingsPatchRequest(_messages.Message):
  r"""A
  CloudaicompanionProjectsLocationsLoggingSettingsSettingBindingsPatchRequest
  object.

  Fields:
    name: Identifier. Name of the resource. Format:projects/{project}/location
      s/{location}/{settingType}/{setting}/settingBindings/{setting_binding}
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    settingBinding: A SettingBinding resource to be passed as the request
      body.
    updateMask: Optional. Field mask is used to specify the fields to be
      overwritten in the SettingBinding resource by the update. The fields
      specified in the update_mask are relative to the resource, not the full
      request. A field will be overwritten if it is in the mask. If the user
      does not provide a mask then all fields present in the request will be
      overwritten.
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  settingBinding = _messages.MessageField('SettingBinding', 3)
  updateMask = _messages.StringField(4)


class CloudaicompanionProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class CloudaicompanionProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class CloudaicompanionProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class CloudaicompanionProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
    returnPartialSuccess: When set to `true`, operations that are reachable
      are returned as normal, and those that are unreachable are returned in
      the ListOperationsResponse.unreachable field. This can only be `true`
      when reading across collections. For example, when `parent` is set to
      `"projects/example/locations/-"`. This field is not supported by default
      and will result in an `UNIMPLEMENTED` error if set unless explicitly
      documented otherwise in service or product specific documentation.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  returnPartialSuccess = _messages.BooleanField(5)


class CloudaicompanionProjectsLocationsReleaseChannelSettingsCreateRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsReleaseChannelSettingsCreateRequest
  object.

  Fields:
    parent: Required. Value for parent.
    releaseChannelSetting: A ReleaseChannelSetting resource to be passed as
      the request body.
    releaseChannelSettingId: Required. Id of the requesting object. If auto-
      generating Id server-side, remove this field and
      release_channel_setting_id from the method_signature of Create RPC
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  parent = _messages.StringField(1, required=True)
  releaseChannelSetting = _messages.MessageField('ReleaseChannelSetting', 2)
  releaseChannelSettingId = _messages.StringField(3)
  requestId = _messages.StringField(4)


class CloudaicompanionProjectsLocationsReleaseChannelSettingsDeleteRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsReleaseChannelSettingsDeleteRequest
  object.

  Fields:
    name: Required. Name of the resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class CloudaicompanionProjectsLocationsReleaseChannelSettingsGetRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsReleaseChannelSettingsGetRequest
  object.

  Fields:
    name: Required. Name of the resource.
  """

  name = _messages.StringField(1, required=True)


class CloudaicompanionProjectsLocationsReleaseChannelSettingsListRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsReleaseChannelSettingsListRequest
  object.

  Fields:
    filter: Optional. Filtering results.
    orderBy: Optional. Hint for how to order the results.
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Parent value for ListReleaseChannelSettingsRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class CloudaicompanionProjectsLocationsReleaseChannelSettingsPatchRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsReleaseChannelSettingsPatchRequest
  object.

  Fields:
    name: Identifier. Name of the resource. Format:projects/{project}/location
      s/{location}/releaseChannelSettings/{releaseChannelSetting}
    releaseChannelSetting: A ReleaseChannelSetting resource to be passed as
      the request body.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    updateMask: Optional. Field mask is used to specify the fields to be
      overwritten in the ReleaseChannelSetting resource by the update. The
      fields specified in the update_mask are relative to the resource, not
      the full request. A field will be overwritten if it is in the mask. If
      the user does not provide a mask then all fields present in the request
      will be overwritten.
  """

  name = _messages.StringField(1, required=True)
  releaseChannelSetting = _messages.MessageField('ReleaseChannelSetting', 2)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class CloudaicompanionProjectsLocationsReleaseChannelSettingsSettingBindingsCreateRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsReleaseChannelSettingsSettingBindings
  CreateRequest object.

  Fields:
    parent: Required. Value for parent.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    settingBinding: A SettingBinding resource to be passed as the request
      body.
    settingBindingId: Required. Id of the requesting object. If auto-
      generating Id server-side, remove this field and setting_id from the
      method_signature of Create RPC.
  """

  parent = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  settingBinding = _messages.MessageField('SettingBinding', 3)
  settingBindingId = _messages.StringField(4)


class CloudaicompanionProjectsLocationsReleaseChannelSettingsSettingBindingsDeleteRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsReleaseChannelSettingsSettingBindings
  DeleteRequest object.

  Fields:
    name: Required. Name of the resource.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class CloudaicompanionProjectsLocationsReleaseChannelSettingsSettingBindingsGetRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsReleaseChannelSettingsSettingBindings
  GetRequest object.

  Fields:
    name: Required. Name of the resource.
  """

  name = _messages.StringField(1, required=True)


class CloudaicompanionProjectsLocationsReleaseChannelSettingsSettingBindingsListRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsReleaseChannelSettingsSettingBindings
  ListRequest object.

  Fields:
    filter: Optional. Filtering results.
    orderBy: Optional. Hint for how to order the results.
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Parent value for ListSettingBindingsRequest.
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class CloudaicompanionProjectsLocationsReleaseChannelSettingsSettingBindingsPatchRequest(_messages.Message):
  r"""A CloudaicompanionProjectsLocationsReleaseChannelSettingsSettingBindings
  PatchRequest object.

  Fields:
    name: Identifier. Name of the resource. Format:projects/{project}/location
      s/{location}/{settingType}/{setting}/settingBindings/{setting_binding}
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    settingBinding: A SettingBinding resource to be passed as the request
      body.
    updateMask: Optional. Field mask is used to specify the fields to be
      overwritten in the SettingBinding resource by the update. The fields
      specified in the update_mask are relative to the resource, not the full
      request. A field will be overwritten if it is in the mask. If the user
      does not provide a mask then all fields present in the request will be
      overwritten.
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)
  settingBinding = _messages.MessageField('SettingBinding', 3)
  updateMask = _messages.StringField(4)


class CodeRepositoryIndex(_messages.Message):
  r"""Message describing CodeRepositoryIndex object

  Enums:
    StateValueValuesEnum: Output only. Code Repository Index instance State

  Messages:
    LabelsValue: Optional. Labels as key value pairs

  Fields:
    createTime: Output only. Create time stamp
    kmsKey: Optional. Immutable. Customer-managed encryption key name, in the
      format projects/*/locations/*/keyRings/*/cryptoKeys/*.
    labels: Optional. Labels as key value pairs
    name: Immutable. Identifier. name of resource
    state: Output only. Code Repository Index instance State
    updateTime: Output only. Update time stamp
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. Code Repository Index instance State

    Values:
      STATE_UNSPECIFIED: Not set.
      CREATING: Instance is being created.
      ACTIVE: Instance is active.
      DELETING: Instance is being deleted.
      SUSPENDED: Instance is suspended.
    """
    STATE_UNSPECIFIED = 0
    CREATING = 1
    ACTIVE = 2
    DELETING = 3
    SUSPENDED = 4

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Labels as key value pairs

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  kmsKey = _messages.StringField(2)
  labels = _messages.MessageField('LabelsValue', 3)
  name = _messages.StringField(4)
  state = _messages.EnumField('StateValueValuesEnum', 5)
  updateTime = _messages.StringField(6)


class CodeToolsSetting(_messages.Message):
  r"""Message describing CodeToolsSetting object

  Messages:
    LabelsValue: Optional. Labels as key value pairs.

  Fields:
    createTime: Output only. [Output only] Create time stamp.
    enabledTool: Required. Represents the full set of enabled tools.
    labels: Optional. Labels as key value pairs.
    name: Identifier. Name of the resource. Format:projects/{project}/location
      s/{location}/codeToolsSettings/{codeToolsSetting}
    updateTime: Output only. [Output only] Update time stamp.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Labels as key value pairs.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  enabledTool = _messages.MessageField('ToolSetting', 2, repeated=True)
  labels = _messages.MessageField('LabelsValue', 3)
  name = _messages.StringField(4)
  updateTime = _messages.StringField(5)


class ConfigItem(_messages.Message):
  r"""Message for a single configuration item.

  Fields:
    key: Required. Key of the configuration item.
    value: Required. Value of the configuration item.
  """

  key = _messages.StringField(1)
  value = _messages.StringField(2)


class ConfluenceConfig(_messages.Message):
  r"""Confluence Configuration.

  Fields:
    pageId: Optional. The optional page ID of the Confluence page.
    spaceKey: Required. The space key of the Confluence space.
    uri: Required. The host address of the Confluence instance.
  """

  pageId = _messages.StringField(1)
  spaceKey = _messages.StringField(2)
  uri = _messages.StringField(3)


class DataSharingWithGoogleSetting(_messages.Message):
  r"""Message describing DataSharingWithGoogleSetting object

  Messages:
    LabelsValue: Optional. Labels as key value pairs.

  Fields:
    createTime: Output only. [Output only] Create time stamp.
    enableDataSharing: Optional. Whether data sharing should be enabled in GA
      products.
    enablePreviewDataSharing: Optional. Whether data sharing should be enabled
      in Preview products.
    labels: Optional. Labels as key value pairs.
    name: Identifier. Name of the resource. Format:projects/{project}/location
      s/{location}/dataSharingWithGoogleSettings/{dataSharingWithGoogleSetting
      }
    updateTime: Output only. [Output only] Update time stamp.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Labels as key value pairs.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  enableDataSharing = _messages.BooleanField(2)
  enablePreviewDataSharing = _messages.BooleanField(3)
  labels = _messages.MessageField('LabelsValue', 4)
  name = _messages.StringField(5)
  updateTime = _messages.StringField(6)


class DataTransformerRecommendation(_messages.Message):
  r"""Individual DataTransformer recommendation containing the task config
  with the new code, integration parameters and the explanation.

  Fields:
    explanation: The explanation of the DataTransformer code.
    integrationParameters: Optional. The list of the new integration
      parameters.
    taskConfig: Optional. The task config of the DataTransformer task.
  """

  explanation = _messages.StringField(1)
  integrationParameters = _messages.MessageField('IntegrationParameter', 2, repeated=True)
  taskConfig = _messages.MessageField('TaskConfig', 3)


class DataTransformerRequest(_messages.Message):
  r"""Request message for Data Transformer Task using Gemini.

  Enums:
    GenerationModeValueValuesEnum: Required. The generation mode for the
      DataTransformer task.

  Fields:
    generationMode: Required. The generation mode for the DataTransformer
      task.
    integrationVersion: Required. The integration version which contains all
      the integration parameters, all triggers and tasks including the
      DataTransformer task.
    previousResponse: Optional. The previously present diagramMetadata either
      for regeneration or edit.
    taskId: Required. The task id of the DataTransformer task.
  """

  class GenerationModeValueValuesEnum(_messages.Enum):
    r"""Required. The generation mode for the DataTransformer task.

    Values:
      CREATE: Create a new transformation.
      REGENERATE: Regenerate the generated transformation.
      EDIT: Edit an existing transformation.
    """
    CREATE = 0
    REGENERATE = 1
    EDIT = 2

  generationMode = _messages.EnumField('GenerationModeValueValuesEnum', 1)
  integrationVersion = _messages.MessageField('IntegrationVersion', 2)
  previousResponse = _messages.StringField(3)
  taskId = _messages.StringField(4)


class DataTransformerResponse(_messages.Message):
  r"""Response message for DataTransformer Task using Gemini.

  Fields:
    recommendations: List of the DataTransformer recommendations.
  """

  recommendations = _messages.MessageField('DataTransformerRecommendation', 1, repeated=True)


class DoubleParameterArray(_messages.Message):
  r"""This message only contains a field of double number array.

  Fields:
    doubleValues: Double number array.
  """

  doubleValues = _messages.FloatField(1, repeated=True)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class ErrorCatcherConfig(_messages.Message):
  r"""Configuration detail of a error catch task

  Fields:
    description: Optional. User-provided description intended to give more
      business context about the error catcher config.
    errorCatcherId: Required. An error catcher id is string representation for
      the error catcher config. Within a workflow, error_catcher_id uniquely
      identifies an error catcher config among all error catcher configs for
      the workflow
    errorCatcherNumber: Required. A number to uniquely identify each error
      catcher config within the workflow on UI.
    label: Optional. The user created label for a particular error catcher.
      Optional.
    startErrorTasks: Required. The set of start tasks that are to be executed
      for the error catch flow
  """

  description = _messages.StringField(1)
  errorCatcherId = _messages.StringField(2)
  errorCatcherNumber = _messages.StringField(3)
  label = _messages.StringField(4)
  startErrorTasks = _messages.MessageField('NextTask', 5, repeated=True)


class EventParameter(_messages.Message):
  r"""This message is used for processing and persisting (when applicable) key
  value pair parameters for each event in the event bus.

  Fields:
    key: Key is used to retrieve the corresponding parameter value. This
      should be unique for a given fired event. These parameters must be
      predefined in the integration definition.
    value: Values for the defined keys. Each value can either be string, int,
      double or any proto message.
  """

  key = _messages.StringField(1)
  value = _messages.MessageField('ValueType', 2)


class Execution(_messages.Message):
  r"""The Execution contains detailed information of an individual integration
  execution.

  Enums:
    StateValueValuesEnum: Output only. Status of the execution.

  Messages:
    RequestVariablesValue: Optional. Variables provided in the request.
    ResponseVariablesValue: Optional. Variables returned as part of the
      response.

  Fields:
    cloudLoggingDetails: Cloud Logging details for the integration version
    containTaskVariables: Indicates if the task execution contains variables.
    createTime: Output only. Time the execution is created.
    executionAttemptStats: Start and end time of each execution attempt.
    integrationVersionNumber: Indicates which snapshot of integration is used
      for this execution.
    integrationVersionUserLabel: Optional. User-defined label that annotates
      the executed integration version.
    name: Identifier. Execution resource name.
    replayInfo: Output only. Replay info for the execution
    requestVariables: Optional. Variables provided in the request.
    responseVariables: Optional. Variables returned as part of the response.
    state: Output only. Status of the execution.
    taskExecutions: Optional. List of task executions.
    triggerId: The ID of the trigger invoked at the start of the execution.
    updateTime: Output only. Time the execution is recently updated.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. Status of the execution.

    Values:
      STATE_UNSPECIFIED: Default.
      ON_HOLD: Execution is scheduled and awaiting to be triggered.
      IN_PROCESS: Execution is processing.
      SUCCEEDED: Execution successfully finished. There are no more changes
        after this state.
      FAILED: Execution failed. There's no more change after this state.
      CANCELLED: Execution is cancelled. There's no more change after this
        state.
      RETRY_ON_HOLD: Execution failed and is waiting for retry.
      SUSPENDED: Execution suspended and waiting for manual intervention.
    """
    STATE_UNSPECIFIED = 0
    ON_HOLD = 1
    IN_PROCESS = 2
    SUCCEEDED = 3
    FAILED = 4
    CANCELLED = 5
    RETRY_ON_HOLD = 6
    SUSPENDED = 7

  @encoding.MapUnrecognizedFields('additionalProperties')
  class RequestVariablesValue(_messages.Message):
    r"""Optional. Variables provided in the request.

    Messages:
      AdditionalProperty: An additional property for a RequestVariablesValue
        object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a RequestVariablesValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseVariablesValue(_messages.Message):
    r"""Optional. Variables returned as part of the response.

    Messages:
      AdditionalProperty: An additional property for a ResponseVariablesValue
        object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseVariablesValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  cloudLoggingDetails = _messages.MessageField('CloudLoggingDetails', 1)
  containTaskVariables = _messages.BooleanField(2)
  createTime = _messages.StringField(3)
  executionAttemptStats = _messages.MessageField('AttemptStats', 4, repeated=True)
  integrationVersionNumber = _messages.IntegerField(5)
  integrationVersionUserLabel = _messages.StringField(6)
  name = _messages.StringField(7)
  replayInfo = _messages.MessageField('ReplayInfo', 8)
  requestVariables = _messages.MessageField('RequestVariablesValue', 9)
  responseVariables = _messages.MessageField('ResponseVariablesValue', 10)
  state = _messages.EnumField('StateValueValuesEnum', 11)
  taskExecutions = _messages.MessageField('TaskExecution', 12, repeated=True)
  triggerId = _messages.StringField(13)
  updateTime = _messages.StringField(14)


class Expr(_messages.Message):
  r"""Represents a textual expression in the Common Expression Language (CEL)
  syntax. CEL is a C-like expression language. The syntax and semantics of CEL
  are documented at https://github.com/google/cel-spec. Example (Comparison):
  title: "Summary size limit" description: "Determines if a summary is less
  than 100 chars" expression: "document.summary.size() < 100" Example
  (Equality): title: "Requestor is owner" description: "Determines if
  requestor is the document owner" expression: "document.owner ==
  request.auth.claims.email" Example (Logic): title: "Public documents"
  description: "Determine whether the document should be publicly visible"
  expression: "document.type != 'private' && document.type != 'internal'"
  Example (Data Manipulation): title: "Notification string" description:
  "Create a notification string with a timestamp." expression: "'New message
  received at ' + string(document.create_time)" The exact variables and
  functions that may be referenced within an expression are determined by the
  service that evaluates it. See the service documentation for additional
  information.

  Fields:
    description: Optional. Description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.
    location: Optional. String indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: Optional. Title for the expression, i.e. a short string describing
      its purpose. This can be used e.g. in UIs which allow to enter the
      expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class GeminiGcpEnablementSetting(_messages.Message):
  r"""Message describing GeminiGcpEnablementSetting object

  Enums:
    WebGroundingTypeValueValuesEnum: Optional. Web grounding type.

  Messages:
    LabelsValue: Optional. Labels as key value pairs.

  Fields:
    createTime: Output only. [Output only] Create time stamp.
    disableWebGrounding: Optional. Whether web grounding should be disabled.
      DEPRECATED: Use web_grounding_type instead.
    enableCustomerDataSharing: Optional. Not implemented.
    labels: Optional. Labels as key value pairs.
    name: Identifier. Name of the resource. Format:projects/{project}/location
      s/{location}/geminiGcpEnablementSettings/{geminiGcpEnablementSetting}
    updateTime: Output only. [Output only] Update time stamp.
    webGroundingType: Optional. Web grounding type.
  """

  class WebGroundingTypeValueValuesEnum(_messages.Enum):
    r"""Optional. Web grounding type.

    Values:
      WEB_GROUNDING_TYPE_UNSPECIFIED: Unspecified grounding.
      GROUNDING_WITH_GOOGLE_SEARCH: Grounding with Google Search.
      WEB_GROUNDING_FOR_ENTERPRISE: Grounding with Google Search for
        Enterprise.
    """
    WEB_GROUNDING_TYPE_UNSPECIFIED = 0
    GROUNDING_WITH_GOOGLE_SEARCH = 1
    WEB_GROUNDING_FOR_ENTERPRISE = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Labels as key value pairs.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  disableWebGrounding = _messages.BooleanField(2)
  enableCustomerDataSharing = _messages.BooleanField(3)
  labels = _messages.MessageField('LabelsValue', 4)
  name = _messages.StringField(5)
  updateTime = _messages.StringField(6)
  webGroundingType = _messages.EnumField('WebGroundingTypeValueValuesEnum', 7)


class IntParameterArray(_messages.Message):
  r"""This message only contains a field of integer array.

  Fields:
    intValues: Integer array.
  """

  intValues = _messages.IntegerField(1, repeated=True)


class IntegrationBranch(_messages.Message):
  r"""An integration branch skeleton containing basic fields which can be used
  to create an integration branch on the UI.

  Fields:
    branchCondition: The condition for the branch.
    explanation: Explanation of why this integration branch was generated.
    integrationParameters: The newly generated workflow parameters.
    taskConfigs: The newly generated tasks which can be branched into the
      current integration.
  """

  branchCondition = _messages.StringField(1)
  explanation = _messages.StringField(2)
  integrationParameters = _messages.MessageField('IntegrationParameter', 3, repeated=True)
  taskConfigs = _messages.MessageField('TaskConfig', 4, repeated=True)


class IntegrationBranchRequest(_messages.Message):
  r"""The request for generating an integration branch.

  Fields:
    branchCondition: Optional. The condition for the particular branch which
      the user selected.
    integrationParameters: Optional. A list of all the workflow parameters of
      the current integration.
    taskConfigs: Required. A list of all the tasks of the current integration.
  """

  branchCondition = _messages.StringField(1)
  integrationParameters = _messages.MessageField('IntegrationParameter', 2, repeated=True)
  taskConfigs = _messages.MessageField('TaskConfig', 3, repeated=True)


class IntegrationBranchResponse(_messages.Message):
  r"""The response containing an integration branch.

  Fields:
    integrationBranch: The integration branch returned by Duet
  """

  integrationBranch = _messages.MessageField('IntegrationBranch', 1)


class IntegrationConfigParameter(_messages.Message):
  r"""Integration Config Parameter is defined in the integration config and
  are used to provide external configuration for integration. It provide
  information about data types of the expected parameters and provide any
  default values or value. They can also be used to add custom attributes.

  Fields:
    parameter: Optional. Integration Parameter to provide the default value,
      data type and attributes required for the Integration config variables.
    value: Values for the defined keys. Each value can either be string, int,
      double or any proto message or a serialized object.
  """

  parameter = _messages.MessageField('IntegrationParameter', 1)
  value = _messages.MessageField('ValueType', 2)


class IntegrationDocumentRequest(_messages.Message):
  r"""The request for generating description of an integration.

  Fields:
    integrationVersion: Required. The current integrtion on the canvas.
  """

  integrationVersion = _messages.MessageField('IntegrationVersion', 1)


class IntegrationDocumentResponse(_messages.Message):
  r"""The response containing the integration description.

  Fields:
    document: The description of the integration returned by Duet AI.
  """

  document = _messages.StringField(1)


class IntegrationParameter(_messages.Message):
  r"""Integration Parameter is defined in the integration config and are used
  to provide information about data types of the expected parameters and
  provide any default values if needed. They can also be used to add custom
  attributes. These are static in nature and should not be used for dynamic
  event definition.

  Enums:
    DataTypeValueValuesEnum: Type of the parameter.
    InputOutputTypeValueValuesEnum: Specifies the input/output type for the
      parameter.

  Fields:
    dataType: Type of the parameter.
    defaultValue: Default values for the defined keys. Each value can either
      be string, int, double or any proto message or a serialized object.
    description: Optional. Description of the parameter.
    displayName: The name (without prefix) to be displayed in the UI for this
      parameter. E.g. if the key is "foo.bar.myName", then the name would be
      "myName".
    inputOutputType: Specifies the input/output type for the parameter.
    isTransient: Whether this parameter is a transient parameter.
    jsonSchema: This schema will be used to validate runtime JSON-typed values
      of this parameter.
    key: Key is used to retrieve the corresponding parameter value. This
      should be unique for a given fired event. These parameters must be
      predefined in the integration definition.
  """

  class DataTypeValueValuesEnum(_messages.Enum):
    r"""Type of the parameter.

    Values:
      INTEGRATION_PARAMETER_DATA_TYPE_UNSPECIFIED: Unspecified.
      STRING_VALUE: String.
      INT_VALUE: Integer.
      DOUBLE_VALUE: Double Number.
      BOOLEAN_VALUE: Boolean.
      STRING_ARRAY: String Array.
      INT_ARRAY: Integer Array.
      DOUBLE_ARRAY: Double Number Array.
      BOOLEAN_ARRAY: Boolean Array.
      JSON_VALUE: Json.
      PROTO_VALUE: Proto Value (Internal use only).
      PROTO_ARRAY: Proto Array (Internal use only).
    """
    INTEGRATION_PARAMETER_DATA_TYPE_UNSPECIFIED = 0
    STRING_VALUE = 1
    INT_VALUE = 2
    DOUBLE_VALUE = 3
    BOOLEAN_VALUE = 4
    STRING_ARRAY = 5
    INT_ARRAY = 6
    DOUBLE_ARRAY = 7
    BOOLEAN_ARRAY = 8
    JSON_VALUE = 9
    PROTO_VALUE = 10
    PROTO_ARRAY = 11

  class InputOutputTypeValueValuesEnum(_messages.Enum):
    r"""Specifies the input/output type for the parameter.

    Values:
      IN_OUT_TYPE_UNSPECIFIED: Default.
      IN: Input parameters for the integration. EventBus validates that these
        parameters exist in the integrations before execution.
      OUT: Output Parameters for the integration. EventBus will only return
        the integration parameters tagged with OUT in the response back.
      IN_OUT: Input and Output Parameters. These can be used as both input and
        output. EventBus will validate for the existence of these parameters
        before execution and will also return this parameter back in the
        response.
    """
    IN_OUT_TYPE_UNSPECIFIED = 0
    IN = 1
    OUT = 2
    IN_OUT = 3

  dataType = _messages.EnumField('DataTypeValueValuesEnum', 1)
  defaultValue = _messages.MessageField('ValueType', 2)
  description = _messages.StringField(3)
  displayName = _messages.StringField(4)
  inputOutputType = _messages.EnumField('InputOutputTypeValueValuesEnum', 5)
  isTransient = _messages.BooleanField(6)
  jsonSchema = _messages.StringField(7)
  key = _messages.StringField(8)


class IntegrationSkeleton(_messages.Message):
  r"""An integration skeleton containing basic fields which can be used to
  create an integration on the UI.

  Fields:
    explanation: Explanation of why this integration was generated.
    integrationVersion: The integration version containing basic triggers and
      tasks.
    name: The name of the integration.
    tag: Indicate the strategy/methodology used to generate the integration.
  """

  explanation = _messages.StringField(1)
  integrationVersion = _messages.MessageField('IntegrationVersion', 2)
  name = _messages.StringField(3)
  tag = _messages.StringField(4)


class IntegrationSkeletonsRequest(_messages.Message):
  r"""The request containing a list of integrations.

  Fields:
    copilotEnabled: The list of integration skeletons returned by Duet AI.
  """

  copilotEnabled = _messages.BooleanField(1)


class IntegrationSkeletonsResponse(_messages.Message):
  r"""The response containing a list of integrations.

  Fields:
    skeletonIntegrations: The list of integration skeletons returned by Duet
      AI.
  """

  skeletonIntegrations = _messages.MessageField('IntegrationSkeleton', 1, repeated=True)


class IntegrationVersion(_messages.Message):
  r"""The integration version definition.

  Enums:
    StateValueValuesEnum: Output only. User should not set it as an input.

  Fields:
    description: Optional. The integration description.
    errorCatcherConfigs: Optional. Error Catch Task configuration for the
      integration. It's optional.
    integrationConfigParameters: Optional. Config Parameters that are expected
      to be passed to the integration when an integration is published. This
      consists of all the parameters that are expected to provide
      configuration in the integration execution. This gives the user the
      ability to provide default values, value, add information like
      connection url, project based configuration value and also provide data
      types of each parameter.
    integrationParameters: Optional. Parameters that are expected to be passed
      to the integration when an event is triggered. This consists of all the
      parameters that are expected in the integration execution. This gives
      the user the ability to provide default values, add information like PII
      and also provide data types of each parameter.
    name: Optional. Auto-generated primary key.
    snapshotNumber: Optional. An increasing sequence that is set when a new
      snapshot is created. The last created snapshot can be identified by
      [workflow_name, org_id latest(snapshot_number)]. However, last created
      snapshot need not be same as the HEAD. So users should always use "HEAD"
      tag to identify the head.
    state: Output only. User should not set it as an input.
    taskConfigs: Optional. Task configuration for the integration. It's
      optional, but the integration doesn't do anything without task_configs.
    triggerConfigs: Optional. Trigger configurations.
    userLabel: Optional. A user-defined label that annotates an integration
      version. Typically, this is only set when the integration version is
      created.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. User should not set it as an input.

    Values:
      INTEGRATION_STATE_UNSPECIFIED: Default.
      DRAFT: Draft.
      ACTIVE: Active.
      ARCHIVED: Archived.
      SNAPSHOT: Snapshot.
    """
    INTEGRATION_STATE_UNSPECIFIED = 0
    DRAFT = 1
    ACTIVE = 2
    ARCHIVED = 3
    SNAPSHOT = 4

  description = _messages.StringField(1)
  errorCatcherConfigs = _messages.MessageField('ErrorCatcherConfig', 2, repeated=True)
  integrationConfigParameters = _messages.MessageField('IntegrationConfigParameter', 3, repeated=True)
  integrationParameters = _messages.MessageField('IntegrationParameter', 4, repeated=True)
  name = _messages.StringField(5)
  snapshotNumber = _messages.IntegerField(6)
  state = _messages.EnumField('StateValueValuesEnum', 7)
  taskConfigs = _messages.MessageField('TaskConfig', 8, repeated=True)
  triggerConfigs = _messages.MessageField('TriggerConfig', 9, repeated=True)
  userLabel = _messages.StringField(10)


class JavascriptRecommendation(_messages.Message):
  r"""Individual Javascript recommendation containing the task config with the
  new code, integration parameters and the explanation.

  Fields:
    explanation: The explanation of the Javascript code.
    integrationParameters: Optional. The list of the new integration
      parameters.
    taskConfig: Optional. The task config of the Javascript task.
  """

  explanation = _messages.StringField(1)
  integrationParameters = _messages.MessageField('IntegrationParameter', 2, repeated=True)
  taskConfig = _messages.MessageField('TaskConfig', 3)


class JavascriptRequest(_messages.Message):
  r"""Request message for Javascript Task using Gemini.

  Fields:
    copilotEnabled: Optional. If this request is for copilot.
    integrationVersion: Required. The integration version which contains all
      the integration parameters, all triggers and tasks including the
      Javascript task.
    taskId: Required. The task id of the Javascript task.
    useCurrentScript: Optional. Whether to use the current javascript task
      config (JS code) to generate the Javascript code.
  """

  copilotEnabled = _messages.BooleanField(1)
  integrationVersion = _messages.MessageField('IntegrationVersion', 2)
  taskId = _messages.StringField(3)
  useCurrentScript = _messages.BooleanField(4)


class JavascriptResponse(_messages.Message):
  r"""Response message for Javascript Task using Gemini.

  Fields:
    recommendations: List of the Javascript recommendations.
  """

  recommendations = _messages.MessageField('JavascriptRecommendation', 1, repeated=True)


class ListCodeRepositoryIndexesResponse(_messages.Message):
  r"""Message for response to listing CodeRepositoryIndexes

  Fields:
    codeRepositoryIndexes: The list of CodeRepositoryIndex
    nextPageToken: A token identifying a page of results the server should
      return.
  """

  codeRepositoryIndexes = _messages.MessageField('CodeRepositoryIndex', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListCodeToolsSettingsResponse(_messages.Message):
  r"""Message for response to listing CodeToolsSettings

  Fields:
    codeToolsSettings: The list of CodeToolsSetting
    nextPageToken: A token identifying a page of results the server should
      return.
    unreachable: Unordered list. Locations that could not be reached.
  """

  codeToolsSettings = _messages.MessageField('CodeToolsSetting', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListDataSharingWithGoogleSettingsResponse(_messages.Message):
  r"""Message for response to listing DataSharingWithGoogleSettings

  Fields:
    dataSharingWithGoogleSettings: The list of DataSharingWithGoogleSetting
    nextPageToken: A token identifying a page of results the server should
      return.
    unreachable: Unordered list. Locations that could not be reached.
  """

  dataSharingWithGoogleSettings = _messages.MessageField('DataSharingWithGoogleSetting', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListGeminiGcpEnablementSettingsResponse(_messages.Message):
  r"""Message for response to listing GeminiGcpEnablementSettings

  Fields:
    geminiGcpEnablementSettings: The list of GeminiGcpEnablementSetting
    nextPageToken: A token identifying a page of results the server should
      return.
    unreachable: Unordered list. Locations that could not be reached.
  """

  geminiGcpEnablementSettings = _messages.MessageField('GeminiGcpEnablementSetting', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListLoggingSettingsResponse(_messages.Message):
  r"""Message for response to listing LoggingSettings

  Fields:
    loggingSettings: The list of LoggingSettings.
    nextPageToken: A token identifying a page of results the server should
      return.
    unreachable: Unordered list. Locations that could not be reached.
  """

  loggingSettings = _messages.MessageField('LoggingSetting', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
    unreachable: Unordered list. Unreachable resources. Populated when the
      request sets `ListOperationsRequest.return_partial_success` and reads
      across collections. For example, when attempting to list all resources
      across all supported locations.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class ListReleaseChannelSettingsResponse(_messages.Message):
  r"""Message for response to listing ReleaseChannelSettings

  Fields:
    nextPageToken: A token identifying a page of results the server should
      return.
    releaseChannelSettings: The list of ReleaseChannelSetting
    unreachable: Unordered list. Locations that could not be reached.
  """

  nextPageToken = _messages.StringField(1)
  releaseChannelSettings = _messages.MessageField('ReleaseChannelSetting', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class ListRepositoryGroupsResponse(_messages.Message):
  r"""Message for response to listing RepositoryGroups

  Fields:
    nextPageToken: A token identifying a page of results the server should
      return.
    repositoryGroups: The list of RepositoryGroup
  """

  nextPageToken = _messages.StringField(1)
  repositoryGroups = _messages.MessageField('RepositoryGroup', 2, repeated=True)


class ListSettingBindingsResponse(_messages.Message):
  r"""Message for response to listing SettingBindings

  Fields:
    nextPageToken: A token identifying a page of results the server should
      return.
    settingBindings: The list of SettingBindings.
    unreachable: Unordered list. Locations that could not be reached.
  """

  nextPageToken = _messages.StringField(1)
  settingBindings = _messages.MessageField('SettingBinding', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents a Google Cloud location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class LoggingSetting(_messages.Message):
  r"""Message describing LoggingSetting object

  Messages:
    LabelsValue: Optional. Labels as key value pairs.

  Fields:
    createTime: Output only. [Output only] Create time stamp.
    labels: Optional. Labels as key value pairs.
    logMetadata: Optional. Whether to log metadata.
    logPromptsAndResponses: Optional. Whether to log prompts and responses.
    name: Identifier. Name of the resource. Format:projects/{project}/location
      s/{location}/loggingsettings/{loggingsetting}
    updateTime: Output only. [Output only] Update time stamp.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Labels as key value pairs.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  logMetadata = _messages.BooleanField(3)
  logPromptsAndResponses = _messages.BooleanField(4)
  name = _messages.StringField(5)
  updateTime = _messages.StringField(6)


class NextTask(_messages.Message):
  r"""The task that is next in line to be executed, if the condition specified
  evaluated to true.

  Fields:
    condition: Standard filter expression for this task to become an eligible
      next task.
    description: User-provided description intended to give additional
      business context about the task.
    displayName: User-provided label that is attached to this edge in the UI.
    taskConfigId: ID of the next task.
    taskId: Task number of the next task.
  """

  condition = _messages.StringField(1)
  description = _messages.StringField(2)
  displayName = _messages.StringField(3)
  taskConfigId = _messages.StringField(4)
  taskId = _messages.StringField(5)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal, successful response of the operation. If the original
    method returns no data on success, such as `Delete`, the response is
    `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class Policy(_messages.Message):
  r"""An Identity and Access Management (IAM) policy, which specifies access
  controls for Google Cloud resources. A `Policy` is a collection of
  `bindings`. A `binding` binds one or more `members`, or principals, to a
  single `role`. Principals can be user accounts, service accounts, Google
  groups, and domains (such as G Suite). A `role` is a named list of
  permissions; each `role` can be an IAM predefined role or a user-created
  custom role. For some types of Google Cloud resources, a `binding` can also
  specify a `condition`, which is a logical expression that allows access to a
  resource only if the expression evaluates to `true`. A condition can add
  constraints based on attributes of the request, the resource, or both. To
  learn which resources support conditions in their IAM policies, see the [IAM
  documentation](https://cloud.google.com/iam/help/conditions/resource-
  policies). **JSON example:** ``` { "bindings": [ { "role":
  "roles/resourcemanager.organizationAdmin", "members": [
  "user:mike@example.com", "group:admins@example.com", "domain:google.com",
  "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
  "roles/resourcemanager.organizationViewer", "members": [
  "user:eve@example.com" ], "condition": { "title": "expirable access",
  "description": "Does not grant access after Sep 2020", "expression":
  "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
  "BwWWja0YfJA=", "version": 3 } ``` **YAML example:** ``` bindings: -
  members: - user:mike@example.com - group:admins@example.com -
  domain:google.com - serviceAccount:my-project-id@appspot.gserviceaccount.com
  role: roles/resourcemanager.organizationAdmin - members: -
  user:eve@example.com role: roles/resourcemanager.organizationViewer
  condition: title: expirable access description: Does not grant access after
  Sep 2020 expression: request.time < timestamp('2020-10-01T00:00:00.000Z')
  etag: BwWWja0YfJA= version: 3 ``` For a description of IAM and its features,
  see the [IAM documentation](https://cloud.google.com/iam/docs/).

  Fields:
    auditConfigs: Specifies cloud audit logging configuration for this policy.
    bindings: Associates a list of `members`, or principals, with a `role`.
      Optionally, may specify a `condition` that determines how and when the
      `bindings` are applied. Each of the `bindings` must contain at least one
      principal. The `bindings` in a `Policy` can refer to up to 1,500
      principals; up to 250 of these principals can be Google groups. Each
      occurrence of a principal counts towards these limits. For example, if
      the `bindings` grant 50 different roles to `user:alice@example.com`, and
      not to any other principal, then you can add another 1,450 principals to
      the `bindings` in the `Policy`.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy. **Important:** If you use IAM Conditions, you must include the
      `etag` field whenever you call `setIamPolicy`. If you omit this field,
      then IAM allows you to overwrite a version `3` policy with a version `1`
      policy, and all of the conditions in the version `3` policy are lost.
    version: Specifies the format of the policy. Valid values are `0`, `1`,
      and `3`. Requests that specify an invalid value are rejected. Any
      operation that affects conditional role bindings must specify version
      `3`. This requirement applies to the following operations: * Getting a
      policy that includes a conditional role binding * Adding a conditional
      role binding to a policy * Changing a conditional role binding in a
      policy * Removing any role binding, with or without a condition, from a
      policy that includes conditions **Important:** If you use IAM
      Conditions, you must include the `etag` field whenever you call
      `setIamPolicy`. If you omit this field, then IAM allows you to overwrite
      a version `3` policy with a version `1` policy, and all of the
      conditions in the version `3` policy are lost. If a policy does not
      include any conditions, operations on that policy may specify any valid
      version or leave the field unset. To learn which resources support
      conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
  """

  auditConfigs = _messages.MessageField('AuditConfig', 1, repeated=True)
  bindings = _messages.MessageField('Binding', 2, repeated=True)
  etag = _messages.BytesField(3)
  version = _messages.IntegerField(4, variant=_messages.Variant.INT32)


class ReleaseChannelSetting(_messages.Message):
  r"""Message describing ReleaseChannelSetting object

  Enums:
    ReleaseChannelValueValuesEnum: Optional. Release channel to be used.

  Messages:
    LabelsValue: Optional. Labels as key value pairs.

  Fields:
    createTime: Output only. [Output only] Create time stamp.
    labels: Optional. Labels as key value pairs.
    name: Identifier. Name of the resource. Format:projects/{project}/location
      s/{location}/releaseChannelSettings/{releaseChannelSetting}
    releaseChannel: Optional. Release channel to be used.
    updateTime: Output only. [Output only] Update time stamp.
  """

  class ReleaseChannelValueValuesEnum(_messages.Enum):
    r"""Optional. Release channel to be used.

    Values:
      CHANNEL_TYPE_UNSPECIFIED: Unspecified release channel.
      STABLE: Stable channel.
      EXPERIMENTAL: Experimental release channel.
    """
    CHANNEL_TYPE_UNSPECIFIED = 0
    STABLE = 1
    EXPERIMENTAL = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Labels as key value pairs.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  name = _messages.StringField(3)
  releaseChannel = _messages.EnumField('ReleaseChannelValueValuesEnum', 4)
  updateTime = _messages.StringField(5)


class ReplaceTaskRequest(_messages.Message):
  r"""Message for Replace Task Scenario.

  Enums:
    TaskTypesValueListEntryValuesEnum:

  Fields:
    copilotEnabled: Optional. If this request is for copilot.
    taskConfig: Required. The current task selected on the UI.
    taskTypes: The list of task types.
  """

  class TaskTypesValueListEntryValuesEnum(_messages.Enum):
    r"""TaskTypesValueListEntryValuesEnum enum type.

    Values:
      TASK_TYPE_UNSPECIFIED: Unspecified.
      CONNECTOR_TASK: Connector Task.
      REST_TASK: Rest task.
    """
    TASK_TYPE_UNSPECIFIED = 0
    CONNECTOR_TASK = 1
    REST_TASK = 2

  copilotEnabled = _messages.BooleanField(1)
  taskConfig = _messages.MessageField('TaskConfig', 2)
  taskTypes = _messages.EnumField('TaskTypesValueListEntryValuesEnum', 3, repeated=True)


class ReplaceTaskResponse(_messages.Message):
  r"""Response proto for task recommendations.

  Fields:
    taskConfigs: The list of recommended tasks.
    taskResponseStatus: The list of task response status based on the
      task_types in the request.
  """

  taskConfigs = _messages.MessageField('TaskConfig', 1, repeated=True)
  taskResponseStatus = _messages.MessageField('TaskResponseStatus', 2, repeated=True)


class ReplayInfo(_messages.Message):
  r"""Contains the details of the execution info: this includes the replay
  reason and replay tree connecting executions in a parent-child relationship

  Enums:
    ReplayModeValueValuesEnum: Replay mode for the execution

  Fields:
    originalExecutionId: If this execution is a replay of another execution,
      then this field contains the original execution id.
    replayMode: Replay mode for the execution
    replayReason: reason for replay
    replayedExecutionIds: If this execution has been replayed, then this field
      contains the execution ids of the replayed executions.
  """

  class ReplayModeValueValuesEnum(_messages.Enum):
    r"""Replay mode for the execution

    Values:
      REPLAY_MODE_UNSPECIFIED: Default value.
      REPLAY_MODE_FROM_BEGINNING: Replay the original execution from the
        beginning.
      REPLAY_MODE_POINT_OF_FAILURE: Replay the execution from the first failed
        task.
    """
    REPLAY_MODE_UNSPECIFIED = 0
    REPLAY_MODE_FROM_BEGINNING = 1
    REPLAY_MODE_POINT_OF_FAILURE = 2

  originalExecutionId = _messages.StringField(1)
  replayMode = _messages.EnumField('ReplayModeValueValuesEnum', 2)
  replayReason = _messages.StringField(3)
  replayedExecutionIds = _messages.StringField(4, repeated=True)


class Repository(_messages.Message):
  r"""Repository contains RAG indexing settings for the provided Git
  repository

  Fields:
    branchPattern: Required. The Git branch pattern used for indexing in RE2
      syntax. See https://github.com/google/re2/wiki/syntax for syntax.
    connectionConfig: Output only. Configuration details of the connection
      associated with this repository.
    repositoryUri: Output only. The clone URI of the Git repository.
    resource: Required. The DeveloperConnect repository full resource name,
      relative resource name or resource URL to be indexed.
  """

  branchPattern = _messages.StringField(1)
  connectionConfig = _messages.StringField(2)
  repositoryUri = _messages.StringField(3)
  resource = _messages.StringField(4)


class RepositoryGroup(_messages.Message):
  r"""Message describing RepositoryGroup object

  Messages:
    LabelsValue: Optional. Labels as key value pairs

  Fields:
    createTime: Output only. Create time stamp
    labels: Optional. Labels as key value pairs
    name: Immutable. Identifier. name of resource
    repositories: Optional. List of repositories to group
    resources: Optional. List of third party connection resources
    updateTime: Output only. Update time stamp
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Labels as key value pairs

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  name = _messages.StringField(3)
  repositories = _messages.MessageField('Repository', 4, repeated=True)
  resources = _messages.MessageField('ThirdPartyConnection', 5, repeated=True)
  updateTime = _messages.StringField(6)


class ResourceAuthConfig(_messages.Message):
  r"""Message for Authentication Configuration.

  Fields:
    apiToken: API Token based authentication.
  """

  apiToken = _messages.MessageField('APIToken', 1)


class SetIamPolicyRequest(_messages.Message):
  r"""Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Google Cloud services (such as Projects) might
      reject them.
    updateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
      modify. Only the fields in the mask will be modified. If no mask is
      provided, the following default mask is used: `paths: "bindings, etag"`
  """

  policy = _messages.MessageField('Policy', 1)
  updateMask = _messages.StringField(2)


class SettingBinding(_messages.Message):
  r"""Message describing SettingBinding object

  Enums:
    ProductValueValuesEnum: Optional. Product type of the setting binding.

  Messages:
    LabelsValue: Optional. Labels as key value pairs.

  Fields:
    createTime: Output only. [Output only] Create time stamp.
    labels: Optional. Labels as key value pairs.
    name: Identifier. Name of the resource. Format:projects/{project}/location
      s/{location}/{settingType}/{setting}/settingBindings/{setting_binding}
    product: Optional. Product type of the setting binding.
    target: Required. Target of the binding.
    updateTime: Output only. [Output only] Update time stamp.
  """

  class ProductValueValuesEnum(_messages.Enum):
    r"""Optional. Product type of the setting binding.

    Values:
      PRODUCT_UNSPECIFIED: Unspecified product.
      GEMINI_CLOUD_ASSIST: Gemini Cloud Assist.
      GEMINI_CODE_ASSIST: Gemini Code Assist.
      GEMINI_IN_BIGQUERY: Gemini in BigQuery.
      GEMINI_IN_LOOKER: Gemini in Looker.
    """
    PRODUCT_UNSPECIFIED = 0
    GEMINI_CLOUD_ASSIST = 1
    GEMINI_CODE_ASSIST = 2
    GEMINI_IN_BIGQUERY = 3
    GEMINI_IN_LOOKER = 4

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Labels as key value pairs.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  name = _messages.StringField(3)
  product = _messages.EnumField('ProductValueValuesEnum', 4)
  target = _messages.StringField(5)
  updateTime = _messages.StringField(6)


class SourceConfig(_messages.Message):
  r"""Configuration for 3P Source.

  Fields:
    confluenceConfig: Confluence source configuration.
  """

  confluenceConfig = _messages.MessageField('ConfluenceConfig', 1)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class StringParameterArray(_messages.Message):
  r"""This message only contains a field of string array.

  Fields:
    stringValues: String array.
  """

  stringValues = _messages.StringField(1, repeated=True)


class TaskConfig(_messages.Message):
  r"""The task configuration details. This is not the implementation of Task.
  There might be multiple TaskConfigs for the same Task.

  Enums:
    ExternalTaskTypeValueValuesEnum: Optional. External task type of the task

  Messages:
    ParametersValue: Optional. The customized parameters the user can pass to
      this task.

  Fields:
    description: Optional. User-provided description intended to give
      additional business context about the task.
    displayName: Optional. User-provided label that is attached to this
      TaskConfig in the UI.
    errorCatcherId: Optional. Optional Error catcher id of the error catch
      flow which will be executed when execution error happens in the task
    externalTaskType: Optional. External task type of the task
    nextTasks: Optional. The set of tasks that are next in line to be executed
      as per the execution graph defined for the parent event, specified by
      `event_config_id`. Each of these next tasks are executed only if the
      condition associated with them evaluates to true.
    parameters: Optional. The customized parameters the user can pass to this
      task.
    task: Optional. The name for the task.
    taskId: Required. The identifier of this task within its parent event
      config, specified by the client. This should be unique among all the
      tasks belong to the same event config. We use this field as the
      identifier to find next tasks (via field `next_tasks.task_id`).
  """

  class ExternalTaskTypeValueValuesEnum(_messages.Enum):
    r"""Optional. External task type of the task

    Values:
      EXTERNAL_TASK_TYPE_UNSPECIFIED: Default value. External task type is not
        specified
      NORMAL_TASK: Tasks belongs to the normal task flows
      ERROR_TASK: Task belongs to the error catch task flows
    """
    EXTERNAL_TASK_TYPE_UNSPECIFIED = 0
    NORMAL_TASK = 1
    ERROR_TASK = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ParametersValue(_messages.Message):
    r"""Optional. The customized parameters the user can pass to this task.

    Messages:
      AdditionalProperty: An additional property for a ParametersValue object.

    Fields:
      additionalProperties: Additional properties of type ParametersValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ParametersValue object.

      Fields:
        key: Name of the additional property.
        value: A EventParameter attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('EventParameter', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  description = _messages.StringField(1)
  displayName = _messages.StringField(2)
  errorCatcherId = _messages.StringField(3)
  externalTaskType = _messages.EnumField('ExternalTaskTypeValueValuesEnum', 4)
  nextTasks = _messages.MessageField('NextTask', 5, repeated=True)
  parameters = _messages.MessageField('ParametersValue', 6)
  task = _messages.StringField(7)
  taskId = _messages.StringField(8)


class TaskExecution(_messages.Message):
  r"""Execution of a single task within an integration

  Messages:
    VariablesValue: Optional. Variables used during the execution.

  Fields:
    name: Identifier. Task execution resource name.
    taskExecutionDetails: Details of the task execution.
    taskExecutionMetadata: Optional. Metadata of the task execution.
    variables: Optional. Variables used during the execution.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class VariablesValue(_messages.Message):
    r"""Optional. Variables used during the execution.

    Messages:
      AdditionalProperty: An additional property for a VariablesValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a VariablesValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  name = _messages.StringField(1)
  taskExecutionDetails = _messages.MessageField('TaskExecutionDetails', 2, repeated=True)
  taskExecutionMetadata = _messages.MessageField('TaskExecutionMetadata', 3)
  variables = _messages.MessageField('VariablesValue', 4)


class TaskExecutionDetails(_messages.Message):
  r"""Details of the task execution.

  Enums:
    TaskExecutionStateValueValuesEnum: Output only. The execution state of
      this task.

  Fields:
    taskAttemptStats: List for the current task execution attempts.
    taskExecutionState: Output only. The execution state of this task.
    taskNumber: Pointer to the task config it used for execution.
  """

  class TaskExecutionStateValueValuesEnum(_messages.Enum):
    r"""Output only. The execution state of this task.

    Values:
      STATE_UNSPECIFIED: Default value.
      IN_PROCESS: Task is under processing.
      SUCCEED: Task execution successfully finished. There are no more changes
        after this state.
      FAILED: Task execution failed. There's no more change after this state.
      FATAL: Task execution failed and cause the whole integration execution
        to fail immediately. There's no more change after this state.
      RETRY_ON_HOLD: Task execution failed and is waiting for retry.
      CANCELLED: Task execution cancelled when in progress. This happens when
        integration execution was cancelled or any other task fell into a
        fatal state.
      SUSPENDED: Task is a SuspensionTask which has executed once, creating a
        pending suspension.
    """
    STATE_UNSPECIFIED = 0
    IN_PROCESS = 1
    SUCCEED = 2
    FAILED = 3
    FATAL = 4
    RETRY_ON_HOLD = 5
    CANCELLED = 6
    SUSPENDED = 7

  taskAttemptStats = _messages.MessageField('AttemptStats', 1, repeated=True)
  taskExecutionState = _messages.EnumField('TaskExecutionStateValueValuesEnum', 2)
  taskNumber = _messages.StringField(3)


class TaskExecutionMetadata(_messages.Message):
  r"""Metadata of the task execution.

  Fields:
    ancestorIterationNumbers: Optional. Ancestor iteration number for the task
      (it will only be non-empty if the task is under 'private integration').
    ancestorTaskNumbers: Optional. Ancestor task number for the task (it will
      only be non-empty if the task is under 'private integration').
    executionAttempt: The execution attempt number this execution belongs to.
    privateIntegrationName: Optional. The direct integration which the
      execution belongs to.
    task: The task name associated with this execution.
    taskAttempt: The task attempt number this execution belongs to.
    taskLabel: The task label associated with this execution.
    taskNumber: The task number associated with this execution.
  """

  ancestorIterationNumbers = _messages.StringField(1, repeated=True)
  ancestorTaskNumbers = _messages.StringField(2, repeated=True)
  executionAttempt = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  privateIntegrationName = _messages.StringField(4)
  task = _messages.StringField(5)
  taskAttempt = _messages.IntegerField(6, variant=_messages.Variant.INT32)
  taskLabel = _messages.StringField(7)
  taskNumber = _messages.StringField(8)


class TaskResponseStatus(_messages.Message):
  r"""Message for task response status.

  Enums:
    TaskTypeValueValuesEnum: The task type.

  Fields:
    errorMessage: The error message of the task response in case of failure.
    httpCode: The http code of the task response.
    taskType: The task type.
  """

  class TaskTypeValueValuesEnum(_messages.Enum):
    r"""The task type.

    Values:
      TASK_TYPE_UNSPECIFIED: Unspecified.
      CONNECTOR_TASK: Connector Task.
      REST_TASK: Rest task.
    """
    TASK_TYPE_UNSPECIFIED = 0
    CONNECTOR_TASK = 1
    REST_TASK = 2

  errorMessage = _messages.StringField(1)
  httpCode = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  taskType = _messages.EnumField('TaskTypeValueValuesEnum', 3)


class TestIamPermissionsRequest(_messages.Message):
  r"""Request message for `TestIamPermissions` method.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as `*` or `storage.*`) are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class TestIamPermissionsResponse(_messages.Message):
  r"""Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


class ThirdPartyConnection(_messages.Message):
  r"""Message for a Connection.

  Enums:
    TypeValueValuesEnum: Required. The type of the 3p resource.

  Fields:
    authConfig: Required. The authentication configuration for the resource.
    connection: Required. The DeveloperConnect connection full resource name,
      relative resource name or resource URL to be indexed.
    sourceConfig: Required. The source configuration for the resource.
    type: Required. The type of the 3p resource.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Required. The type of the 3p resource.

    Values:
      TYPE_UNSPECIFIED: Unspecified resource type.
      CONFLUENCE: Confluence resource type.
    """
    TYPE_UNSPECIFIED = 0
    CONFLUENCE = 1

  authConfig = _messages.MessageField('ResourceAuthConfig', 1)
  connection = _messages.StringField(2)
  sourceConfig = _messages.MessageField('SourceConfig', 3)
  type = _messages.EnumField('TypeValueValuesEnum', 4)


class ToolSetting(_messages.Message):
  r"""Represents a single enabled tool.

  Fields:
    accountConnector: Optional. Link to the Dev Connect Account Connector that
      holds the user credentials. projects/{project}/locations/{location}/acco
      untConnectors/{account_connector_id}
    config: Optional. Configuration parameters for the tool.
    handle: Required. Handle used to invoke the tool.
    tool: Required. Link to the Tool
    uriOverride: Optional. Overridden URI, if allowed by Tool.
  """

  accountConnector = _messages.StringField(1)
  config = _messages.MessageField('ConfigItem', 2, repeated=True)
  handle = _messages.StringField(3)
  tool = _messages.StringField(4)
  uriOverride = _messages.StringField(5)


class TriggerConfig(_messages.Message):
  r"""Configuration detail of a trigger.

  Enums:
    TriggerTypeValueValuesEnum: Optional. Type of trigger

  Messages:
    PropertiesValue: Optional. Configurable properties of the trigger, not to
      be confused with integration parameters. E.g. "name" is a property for
      API triggers and "subscription" is a property for Pub/sub triggers.

  Fields:
    cloudSchedulerConfig: Optional. Cloud Scheduler Trigger related metadata
    description: Optional. User-provided description intended to give
      additional business context about the task.
    errorCatcherId: Optional. Optional Error catcher id of the error catch
      flow which will be executed when execution error happens in the task
    inputVariables: Optional. List of input variables for the api trigger.
    label: Optional. The user created label for a particular trigger.
    outputVariables: Optional. List of output variables for the api trigger.
    properties: Optional. Configurable properties of the trigger, not to be
      confused with integration parameters. E.g. "name" is a property for API
      triggers and "subscription" is a property for Pub/sub triggers.
    startTasks: Optional. Set of tasks numbers from where the integration
      execution is started by this trigger. If this is empty, then integration
      is executed with default start tasks. In the list of start tasks, none
      of two tasks can have direct ancestor-descendant relationships (i.e. in
      a same integration execution graph).
    trigger: Optional. Name of the trigger. Example: "API Trigger", "Cloud Pub
      Sub Trigger" When set will be sent out to monitoring dashabord for
      tracking purpose.
    triggerId: Optional. The backend trigger ID.
    triggerNumber: Required. A number to uniquely identify each trigger config
      within the integration on UI.
    triggerType: Optional. Type of trigger
  """

  class TriggerTypeValueValuesEnum(_messages.Enum):
    r"""Optional. Type of trigger

    Values:
      TRIGGER_TYPE_UNSPECIFIED: Unknown.
      CRON: Trigger by scheduled time.
      API: Trigger by API call.
      SFDC_CHANNEL: Trigger by Salesforce Channel.
      CLOUD_PUBSUB_EXTERNAL: Trigger by Pub/Sub external.
      SFDC_CDC_CHANNEL: SFDC Channel Trigger for CDC.
      CLOUD_SCHEDULER: Trigger by Cloud Scheduler job.
      INTEGRATION_CONNECTOR_TRIGGER: Trigger by Connector Event
      PRIVATE_TRIGGER: Trigger for private workflow
    """
    TRIGGER_TYPE_UNSPECIFIED = 0
    CRON = 1
    API = 2
    SFDC_CHANNEL = 3
    CLOUD_PUBSUB_EXTERNAL = 4
    SFDC_CDC_CHANNEL = 5
    CLOUD_SCHEDULER = 6
    INTEGRATION_CONNECTOR_TRIGGER = 7
    PRIVATE_TRIGGER = 8

  @encoding.MapUnrecognizedFields('additionalProperties')
  class PropertiesValue(_messages.Message):
    r"""Optional. Configurable properties of the trigger, not to be confused
    with integration parameters. E.g. "name" is a property for API triggers
    and "subscription" is a property for Pub/sub triggers.

    Messages:
      AdditionalProperty: An additional property for a PropertiesValue object.

    Fields:
      additionalProperties: Additional properties of type PropertiesValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a PropertiesValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  cloudSchedulerConfig = _messages.MessageField('CloudSchedulerConfig', 1)
  description = _messages.StringField(2)
  errorCatcherId = _messages.StringField(3)
  inputVariables = _messages.MessageField('Variables', 4)
  label = _messages.StringField(5)
  outputVariables = _messages.MessageField('Variables', 6)
  properties = _messages.MessageField('PropertiesValue', 7)
  startTasks = _messages.MessageField('NextTask', 8, repeated=True)
  trigger = _messages.StringField(9)
  triggerId = _messages.StringField(10)
  triggerNumber = _messages.StringField(11)
  triggerType = _messages.EnumField('TriggerTypeValueValuesEnum', 12)


class TroubleshootExecutionResponse(_messages.Message):
  r"""Response for troubleshooting an integration execution.

  Fields:
    detailedExplanation: Detailed explanation of the root cause of the
      integration execution failure.
    displayMessage: Display message to be shown to the user. Example - If
      integration execution succeeded, this field value can be "Integration
      execution succeeded. No troubleshooting needed.".
    errorMessage: Error message of the integration execution, if the execution
      failed.
    executionId: The execution id of the integration execution to be
      troubleshooted.
    rootCause: Root cause of the integration execution failure.
  """

  detailedExplanation = _messages.StringField(1)
  displayMessage = _messages.StringField(2)
  errorMessage = _messages.StringField(3)
  executionId = _messages.StringField(4)
  rootCause = _messages.StringField(5)


class TroubleshootPromptInput(_messages.Message):
  r"""The input, used for constructing the prompt, required for
  troubleshooting an integration execution.

  Fields:
    authConfig: The auth configs used in the integration version.
    execution: The integration execution logs.
    integrationVersion: The integration version configs, used at the time of
      integration execution.
  """

  authConfig = _messages.MessageField('AuthConfig', 1)
  execution = _messages.MessageField('Execution', 2)
  integrationVersion = _messages.MessageField('IntegrationVersion', 3)


class ValueType(_messages.Message):
  r"""The type of the parameter.

  Fields:
    booleanArray: Boolean Array.
    booleanValue: Boolean.
    doubleArray: Double Number Array.
    doubleValue: Double Number.
    intArray: Integer Array.
    intValue: Integer.
    jsonValue: Json.
    stringArray: String Array.
    stringValue: String.
  """

  booleanArray = _messages.MessageField('BooleanParameterArray', 1)
  booleanValue = _messages.BooleanField(2)
  doubleArray = _messages.MessageField('DoubleParameterArray', 3)
  doubleValue = _messages.FloatField(4)
  intArray = _messages.MessageField('IntParameterArray', 5)
  intValue = _messages.IntegerField(6)
  jsonValue = _messages.StringField(7)
  stringArray = _messages.MessageField('StringParameterArray', 8)
  stringValue = _messages.StringField(9)


class Variables(_messages.Message):
  r"""Variables names mapped to api trigger.

  Fields:
    names: Optional. List of variable names.
  """

  names = _messages.StringField(1, repeated=True)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
encoding.AddCustomJsonFieldMapping(
    CloudaicompanionProjectsLocationsCodeRepositoryIndexesRepositoryGroupsGetIamPolicyRequest, 'options_requestedPolicyVersion', 'options.requestedPolicyVersion')
