/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.ArrayList;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.ScriptOrFnNode;
import org.mozilla.javascript.ScriptRuntime;

final class IRFactory {
    private Parser parser;
    private static final int LOOP_DO_WHILE = 0;
    private static final int LOOP_WHILE = 1;
    private static final int LOOP_FOR = 2;
    private static final int ALWAYS_TRUE_BOOLEAN = 1;
    private static final int ALWAYS_FALSE_BOOLEAN = -1;

    IRFactory(Parser parser) {
        this.parser = parser;
    }

    ScriptOrFnNode createScript() {
        return new ScriptOrFnNode(135);
    }

    void initScript(ScriptOrFnNode scriptOrFnNode, Node node) {
        Node node2 = node.getFirstChild();
        if (node2 != null) {
            scriptOrFnNode.addChildrenToBack(node2);
        }
    }

    Node createLeaf(int n) {
        return new Node(n);
    }

    Node createSwitch(Node node, int n) {
        Node.Jump jump = new Node.Jump(113, node, n);
        Node node2 = new Node(128, jump);
        return node2;
    }

    void addSwitchCase(Node node, Node node2, Node node3) {
        if (node.getType() != 128) {
            throw Kit.codeBug();
        }
        Node.Jump jump = (Node.Jump)node.getFirstChild();
        if (jump.getType() != 113) {
            throw Kit.codeBug();
        }
        Node node4 = Node.newTarget();
        if (node2 != null) {
            Node.Jump jump2 = new Node.Jump(114, node2);
            jump2.target = node4;
            jump.addChildToBack(jump2);
        } else {
            jump.setDefault(node4);
        }
        node.addChildToBack(node4);
        node.addChildToBack(node3);
    }

    void closeSwitch(Node node) {
        Node node2;
        if (node.getType() != 128) {
            throw Kit.codeBug();
        }
        Node.Jump jump = (Node.Jump)node.getFirstChild();
        if (jump.getType() != 113) {
            throw Kit.codeBug();
        }
        jump.target = node2 = Node.newTarget();
        Node node3 = jump.getDefault();
        if (node3 == null) {
            node3 = node2;
        }
        node.addChildAfter(this.makeJump(5, node3), jump);
        node.addChildToBack(node2);
    }

    Node createVariables(int n, int n2) {
        return new Node(n, n2);
    }

    Node createExprStatement(Node node, int n) {
        int n2 = this.parser.insideFunction() ? 132 : 133;
        return new Node(n2, node, n);
    }

    Node createExprStatementNoReturn(Node node, int n) {
        return new Node(132, node, n);
    }

    Node createDefaultNamespace(Node node, int n) {
        this.setRequiresActivation();
        Node node2 = this.createUnary(73, node);
        Node node3 = this.createExprStatement(node2, n);
        return node3;
    }

    Node createName(String string) {
        this.checkActivationName(string, 39);
        return Node.newString(39, string);
    }

    private Node createName(int n, String string, Node node) {
        Node node2 = this.createName(string);
        node2.setType(n);
        if (node != null) {
            node2.addChildToBack(node);
        }
        return node2;
    }

    Node createString(String string) {
        return Node.newString(string);
    }

    Node createNumber(double d) {
        return Node.newNumber(d);
    }

    Node createCatch(String string, Node node, Node node2, int n) {
        if (node == null) {
            node = new Node(127);
        }
        return new Node(123, this.createName(string), node, node2, n);
    }

    Node createThrow(Node node, int n) {
        return new Node(50, node, n);
    }

    Node createReturn(Node node, int n) {
        return node == null ? new Node(4, n) : new Node(4, node, n);
    }

    Node createDebugger(int n) {
        return new Node(159, n);
    }

    Node createLabel(int n) {
        return new Node.Jump(129, n);
    }

    Node getLabelLoop(Node node) {
        return ((Node.Jump)node).getLoop();
    }

    Node createLabeledStatement(Node node, Node node2) {
        Node.Jump jump = (Node.Jump)node;
        Node node3 = Node.newTarget();
        Node node4 = new Node(128, (Node)jump, node2, node3);
        jump.target = node3;
        return node4;
    }

    Node createBreak(Node node, int n) {
        Node.Jump jump;
        Node.Jump jump2 = new Node.Jump(119, n);
        int n2 = node.getType();
        if (n2 == 131 || n2 == 129) {
            jump = (Node.Jump)node;
        } else if (n2 == 128 && node.getFirstChild().getType() == 113) {
            jump = (Node.Jump)node.getFirstChild();
        } else {
            throw Kit.codeBug();
        }
        jump2.setJumpStatement(jump);
        return jump2;
    }

    Node createContinue(Node node, int n) {
        if (node.getType() != 131) {
            Kit.codeBug();
        }
        Node.Jump jump = new Node.Jump(120, n);
        jump.setJumpStatement((Node.Jump)node);
        return jump;
    }

    Node createBlock(int n) {
        return new Node(128, n);
    }

    FunctionNode createFunction(String string) {
        return new FunctionNode(string);
    }

    Node initFunction(FunctionNode functionNode, int n, Node node, int n2) {
        Node node2;
        Object object;
        functionNode.itsFunctionType = n2;
        functionNode.addChildToBack(node);
        int n3 = functionNode.getFunctionCount();
        if (n3 != 0) {
            functionNode.itsNeedsActivation = true;
        }
        if (n2 == 2 && (object = functionNode.getFunctionName()) != null && ((String)object).length() != 0) {
            node2 = new Node(132, new Node(8, Node.newString(49, (String)object), new Node(63)));
            node.addChildrenToFront(node2);
        }
        if ((object = node.getLastChild()) == null || ((Node)object).getType() != 4) {
            node.addChildToBack(new Node(4));
        }
        node2 = Node.newString(108, functionNode.getFunctionName());
        node2.putIntProp(1, n);
        return node2;
    }

    void addChildToBack(Node node, Node node2) {
        node.addChildToBack(node2);
    }

    Node createScopeNode(int n, int n2) {
        return new Node.Scope(n, n2);
    }

    Node createLoopNode(Node node, int n) {
        Node.Scope scope = new Node.Scope(131, n);
        if (node != null) {
            ((Node.Jump)node).setLoop(scope);
        }
        return scope;
    }

    Node createWhile(Node node, Node node2, Node node3) {
        return this.createLoop((Node.Jump)node, 1, node3, node2, null, null);
    }

    Node createDoWhile(Node node, Node node2, Node node3) {
        return this.createLoop((Node.Jump)node, 0, node2, node3, null, null);
    }

    Node createFor(Node node, Node node2, Node node3, Node node4, Node node5) {
        if (node2.getType() == 152) {
            Node.Scope scope = Node.Scope.splitScope((Node.Scope)node);
            scope.setType(152);
            scope.addChildrenToBack(node2);
            scope.addChildToBack(this.createLoop((Node.Jump)node, 2, node5, node3, new Node(127), node4));
            return scope;
        }
        return this.createLoop((Node.Jump)node, 2, node5, node3, node2, node4);
    }

    private Node createLoop(Node.Jump jump, int n, Node node, Node node2, Node node3, Node node4) {
        Node node5 = Node.newTarget();
        Node node6 = Node.newTarget();
        if (n == 2 && node2.getType() == 127) {
            node2 = new Node(45);
        }
        Node.Jump jump2 = new Node.Jump(6, node2);
        jump2.target = node5;
        Node node7 = Node.newTarget();
        jump.addChildToBack(node5);
        jump.addChildrenToBack(node);
        if (n == 1 || n == 2) {
            jump.addChildrenToBack(new Node(127, jump.getLineno()));
        }
        jump.addChildToBack(node6);
        jump.addChildToBack(jump2);
        jump.addChildToBack(node7);
        jump.target = node7;
        Node node8 = node6;
        if (n == 1 || n == 2) {
            jump.addChildToFront(this.makeJump(5, node6));
            if (n == 2) {
                int n2 = node3.getType();
                if (n2 != 127) {
                    if (n2 != 121 && n2 != 152) {
                        node3 = new Node(132, node3);
                    }
                    jump.addChildToFront(node3);
                }
                Node node9 = Node.newTarget();
                jump.addChildAfter(node9, node);
                if (node4.getType() != 127) {
                    node4 = new Node(132, node4);
                    jump.addChildAfter(node4, node9);
                }
                node8 = node9;
            }
        }
        jump.setContinue(node8);
        return jump;
    }

    /*
     * Enabled aggressive block sorting
     */
    Node createForIn(int n, Node node, Node node2, Node node3, Node node4, boolean bl) {
        Node node5;
        Node node6;
        Node node7;
        int n2 = -1;
        int n3 = 0;
        int n4 = node2.getType();
        if (n4 == 121 || n4 == 152) {
            node7 = node2.getLastChild();
            if (node2.getFirstChild() != node7) {
                this.parser.reportError("msg.mult.index");
            }
            if (node7.getType() == 65 || node7.getType() == 66) {
                n4 = n2 = node7.getType();
                node6 = node7;
                n3 = node7.getIntProp(21, 0);
            } else {
                if (node7.getType() != 39) {
                    this.parser.reportError("msg.bad.for.in.lhs");
                    return node3;
                }
                node6 = Node.newString(39, node7.getString());
            }
        } else if (n4 == 65 || n4 == 66) {
            n2 = n4;
            node6 = node2;
            n3 = node2.getIntProp(21, 0);
        } else {
            node6 = this.makeReference(node2);
            if (node6 == null) {
                this.parser.reportError("msg.bad.for.in.lhs");
                return node3;
            }
        }
        node7 = new Node(140);
        int n5 = bl ? 59 : (n2 != -1 ? 60 : 58);
        Node node8 = new Node(n5, node3);
        node8.putProp(3, node7);
        Node node9 = new Node(61);
        node9.putProp(3, node7);
        Node node10 = new Node(62);
        node10.putProp(3, node7);
        Node node11 = new Node(128);
        if (n2 != -1) {
            node5 = this.createDestructuringAssignment(n, node6, node10);
            if (!(bl || n2 != 66 && n3 == 2)) {
                this.parser.reportError("msg.bad.for.in.destruct");
            }
        } else {
            node5 = this.simpleAssignment(node6, node10);
        }
        node11.addChildToBack(new Node(132, node5));
        node11.addChildToBack(node4);
        node = this.createWhile(node, node9, node11);
        node.addChildToFront(node8);
        if (n4 == 121 || n4 == 152) {
            node.addChildToFront(node2);
        }
        node7.addChildToBack(node);
        return node7;
    }

    Node createTryCatchFinally(Node node, Node node2, Node node3, int n) {
        Node node4;
        Node node5;
        Node node6;
        boolean bl;
        boolean bl2 = bl = node3 != null && (node3.getType() != 128 || node3.hasChildren());
        if (node.getType() == 128 && !node.hasChildren() && !bl) {
            return node;
        }
        boolean bl3 = node2.hasChildren();
        if (!bl && !bl3) {
            return node;
        }
        Node node7 = new Node(140);
        Node.Jump jump = new Node.Jump(80, node, n);
        jump.putProp(3, node7);
        if (bl3) {
            node6 = Node.newTarget();
            jump.addChildToBack(this.makeJump(5, node6));
            jump.target = node5 = Node.newTarget();
            jump.addChildToBack(node5);
            node4 = new Node(140);
            Node node8 = node2.getFirstChild();
            boolean bl4 = false;
            int n2 = 0;
            while (node8 != null) {
                Node node9;
                int n3 = node8.getLineno();
                Node node10 = node8.getFirstChild();
                Node node11 = node10.getNext();
                Node node12 = node11.getNext();
                node8.removeChild(node10);
                node8.removeChild(node11);
                node8.removeChild(node12);
                node12.addChildToBack(new Node(3));
                node12.addChildToBack(this.makeJump(5, node6));
                if (node11.getType() == 127) {
                    node9 = node12;
                    bl4 = true;
                } else {
                    node9 = this.createIf(node11, node12, null, n3);
                }
                Node node13 = new Node(57, node10, this.createUseLocal(node7));
                node13.putProp(3, node4);
                node13.putIntProp(14, n2);
                node4.addChildToBack(node13);
                node4.addChildToBack(this.createWith(this.createUseLocal(node4), node9, n3));
                node8 = node8.getNext();
                ++n2;
            }
            jump.addChildToBack(node4);
            if (!bl4) {
                Node node14 = new Node(51);
                node14.putProp(3, node7);
                jump.addChildToBack(node14);
            }
            jump.addChildToBack(node6);
        }
        if (bl) {
            node6 = Node.newTarget();
            jump.setFinally(node6);
            jump.addChildToBack(this.makeJump(134, node6));
            node5 = Node.newTarget();
            jump.addChildToBack(this.makeJump(5, node5));
            jump.addChildToBack(node6);
            node4 = new Node(124, node3);
            node4.putProp(3, node7);
            jump.addChildToBack(node4);
            jump.addChildToBack(node5);
        }
        node7.addChildToBack(jump);
        return node7;
    }

    Node createWith(Node node, Node node2, int n) {
        this.setRequiresActivation();
        Node node3 = new Node(128, n);
        node3.addChildToBack(new Node(2, node));
        Node node4 = new Node(122, node2, n);
        node3.addChildrenToBack(node4);
        node3.addChildToBack(new Node(3));
        return node3;
    }

    public Node createDotQuery(Node node, Node node2, int n) {
        this.setRequiresActivation();
        Node node3 = new Node(145, node, node2, n);
        return node3;
    }

    Node createArrayLiteral(ObjArray objArray, int n, int n2) {
        int n3 = objArray.size();
        int[] nArray = null;
        if (n != 0) {
            nArray = new int[n];
        }
        Node node = new Node(65);
        int n4 = 0;
        int n5 = 0;
        while (n4 != n3) {
            Node node2 = (Node)objArray.get(n4);
            if (node2 != null) {
                node.addChildToBack(node2);
            } else {
                nArray[n5] = n4;
                ++n5;
            }
            ++n4;
        }
        if (n != 0) {
            node.putProp(11, nArray);
        }
        node.putIntProp(21, n2);
        return node;
    }

    Node createObjectLiteral(ObjArray objArray) {
        Object[] objectArray;
        int n = objArray.size() / 2;
        Node node = new Node(66);
        if (n == 0) {
            objectArray = ScriptRuntime.emptyArgs;
        } else {
            objectArray = new Object[n];
            int n2 = 0;
            while (n2 != n) {
                objectArray[n2] = objArray.get(2 * n2);
                Node node2 = (Node)objArray.get(2 * n2 + 1);
                node.addChildToBack(node2);
                ++n2;
            }
        }
        node.putProp(12, objectArray);
        return node;
    }

    Node createRegExp(int n) {
        Node node = new Node(48);
        node.putIntProp(4, n);
        return node;
    }

    Node createIf(Node node, Node node2, Node node3, int n) {
        int n2 = IRFactory.isAlwaysDefinedBoolean(node);
        if (n2 == 1) {
            return node2;
        }
        if (n2 == -1) {
            if (node3 != null) {
                return node3;
            }
            return new Node(128, n);
        }
        Node node4 = new Node(128, n);
        Node node5 = Node.newTarget();
        Node.Jump jump = new Node.Jump(7, node);
        jump.target = node5;
        node4.addChildToBack(jump);
        node4.addChildrenToBack(node2);
        if (node3 != null) {
            Node node6 = Node.newTarget();
            node4.addChildToBack(this.makeJump(5, node6));
            node4.addChildToBack(node5);
            node4.addChildrenToBack(node3);
            node4.addChildToBack(node6);
        } else {
            node4.addChildToBack(node5);
        }
        return node4;
    }

    Node createCondExpr(Node node, Node node2, Node node3) {
        int n = IRFactory.isAlwaysDefinedBoolean(node);
        if (n == 1) {
            return node2;
        }
        if (n == -1) {
            return node3;
        }
        return new Node(101, node, node2, node3);
    }

    Node createUnary(int n, Node node) {
        int n2 = node.getType();
        switch (n) {
            case 31: {
                Node node2;
                if (n2 == 39) {
                    node.setType(49);
                    Node node3 = node;
                    Node node4 = Node.newString(node.getString());
                    node2 = new Node(n, node3, node4);
                } else if (n2 == 33 || n2 == 36) {
                    Node node5 = node.getFirstChild();
                    Node node6 = node.getLastChild();
                    node.removeChild(node5);
                    node.removeChild(node6);
                    node2 = new Node(n, node5, node6);
                } else if (n2 == 67) {
                    Node node7 = node.getFirstChild();
                    node.removeChild(node7);
                    node2 = new Node(69, node7);
                } else {
                    node2 = new Node(45);
                }
                return node2;
            }
            case 32: {
                if (n2 != 39) break;
                node.setType(136);
                return node;
            }
            case 27: {
                if (n2 != 40) break;
                int n3 = ScriptRuntime.toInt32(node.getDouble());
                node.setDouble(~n3);
                return node;
            }
            case 29: {
                if (n2 != 40) break;
                node.setDouble(-node.getDouble());
                return node;
            }
            case 26: {
                int n4 = IRFactory.isAlwaysDefinedBoolean(node);
                if (n4 == 0) break;
                int n5 = n4 == 1 ? 44 : 45;
                if (n2 == 45 || n2 == 44) {
                    node.setType(n5);
                    return node;
                }
                return new Node(n5);
            }
        }
        return new Node(n, node);
    }

    Node createYield(Node node, int n) {
        if (!this.parser.insideFunction()) {
            this.parser.reportError("msg.bad.yield");
        }
        this.setRequiresActivation();
        this.setIsGenerator();
        if (node != null) {
            return new Node(72, node, n);
        }
        return new Node(72, n);
    }

    Node createCallOrNew(int n, Node node) {
        Object object;
        int n2 = 0;
        if (node.getType() == 39) {
            object = node.getString();
            if (((String)object).equals("eval")) {
                n2 = 1;
            } else if (((String)object).equals("With")) {
                n2 = 2;
            }
        } else if (node.getType() == 33 && ((String)(object = node.getLastChild().getString())).equals("eval")) {
            n2 = 1;
        }
        object = new Node(n, node);
        if (n2 != 0) {
            this.setRequiresActivation();
            ((Node)object).putIntProp(10, n2);
        }
        return object;
    }

    Node createIncDec(int n, boolean bl, Node node) {
        if ((node = this.makeReference(node)) == null) {
            String string = n == 106 ? "msg.bad.decr" : "msg.bad.incr";
            this.parser.reportError(string);
            return null;
        }
        int n2 = node.getType();
        switch (n2) {
            case 33: 
            case 36: 
            case 39: 
            case 67: {
                Node node2 = new Node(n, node);
                int n3 = 0;
                if (n == 106) {
                    n3 |= 1;
                }
                if (bl) {
                    n3 |= 2;
                }
                node2.putIntProp(13, n3);
                return node2;
            }
        }
        throw Kit.codeBug();
    }

    Node createPropertyGet(Node node, String string, String string2, int n) {
        if (string == null && n == 0) {
            if (node == null) {
                return this.createName(string2);
            }
            this.checkActivationName(string2, 33);
            if (ScriptRuntime.isSpecialProperty(string2)) {
                Node node2 = new Node(71, node);
                node2.putProp(17, string2);
                return new Node(67, node2);
            }
            return new Node(33, node, this.createString(string2));
        }
        Node node3 = this.createString(string2);
        return this.createMemberRefGet(node, string, node3, n |= 1);
    }

    Node createElementGet(Node node, String string, Node node2, int n) {
        if (string == null && n == 0) {
            if (node == null) {
                throw Kit.codeBug();
            }
            return new Node(36, node, node2);
        }
        return this.createMemberRefGet(node, string, node2, n);
    }

    private Node createMemberRefGet(Node node, String string, Node node2, int n) {
        Node node3 = null;
        if (string != null) {
            node3 = string.equals("*") ? new Node(42) : this.createName(string);
        }
        Node node4 = node == null ? (string == null ? new Node(78, node2) : new Node(79, node3, node2)) : (string == null ? new Node(76, node, node2) : new Node(77, node, node3, node2));
        if (n != 0) {
            node4.putIntProp(16, n);
        }
        return new Node(67, node4);
    }

    Node createBinary(int n, Node node, Node node2) {
        switch (n) {
            case 21: {
                if (node.type == 41) {
                    String string;
                    if (node2.type == 41) {
                        string = node2.getString();
                    } else {
                        if (node2.type != 40) break;
                        string = ScriptRuntime.numberToString(node2.getDouble(), 10);
                    }
                    String string2 = node.getString();
                    node.setString(string2.concat(string));
                    return node;
                }
                if (node.type != 40) break;
                if (node2.type == 40) {
                    node.setDouble(node.getDouble() + node2.getDouble());
                    return node;
                }
                if (node2.type != 41) break;
                String string = ScriptRuntime.numberToString(node.getDouble(), 10);
                String string3 = node2.getString();
                node2.setString(string.concat(string3));
                return node2;
            }
            case 22: {
                if (node.type == 40) {
                    double d = node.getDouble();
                    if (node2.type == 40) {
                        node.setDouble(d - node2.getDouble());
                        return node;
                    }
                    if (d != 0.0) break;
                    return new Node(29, node2);
                }
                if (node2.type != 40 || node2.getDouble() != 0.0) break;
                return new Node(28, node);
            }
            case 23: {
                if (node.type == 40) {
                    double d = node.getDouble();
                    if (node2.type == 40) {
                        node.setDouble(d * node2.getDouble());
                        return node;
                    }
                    if (d != 1.0) break;
                    return new Node(28, node2);
                }
                if (node2.type != 40 || node2.getDouble() != 1.0) break;
                return new Node(28, node);
            }
            case 24: {
                if (node2.type != 40) break;
                double d = node2.getDouble();
                if (node.type == 40) {
                    node.setDouble(node.getDouble() / d);
                    return node;
                }
                if (d != 1.0) break;
                return new Node(28, node);
            }
            case 104: {
                int n2 = IRFactory.isAlwaysDefinedBoolean(node);
                if (n2 == -1) {
                    return node;
                }
                if (n2 != 1) break;
                return node2;
            }
            case 103: {
                int n3 = IRFactory.isAlwaysDefinedBoolean(node);
                if (n3 == 1) {
                    return node;
                }
                if (n3 != -1) break;
                return node2;
            }
        }
        return new Node(n, node, node2);
    }

    private Node simpleAssignment(Node node, Node node2) {
        int n = node.getType();
        switch (n) {
            case 39: {
                node.setType(49);
                return new Node(8, node, node2);
            }
            case 33: 
            case 36: {
                Node node3 = node.getFirstChild();
                Node node4 = node.getLastChild();
                int n2 = n == 33 ? 35 : 37;
                return new Node(n2, node3, node4, node2);
            }
            case 67: {
                Node node5 = node.getFirstChild();
                this.checkMutableReference(node5);
                return new Node(68, node5, node2);
            }
        }
        throw Kit.codeBug();
    }

    private void checkMutableReference(Node node) {
        int n = node.getIntProp(16, 0);
        if ((n & 4) != 0) {
            this.parser.reportError("msg.bad.assign.left");
        }
    }

    Node createAssignment(int n, Node node, Node node2) {
        int n2;
        Node node3 = this.makeReference(node);
        if (node3 == null) {
            if (node.getType() == 65 || node.getType() == 66) {
                if (n != 89) {
                    this.parser.reportError("msg.bad.destruct.op");
                    return node2;
                }
                return this.createDestructuringAssignment(-1, node, node2);
            }
            this.parser.reportError("msg.bad.assign.left");
            return node2;
        }
        node = node3;
        switch (n) {
            case 89: {
                return this.simpleAssignment(node, node2);
            }
            case 90: {
                n2 = 9;
                break;
            }
            case 91: {
                n2 = 10;
                break;
            }
            case 92: {
                n2 = 11;
                break;
            }
            case 93: {
                n2 = 18;
                break;
            }
            case 94: {
                n2 = 19;
                break;
            }
            case 95: {
                n2 = 20;
                break;
            }
            case 96: {
                n2 = 21;
                break;
            }
            case 97: {
                n2 = 22;
                break;
            }
            case 98: {
                n2 = 23;
                break;
            }
            case 99: {
                n2 = 24;
                break;
            }
            case 100: {
                n2 = 25;
                break;
            }
            default: {
                throw Kit.codeBug();
            }
        }
        int n3 = node.getType();
        switch (n3) {
            case 39: {
                Node node4 = new Node(n2, node, node2);
                Node node5 = Node.newString(49, node.getString());
                return new Node(8, node5, node4);
            }
            case 33: 
            case 36: {
                Node node6 = node.getFirstChild();
                Node node7 = node.getLastChild();
                int n4 = n3 == 33 ? 138 : 139;
                Node node8 = new Node(137);
                Node node9 = new Node(n2, node8, node2);
                return new Node(n4, node6, node7, node9);
            }
            case 67: {
                node3 = node.getFirstChild();
                this.checkMutableReference(node3);
                Node node10 = new Node(137);
                Node node11 = new Node(n2, node10, node2);
                return new Node(141, node3, node11);
            }
        }
        throw Kit.codeBug();
    }

    Node createDestructuringAssignment(int n, Node node, Node node2) {
        String string = this.parser.currentScriptOrFn.getNextTempName();
        Node node3 = this.destructuringAssignmentHelper(n, node, node2, string);
        Node node4 = node3.getLastChild();
        node4.addChildToBack(this.createName(string));
        return node3;
    }

    private Node destructuringAssignmentHelper(int n, Node node, Node node2, String string) {
        Node node3 = this.createScopeNode(157, this.parser.getCurrentLineNumber());
        node3.addChildToFront(new Node(152, this.createName(39, string, node2)));
        try {
            this.parser.pushScope(node3);
            this.parser.defineSymbol(152, true, string);
        }
        finally {
            this.parser.popScope();
        }
        Node node4 = new Node(88);
        node3.addChildToBack(node4);
        int n2 = n == 153 ? 154 : 8;
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = true;
        int n3 = node.getType();
        if (n3 == 65) {
            int n4 = 0;
            int[] nArray = (int[])node.getProp(11);
            int n5 = 0;
            Node node5 = node.getFirstChild();
            while (true) {
                if (nArray != null) {
                    while (n5 < nArray.length && nArray[n5] == n4) {
                        ++n5;
                        ++n4;
                    }
                }
                if (node5 != null) {
                    Node node6 = new Node(36, this.createName(string), this.createNumber(n4));
                    if (node5.getType() == 39) {
                        String string2 = node5.getString();
                        node4.addChildToBack(new Node(n2, this.createName(49, string2, null), node6));
                        if (n != -1) {
                            this.parser.defineSymbol(n, true, string2);
                            arrayList.add(string2);
                        }
                    } else {
                        node4.addChildToBack(this.destructuringAssignmentHelper(n, node5, node6, this.parser.currentScriptOrFn.getNextTempName()));
                    }
                    ++n4;
                    bl = false;
                    node5 = node5.getNext();
                    continue;
                }
                break;
            }
        } else if (n3 == 66) {
            int n6 = 0;
            Object[] objectArray = (Object[])node.getProp(12);
            Node node7 = node.getFirstChild();
            while (node7 != null) {
                Node node8;
                Object object = objectArray[n6];
                Node node9 = node8 = object instanceof String ? new Node(33, this.createName(string), this.createString((String)object)) : new Node(36, this.createName(string), this.createNumber(((Number)object).intValue()));
                if (node7.getType() == 39) {
                    String string3 = node7.getString();
                    node4.addChildToBack(new Node(n2, this.createName(49, string3, null), node8));
                    if (n != -1) {
                        this.parser.defineSymbol(n, true, string3);
                        arrayList.add(string3);
                    }
                } else {
                    node4.addChildToBack(this.destructuringAssignmentHelper(n, node7, node8, this.parser.currentScriptOrFn.getNextTempName()));
                }
                ++n6;
                bl = false;
                node7 = node7.getNext();
            }
        } else if (n3 == 33 || n3 == 36) {
            node4.addChildToBack(this.simpleAssignment(node, this.createName(string)));
        } else {
            this.parser.reportError("msg.bad.assign.left");
        }
        if (bl) {
            node4.addChildToBack(this.createNumber(0.0));
        }
        node3.putProp(22, arrayList);
        return node3;
    }

    Node createUseLocal(Node node) {
        if (140 != node.getType()) {
            throw Kit.codeBug();
        }
        Node node2 = new Node(54);
        node2.putProp(3, node);
        return node2;
    }

    private Node.Jump makeJump(int n, Node node) {
        Node.Jump jump = new Node.Jump(n);
        jump.target = node;
        return jump;
    }

    private Node makeReference(Node node) {
        int n = node.getType();
        switch (n) {
            case 33: 
            case 36: 
            case 39: 
            case 67: {
                return node;
            }
            case 38: {
                node.setType(70);
                return new Node(67, node);
            }
        }
        return null;
    }

    private static int isAlwaysDefinedBoolean(Node node) {
        switch (node.getType()) {
            case 42: 
            case 44: {
                return -1;
            }
            case 45: {
                return 1;
            }
            case 40: {
                double d = node.getDouble();
                if (d == d && d != 0.0) {
                    return 1;
                }
                return -1;
            }
        }
        return 0;
    }

    private void checkActivationName(String string, int n) {
        if (this.parser.insideFunction()) {
            boolean bl = false;
            if ("arguments".equals(string) || this.parser.compilerEnv.activationNames != null && this.parser.compilerEnv.activationNames.contains(string)) {
                bl = true;
            } else if ("length".equals(string) && n == 33 && this.parser.compilerEnv.getLanguageVersion() == 120) {
                bl = true;
            }
            if (bl) {
                this.setRequiresActivation();
            }
        }
    }

    private void setRequiresActivation() {
        if (this.parser.insideFunction()) {
            ((FunctionNode)this.parser.currentScriptOrFn).itsNeedsActivation = true;
        }
    }

    private void setIsGenerator() {
        if (this.parser.insideFunction()) {
            ((FunctionNode)this.parser.currentScriptOrFn).itsIsGenerator = true;
        }
    }
}

