/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.device.protocol;

import jadx.core.utils.log.LogUtils;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ADBDeviceInfo {
    private static final Logger LOG = LoggerFactory.getLogger(ADBDeviceInfo.class);
    private final String adbHost;
    private final int adbPort;
    private final String serial;
    private final String state;
    private final String model;
    private final String allInfo;
    private final Map<String, String> propertiesMap = new TreeMap<String, String>();

    ADBDeviceInfo(String info, String host, int port) {
        CharSequence[] infoFields = info.trim().split("\\s+");
        this.allInfo = String.join((CharSequence)" ", infoFields);
        if (infoFields.length > 2) {
            this.serial = infoFields[0];
            this.state = infoFields[1];
            for (int i = 2; i < infoFields.length; ++i) {
                CharSequence field = infoFields[i];
                int idx = ((String)field).indexOf(58);
                if (idx <= 0) continue;
                String key = ((String)field).substring(0, idx);
                String value = ((String)field).substring(idx + 1);
                if (value.isEmpty()) continue;
                this.propertiesMap.put(key, value);
            }
            this.model = this.propertiesMap.getOrDefault("model", this.serial);
        } else {
            LOG.error("Unable to extract device information from {}", (Object)LogUtils.escape((String)info));
            this.serial = "";
            this.state = "unknown";
            this.model = "unknown";
        }
        this.adbHost = host;
        this.adbPort = port;
    }

    public boolean isOnline() {
        return this.state.equals("device");
    }

    public String getAdbHost() {
        return this.adbHost;
    }

    public int getAdbPort() {
        return this.adbPort;
    }

    public String getSerial() {
        return this.serial;
    }

    public String getState() {
        return this.state;
    }

    public String getModel() {
        return this.model;
    }

    public String getAllInfo() {
        return this.allInfo;
    }

    public String getProperty(String key) {
        return this.propertiesMap.get(key);
    }

    public String toString() {
        return this.allInfo;
    }
}

