/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.continuous;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.watch.registry.FileWatcherRegistry;
import org.gradle.internal.watch.vfs.FileChangeListener;
import org.gradle.tooling.internal.provider.continuous.BuildInputHierarchy;

public class FileEventCollector
implements FileChangeListener {
    public static final int SHOW_INDIVIDUAL_CHANGES_LIMIT = 3;
    private final Map<Path, FileWatcherRegistry.Type> aggregatedEvents = new LinkedHashMap<Path, FileWatcherRegistry.Type>();
    private final BuildInputHierarchy buildInputs;
    private final Runnable onRelevantChangeAction;
    private int moreChangesCount;
    private boolean errorWhenWatching;

    public FileEventCollector(BuildInputHierarchy buildInputs, Runnable onRelevantChangeAction) {
        this.buildInputs = buildInputs;
        this.onRelevantChangeAction = onRelevantChangeAction;
    }

    public void handleChange(FileWatcherRegistry.Type type, Path path) {
        String absolutePath = path.toString();
        if (this.buildInputs.isInput(absolutePath)) {
            this.onChangeToInputs(type, path);
            this.onRelevantChangeAction.run();
        }
    }

    public void stopWatchingAfterError() {
        this.errorWhenWatching = true;
        this.onRelevantChangeAction.run();
    }

    public void onChangeToInputs(FileWatcherRegistry.Type type, Path path) {
        FileWatcherRegistry.Type existingEvent = this.aggregatedEvents.get(path);
        if (existingEvent == type || existingEvent == FileWatcherRegistry.Type.CREATED && type == FileWatcherRegistry.Type.MODIFIED) {
            return;
        }
        if (existingEvent != null || this.aggregatedEvents.size() < 3) {
            this.aggregatedEvents.put(path, type);
        } else {
            ++this.moreChangesCount;
        }
    }

    public void reportChanges(StyledTextOutput logger) {
        for (Map.Entry<Path, FileWatcherRegistry.Type> entry : this.aggregatedEvents.entrySet()) {
            FileWatcherRegistry.Type type = entry.getValue();
            Path path = entry.getKey();
            this.showIndividualChange(logger, path, type);
        }
        if (this.moreChangesCount > 0) {
            this.logOutput(logger, "and some more changes", new Object[0]);
        }
        if (this.errorWhenWatching) {
            this.logOutput(logger, "Error when watching files - triggering a rebuild", new Object[0]);
        }
    }

    private void showIndividualChange(StyledTextOutput logger, Path path, FileWatcherRegistry.Type changeType) {
        String changeDescription;
        switch (changeType) {
            case CREATED: {
                changeDescription = "new " + (Files.isDirectory(path, new LinkOption[0]) ? "directory" : "file");
                break;
            }
            case REMOVED: {
                changeDescription = "deleted";
                break;
            }
            default: {
                changeDescription = "modified";
            }
        }
        this.logOutput(logger, "%s: %s", changeDescription, path.toString());
    }

    private void logOutput(StyledTextOutput logger, String message, Object ... objects) {
        logger.formatln(message, objects);
    }
}

