/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.gradle.api.Project;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.tasks.diagnostics.internal.ProjectDetails;
import org.gradle.api.tasks.diagnostics.internal.ReportRenderer;
import org.gradle.initialization.BuildClientMetaData;
import org.gradle.internal.logging.text.StyledTextOutputFactory;

public final class ReportGenerator {
    private final ReportRenderer renderer;
    private final BuildClientMetaData buildClientMetaData;
    private final File outputFile;
    private final StyledTextOutputFactory textOutputFactory;

    public ReportGenerator(ReportRenderer renderer, BuildClientMetaData buildClientMetaData, @Nullable File outputFile, StyledTextOutputFactory textOutputFactory) {
        this.renderer = renderer;
        this.buildClientMetaData = buildClientMetaData;
        this.outputFile = outputFile;
        this.textOutputFactory = textOutputFactory;
    }

    public void generateReport(Set<Project> projects, ReportAction<Project> projectReportGenerator) {
        this.generateReport(projects, ProjectDetails::of, projectReportGenerator);
    }

    public <T> void generateReport(Iterable<T> projects, Function<T, ProjectDetails> projectDetailsProvider, ReportAction<T> projectReportGenerator) {
        this.generateReport(projects, projectDetailsProvider, ReportMarginaliaAction.DO_NOTHING, projectReportGenerator, ReportMarginaliaAction.DO_NOTHING);
    }

    public <T> void generateReport(Iterable<T> projects, Function<T, ProjectDetails> projectDetailsProvider, ReportMarginaliaAction projectReportHeaderGenerator, ReportAction<T> projectReportGenerator, ReportMarginaliaAction projectReportFooterGenerator) {
        try {
            ReportRenderer renderer = this.getRenderer();
            renderer.setClientMetaData(this.getClientMetaData());
            File outputFile = this.getOutputFile();
            if (outputFile != null) {
                renderer.setOutputFile(outputFile);
            } else {
                renderer.setOutput(this.getTextOutputFactory().create(this.getClass()));
            }
            projectReportHeaderGenerator.execute();
            for (T project : projects) {
                ProjectDetails projectDetails = projectDetailsProvider.apply(project);
                renderer.startProject(projectDetails);
                projectReportGenerator.execute(project);
                renderer.completeProject(projectDetails);
            }
            projectReportFooterGenerator.execute();
            renderer.complete();
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    private ReportRenderer getRenderer() {
        return this.renderer;
    }

    private BuildClientMetaData getClientMetaData() {
        return this.buildClientMetaData;
    }

    @Nullable
    private File getOutputFile() {
        return this.outputFile;
    }

    private StyledTextOutputFactory getTextOutputFactory() {
        return this.textOutputFactory;
    }

    @FunctionalInterface
    public static interface ReportAction<T> {
        public void execute(T var1) throws IOException;
    }

    @FunctionalInterface
    public static interface ReportMarginaliaAction {
        public static final ReportMarginaliaAction DO_NOTHING = new ReportMarginaliaAction(){

            @Override
            public void execute() throws IOException {
            }
        };

        public void execute() throws IOException;
    }
}

