/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.constants;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.exceptions.UnknownCiphersuiteException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public enum CipherSuite {
    TLS_NULL_WITH_NULL_NULL(0),
    TLS_RSA_WITH_NULL_MD5(1),
    TLS_RSA_WITH_NULL_SHA(2),
    TLS_RSA_EXPORT_WITH_RC4_40_MD5(3),
    TLS_RSA_WITH_RC4_128_MD5(4),
    TLS_RSA_WITH_RC4_128_SHA(5),
    TLS_RSA_EXPORT_WITH_RC2_CBC_40_MD5(6),
    TLS_RSA_WITH_IDEA_CBC_SHA(7),
    TLS_RSA_EXPORT_WITH_DES40_CBC_SHA(8),
    TLS_RSA_WITH_DES_CBC_SHA(9),
    TLS_RSA_WITH_3DES_EDE_CBC_SHA(10),
    TLS_DH_DSS_EXPORT_WITH_DES40_CBC_SHA(11),
    TLS_DH_DSS_WITH_DES_CBC_SHA(12),
    TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA(13),
    TLS_DH_RSA_EXPORT_WITH_DES40_CBC_SHA(14),
    TLS_DH_RSA_WITH_DES_CBC_SHA(15),
    TLS_DH_RSA_WITH_3DES_EDE_CBC_SHA(16),
    TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA(17),
    TLS_DHE_DSS_WITH_DES_CBC_SHA(18),
    TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA(19),
    TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA(20),
    TLS_DHE_RSA_WITH_DES_CBC_SHA(21),
    TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA(22),
    TLS_DH_anon_EXPORT_WITH_RC4_40_MD5(23),
    TLS_DH_anon_WITH_RC4_128_MD5(24),
    TLS_DH_anon_EXPORT_WITH_DES40_CBC_SHA(25),
    TLS_DH_anon_WITH_DES_CBC_SHA(26),
    TLS_DH_anon_WITH_3DES_EDE_CBC_SHA(27),
    SSL_FORTEZZA_KEA_WITH_NULL_SHA(28),
    SSL_FORTEZZA_KEA_WITH_FORTEZZA_CBC_SHA(29),
    TLS_KRB5_WITH_DES_CBC_SHA(30),
    TLS_KRB5_WITH_3DES_EDE_CBC_SHA(31),
    TLS_KRB5_WITH_RC4_128_SHA(32),
    TLS_KRB5_WITH_IDEA_CBC_SHA(33),
    TLS_KRB5_WITH_DES_CBC_MD5(34),
    TLS_KRB5_WITH_3DES_EDE_CBC_MD5(35),
    TLS_KRB5_WITH_RC4_128_MD5(36),
    TLS_KRB5_WITH_IDEA_CBC_MD5(37),
    TLS_KRB5_EXPORT_WITH_DES_CBC_40_SHA(38),
    TLS_KRB5_EXPORT_WITH_RC2_CBC_40_SHA(39),
    TLS_KRB5_EXPORT_WITH_RC4_40_SHA(40),
    TLS_KRB5_EXPORT_WITH_DES_CBC_40_MD5(41),
    TLS_KRB5_EXPORT_WITH_RC2_CBC_40_MD5(42),
    TLS_KRB5_EXPORT_WITH_RC4_40_MD5(43),
    TLS_PSK_WITH_NULL_SHA(44),
    TLS_DHE_PSK_WITH_NULL_SHA(45),
    TLS_RSA_PSK_WITH_NULL_SHA(46),
    TLS_RSA_WITH_AES_128_CBC_SHA(47),
    TLS_DH_DSS_WITH_AES_128_CBC_SHA(48),
    TLS_DH_RSA_WITH_AES_128_CBC_SHA(49),
    TLS_DHE_DSS_WITH_AES_128_CBC_SHA(50),
    TLS_DHE_RSA_WITH_AES_128_CBC_SHA(51),
    TLS_DH_anon_WITH_AES_128_CBC_SHA(52),
    TLS_RSA_WITH_AES_256_CBC_SHA(53),
    TLS_DH_DSS_WITH_AES_256_CBC_SHA(54),
    TLS_DH_RSA_WITH_AES_256_CBC_SHA(55),
    TLS_DHE_DSS_WITH_AES_256_CBC_SHA(56),
    TLS_DHE_RSA_WITH_AES_256_CBC_SHA(57),
    TLS_DH_anon_WITH_AES_256_CBC_SHA(58),
    TLS_RSA_WITH_NULL_SHA256(59),
    TLS_RSA_WITH_AES_128_CBC_SHA256(60),
    TLS_RSA_WITH_AES_256_CBC_SHA256(61),
    TLS_DH_DSS_WITH_AES_128_CBC_SHA256(62),
    TLS_DH_RSA_WITH_AES_128_CBC_SHA256(63),
    TLS_DHE_DSS_WITH_AES_128_CBC_SHA256(64),
    TLS_RSA_WITH_CAMELLIA_128_CBC_SHA(65),
    TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA(66),
    TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA(67),
    TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA(68),
    TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA(69),
    TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA(70),
    UNOFFICIAL_TLS_ECDH_ECDSA_WITH_NULL_SHA(71),
    UNOFFICIAL_TLS_ECDH_ECDSA_WITH_RC4_128_SHA(72),
    UNOFFICIAL_TLS_ECDH_ECDSA_WITH_DES_CBC_SHA(73),
    UNOFFICIAL_TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA(74),
    UNOFFICIAL_TLS_ECDH_ECNRA_WITH_NULL_SHA(75),
    UNOFFICIAL_TLS_ECDH_ECNRA_WITH_RC4_128_SHA(76),
    UNOFFICIAL_TLS_ECDH_ECNRA_WITH_DES_CBC_SHA(77),
    UNOFFICIAL_TLS_ECDH_ECNRA_WITH_3DES_EDE_CBC_SHA(78),
    UNOFFICIAL_TLS_ECMQV_ECDSA_WITH_NULL_SHA(79),
    UNOFFICIAL_TLS_ECMQV_ECDSA_WITH_RC4_128_SHA(80),
    UNOFFICIAL_TLS_ECMQV_ECDSA_WITH_DES_CBC_SHA(81),
    UNOFFICIAL_TLS_ECMQV_ECDSA_WITH_3DES_EDE_CBC_SHA(82),
    UNOFFICIAL_TLS_ECMQV_ECNRA_WITH_NULL_SHA(83),
    UNOFFICIAL_TLS_ECMQV_ECNRA_WITH_RC4_128_SHA(84),
    UNOFFICIAL_TLS_ECMQV_ECNRA_WITH_DES_CBC_SHA(85),
    UNOFFICIAL_TLS_ECMQV_ECNRA_WITH_3DES_EDE_CBC_SHA(86),
    UNOFFICIAL_TLS_ECDH_anon_WITH_NULL_SHA(87),
    UNOFFICIAL_TLS_ECDH_anon_WITH_RC4_128_SHA(88),
    UNOFFICIAL_TLS_ECDH_anon_WITH_DES_CBC_SHA(89),
    UNOFFICIAL_TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA(90),
    UNOFFICIAL_TLS_ECDH_anon_EXPORT_WITH_DES40_CBC_SHA(91),
    UNOFFICIAL_TLS_ECDH_anon_EXPORT_WITH_RC4_40_SHA(92),
    TLS_RSA_EXPORT1024_WITH_RC4_56_MD5(96),
    TLS_RSA_EXPORT1024_WITH_RC2_56_MD5(97),
    TLS_RSA_EXPORT1024_WITH_DES_CBC_SHA(98),
    TLS_DHE_DSS_EXPORT1024_WITH_DES_CBC_SHA(99),
    TLS_RSA_EXPORT1024_WITH_RC4_56_SHA(100),
    TLS_DHE_DSS_EXPORT1024_WITH_RC4_56_SHA(101),
    TLS_DHE_DSS_WITH_RC4_128_SHA(102),
    TLS_DHE_RSA_WITH_AES_128_CBC_SHA256(103),
    TLS_DH_DSS_WITH_AES_256_CBC_SHA256(104),
    TLS_DH_RSA_WITH_AES_256_CBC_SHA256(105),
    TLS_DHE_DSS_WITH_AES_256_CBC_SHA256(106),
    TLS_DHE_RSA_WITH_AES_256_CBC_SHA256(107),
    TLS_DH_anon_WITH_AES_128_CBC_SHA256(108),
    TLS_DH_anon_WITH_AES_256_CBC_SHA256(109),
    TLS_GOSTR341094_WITH_28147_CNT_IMIT(128),
    TLS_GOSTR341001_WITH_28147_CNT_IMIT(129),
    TLS_GOSTR341094_WITH_NULL_GOSTR3411(130),
    TLS_GOSTR341001_WITH_NULL_GOSTR3411(131),
    TLS_RSA_WITH_CAMELLIA_256_CBC_SHA(132),
    TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA(133),
    TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA(134),
    TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA(135),
    TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA(136),
    TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA(137),
    TLS_PSK_WITH_RC4_128_SHA(138),
    TLS_PSK_WITH_3DES_EDE_CBC_SHA(139),
    TLS_PSK_WITH_AES_128_CBC_SHA(140),
    TLS_PSK_WITH_AES_256_CBC_SHA(141),
    TLS_DHE_PSK_WITH_RC4_128_SHA(142),
    TLS_DHE_PSK_WITH_3DES_EDE_CBC_SHA(143),
    TLS_DHE_PSK_WITH_AES_128_CBC_SHA(144),
    TLS_DHE_PSK_WITH_AES_256_CBC_SHA(145),
    TLS_RSA_PSK_WITH_RC4_128_SHA(146),
    TLS_RSA_PSK_WITH_3DES_EDE_CBC_SHA(147),
    TLS_RSA_PSK_WITH_AES_128_CBC_SHA(148),
    TLS_RSA_PSK_WITH_AES_256_CBC_SHA(149),
    TLS_RSA_WITH_SEED_CBC_SHA(150),
    TLS_DH_DSS_WITH_SEED_CBC_SHA(151),
    TLS_DH_RSA_WITH_SEED_CBC_SHA(152),
    TLS_DHE_DSS_WITH_SEED_CBC_SHA(153),
    TLS_DHE_RSA_WITH_SEED_CBC_SHA(154),
    TLS_DH_anon_WITH_SEED_CBC_SHA(155),
    TLS_RSA_WITH_AES_128_GCM_SHA256(156),
    TLS_RSA_WITH_AES_256_GCM_SHA384(157),
    TLS_DHE_RSA_WITH_AES_128_GCM_SHA256(158),
    TLS_DHE_RSA_WITH_AES_256_GCM_SHA384(159),
    TLS_DH_RSA_WITH_AES_128_GCM_SHA256(160),
    TLS_DH_RSA_WITH_AES_256_GCM_SHA384(161),
    TLS_DHE_DSS_WITH_AES_128_GCM_SHA256(162),
    TLS_DHE_DSS_WITH_AES_256_GCM_SHA384(163),
    TLS_DH_DSS_WITH_AES_128_GCM_SHA256(164),
    TLS_DH_DSS_WITH_AES_256_GCM_SHA384(165),
    TLS_DH_anon_WITH_AES_128_GCM_SHA256(166),
    TLS_DH_anon_WITH_AES_256_GCM_SHA384(167),
    TLS_PSK_WITH_AES_128_GCM_SHA256(168),
    TLS_PSK_WITH_AES_256_GCM_SHA384(169),
    TLS_DHE_PSK_WITH_AES_128_GCM_SHA256(170),
    TLS_DHE_PSK_WITH_AES_256_GCM_SHA384(171),
    TLS_RSA_PSK_WITH_AES_128_GCM_SHA256(172),
    TLS_RSA_PSK_WITH_AES_256_GCM_SHA384(173),
    TLS_PSK_WITH_AES_128_CBC_SHA256(174),
    TLS_PSK_WITH_AES_256_CBC_SHA384(175),
    TLS_PSK_WITH_NULL_SHA256(176),
    TLS_PSK_WITH_NULL_SHA384(177),
    TLS_DHE_PSK_WITH_AES_128_CBC_SHA256(178),
    TLS_DHE_PSK_WITH_AES_256_CBC_SHA384(179),
    TLS_DHE_PSK_WITH_NULL_SHA256(180),
    TLS_DHE_PSK_WITH_NULL_SHA384(181),
    TLS_RSA_PSK_WITH_AES_128_CBC_SHA256(182),
    TLS_RSA_PSK_WITH_AES_256_CBC_SHA384(183),
    TLS_RSA_PSK_WITH_NULL_SHA256(184),
    TLS_RSA_PSK_WITH_NULL_SHA384(185),
    TLS_RSA_WITH_CAMELLIA_128_CBC_SHA256(186),
    TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA256(187),
    TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA256(188),
    TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256(189),
    TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256(190),
    TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA256(191),
    TLS_RSA_WITH_CAMELLIA_256_CBC_SHA256(192),
    TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA256(193),
    TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA256(194),
    TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256(195),
    TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256(196),
    TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA256(197),
    TLS_EMPTY_RENEGOTIATION_INFO_SCSV(255),
    TLS_AES_128_GCM_SHA256(4865),
    TLS_AES_256_GCM_SHA384(4866),
    TLS_CHACHA20_POLY1305_SHA256(4867),
    TLS_AES_128_CCM_SHA256(4868),
    TLS_AES_128_CCM_8_SHA256(4869),
    TLS_FALLBACK_SCSV(22016),
    TLS_ECDH_ECDSA_WITH_NULL_SHA(49153),
    TLS_ECDH_ECDSA_WITH_RC4_128_SHA(49154),
    TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA(49155),
    TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA(49156),
    TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA(49157),
    TLS_ECDHE_ECDSA_WITH_NULL_SHA(49158),
    TLS_ECDHE_ECDSA_WITH_RC4_128_SHA(49159),
    TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA(49160),
    TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA(49161),
    TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA(49162),
    TLS_ECDH_RSA_WITH_NULL_SHA(49163),
    TLS_ECDH_RSA_WITH_RC4_128_SHA(49164),
    TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA(49165),
    TLS_ECDH_RSA_WITH_AES_128_CBC_SHA(49166),
    TLS_ECDH_RSA_WITH_AES_256_CBC_SHA(49167),
    TLS_ECDHE_RSA_WITH_NULL_SHA(49168),
    TLS_ECDHE_RSA_WITH_RC4_128_SHA(49169),
    TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA(49170),
    TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA(49171),
    TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA(49172),
    TLS_ECDH_anon_WITH_NULL_SHA(49173),
    TLS_ECDH_anon_WITH_RC4_128_SHA(49174),
    TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA(49175),
    TLS_ECDH_anon_WITH_AES_128_CBC_SHA(49176),
    TLS_ECDH_anon_WITH_AES_256_CBC_SHA(49177),
    TLS_SRP_SHA_WITH_3DES_EDE_CBC_SHA(49178),
    TLS_SRP_SHA_RSA_WITH_3DES_EDE_CBC_SHA(49179),
    TLS_SRP_SHA_DSS_WITH_3DES_EDE_CBC_SHA(49180),
    TLS_SRP_SHA_WITH_AES_128_CBC_SHA(49181),
    TLS_SRP_SHA_RSA_WITH_AES_128_CBC_SHA(49182),
    TLS_SRP_SHA_DSS_WITH_AES_128_CBC_SHA(49183),
    TLS_SRP_SHA_WITH_AES_256_CBC_SHA(49184),
    TLS_SRP_SHA_RSA_WITH_AES_256_CBC_SHA(49185),
    TLS_SRP_SHA_DSS_WITH_AES_256_CBC_SHA(49186),
    TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256(49187),
    TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384(49188),
    TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256(49189),
    TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384(49190),
    TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256(49191),
    TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384(49192),
    TLS_ECDH_RSA_WITH_AES_128_CBC_SHA256(49193),
    TLS_ECDH_RSA_WITH_AES_256_CBC_SHA384(49194),
    TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256(49195),
    TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384(49196),
    TLS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256(49197),
    TLS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384(49198),
    TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256(49199),
    TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384(49200),
    TLS_ECDH_RSA_WITH_AES_128_GCM_SHA256(49201),
    TLS_ECDH_RSA_WITH_AES_256_GCM_SHA384(49202),
    TLS_ECDHE_PSK_WITH_RC4_128_SHA(49203),
    TLS_ECDHE_PSK_WITH_3DES_EDE_CBC_SHA(49204),
    TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA(49205),
    TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA(49206),
    TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256(49207),
    TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA384(49208),
    TLS_ECDHE_PSK_WITH_NULL_SHA(49209),
    TLS_ECDHE_PSK_WITH_NULL_SHA256(49210),
    TLS_ECDHE_PSK_WITH_NULL_SHA384(49211),
    TLS_RSA_WITH_ARIA_128_CBC_SHA256(49212),
    TLS_RSA_WITH_ARIA_256_CBC_SHA384(49213),
    TLS_DH_DSS_WITH_ARIA_128_CBC_SHA256(49214),
    TLS_DH_DSS_WITH_ARIA_256_CBC_SHA384(49215),
    TLS_DH_RSA_WITH_ARIA_128_CBC_SHA256(49216),
    TLS_DH_RSA_WITH_ARIA_256_CBC_SHA384(49217),
    TLS_DHE_DSS_WITH_ARIA_128_CBC_SHA256(49218),
    TLS_DHE_DSS_WITH_ARIA_256_CBC_SHA384(49219),
    TLS_DHE_RSA_WITH_ARIA_128_CBC_SHA256(49220),
    TLS_DHE_RSA_WITH_ARIA_256_CBC_SHA384(49221),
    TLS_DH_anon_WITH_ARIA_128_CBC_SHA256(49222),
    TLS_DH_anon_WITH_ARIA_256_CBC_SHA384(49223),
    TLS_ECDHE_ECDSA_WITH_ARIA_128_CBC_SHA256(49224),
    TLS_ECDHE_ECDSA_WITH_ARIA_256_CBC_SHA384(49225),
    TLS_ECDH_ECDSA_WITH_ARIA_128_CBC_SHA256(49226),
    TLS_ECDH_ECDSA_WITH_ARIA_256_CBC_SHA384(49227),
    TLS_ECDHE_RSA_WITH_ARIA_128_CBC_SHA256(49228),
    TLS_ECDHE_RSA_WITH_ARIA_256_CBC_SHA384(49229),
    TLS_ECDH_RSA_WITH_ARIA_128_CBC_SHA256(49230),
    TLS_ECDH_RSA_WITH_ARIA_256_CBC_SHA384(49231),
    TLS_RSA_WITH_ARIA_128_GCM_SHA256(49232),
    TLS_RSA_WITH_ARIA_256_GCM_SHA384(49233),
    TLS_DHE_RSA_WITH_ARIA_128_GCM_SHA256(49234),
    TLS_DHE_RSA_WITH_ARIA_256_GCM_SHA384(49235),
    TLS_DH_RSA_WITH_ARIA_128_GCM_SHA256(49236),
    TLS_DH_RSA_WITH_ARIA_256_GCM_SHA384(49237),
    TLS_DHE_DSS_WITH_ARIA_128_GCM_SHA256(49238),
    TLS_DHE_DSS_WITH_ARIA_256_GCM_SHA384(49239),
    TLS_DH_DSS_WITH_ARIA_128_GCM_SHA256(49240),
    TLS_DH_DSS_WITH_ARIA_256_GCM_SHA384(49241),
    TLS_DH_anon_WITH_ARIA_128_GCM_SHA256(49242),
    TLS_DH_anon_WITH_ARIA_256_GCM_SHA384(49243),
    TLS_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256(49244),
    TLS_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384(49245),
    TLS_ECDH_ECDSA_WITH_ARIA_128_GCM_SHA256(49246),
    TLS_ECDH_ECDSA_WITH_ARIA_256_GCM_SHA384(49247),
    TLS_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256(49248),
    TLS_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384(49249),
    TLS_ECDH_RSA_WITH_ARIA_128_GCM_SHA256(49250),
    TLS_ECDH_RSA_WITH_ARIA_256_GCM_SHA384(49251),
    TLS_PSK_WITH_ARIA_128_CBC_SHA256(49252),
    TLS_PSK_WITH_ARIA_256_CBC_SHA384(49253),
    TLS_DHE_PSK_WITH_ARIA_128_CBC_SHA256(49254),
    TLS_DHE_PSK_WITH_ARIA_256_CBC_SHA384(49255),
    TLS_RSA_PSK_WITH_ARIA_128_CBC_SHA256(49256),
    TLS_RSA_PSK_WITH_ARIA_256_CBC_SHA384(49257),
    TLS_PSK_WITH_ARIA_128_GCM_SHA256(49258),
    TLS_PSK_WITH_ARIA_256_GCM_SHA384(49259),
    TLS_DHE_PSK_WITH_ARIA_128_GCM_SHA256(49260),
    TLS_DHE_PSK_WITH_ARIA_256_GCM_SHA384(49261),
    TLS_RSA_PSK_WITH_ARIA_128_GCM_SHA256(49262),
    TLS_RSA_PSK_WITH_ARIA_256_GCM_SHA384(49263),
    TLS_ECDHE_PSK_WITH_ARIA_128_CBC_SHA256(49264),
    TLS_ECDHE_PSK_WITH_ARIA_256_CBC_SHA384(49265),
    TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256(49266),
    TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384(49267),
    TLS_ECDH_ECDSA_WITH_CAMELLIA_128_CBC_SHA256(49268),
    TLS_ECDH_ECDSA_WITH_CAMELLIA_256_CBC_SHA384(49269),
    TLS_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256(49270),
    TLS_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384(49271),
    TLS_ECDH_RSA_WITH_CAMELLIA_128_CBC_SHA256(49272),
    TLS_ECDH_RSA_WITH_CAMELLIA_256_CBC_SHA384(49273),
    TLS_RSA_WITH_CAMELLIA_128_GCM_SHA256(49274),
    TLS_RSA_WITH_CAMELLIA_256_GCM_SHA384(49275),
    TLS_DHE_RSA_WITH_CAMELLIA_128_GCM_SHA256(49276),
    TLS_DHE_RSA_WITH_CAMELLIA_256_GCM_SHA384(49277),
    TLS_DH_RSA_WITH_CAMELLIA_128_GCM_SHA256(49278),
    TLS_DH_RSA_WITH_CAMELLIA_256_GCM_SHA384(49279),
    TLS_DHE_DSS_WITH_CAMELLIA_128_GCM_SHA256(49280),
    TLS_DHE_DSS_WITH_CAMELLIA_256_GCM_SHA384(49281),
    TLS_DH_DSS_WITH_CAMELLIA_128_GCM_SHA256(49282),
    TLS_DH_DSS_WITH_CAMELLIA_256_GCM_SHA384(49283),
    TLS_DH_anon_WITH_CAMELLIA_128_GCM_SHA256(49284),
    TLS_DH_anon_WITH_CAMELLIA_256_GCM_SHA384(49285),
    TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_GCM_SHA256(49286),
    TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_GCM_SHA384(49287),
    TLS_ECDH_ECDSA_WITH_CAMELLIA_128_GCM_SHA256(49288),
    TLS_ECDH_ECDSA_WITH_CAMELLIA_256_GCM_SHA384(49289),
    TLS_ECDHE_RSA_WITH_CAMELLIA_128_GCM_SHA256(49290),
    TLS_ECDHE_RSA_WITH_CAMELLIA_256_GCM_SHA384(49291),
    TLS_ECDH_RSA_WITH_CAMELLIA_128_GCM_SHA256(49292),
    TLS_ECDH_RSA_WITH_CAMELLIA_256_GCM_SHA384(49293),
    TLS_PSK_WITH_CAMELLIA_128_GCM_SHA256(49294),
    TLS_PSK_WITH_CAMELLIA_256_GCM_SHA384(49295),
    TLS_DHE_PSK_WITH_CAMELLIA_128_GCM_SHA256(49296),
    TLS_DHE_PSK_WITH_CAMELLIA_256_GCM_SHA384(49297),
    TLS_RSA_PSK_WITH_CAMELLIA_128_GCM_SHA256(49298),
    TLS_RSA_PSK_WITH_CAMELLIA_256_GCM_SHA384(49299),
    TLS_PSK_WITH_CAMELLIA_128_CBC_SHA256(49300),
    TLS_PSK_WITH_CAMELLIA_256_CBC_SHA384(49301),
    TLS_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256(49302),
    TLS_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384(49303),
    TLS_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256(49304),
    TLS_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384(49305),
    TLS_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256(49306),
    TLS_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384(49307),
    TLS_RSA_WITH_AES_128_CCM(49308),
    TLS_RSA_WITH_AES_256_CCM(49309),
    TLS_DHE_RSA_WITH_AES_128_CCM(49310),
    TLS_DHE_RSA_WITH_AES_256_CCM(49311),
    TLS_RSA_WITH_AES_128_CCM_8(49312),
    TLS_RSA_WITH_AES_256_CCM_8(49313),
    TLS_DHE_RSA_WITH_AES_128_CCM_8(49314),
    TLS_DHE_RSA_WITH_AES_256_CCM_8(49315),
    TLS_PSK_WITH_AES_128_CCM(49316),
    TLS_PSK_WITH_AES_256_CCM(49317),
    TLS_DHE_PSK_WITH_AES_128_CCM(49318),
    TLS_DHE_PSK_WITH_AES_256_CCM(49319),
    TLS_PSK_WITH_AES_128_CCM_8(49320),
    TLS_PSK_WITH_AES_256_CCM_8(49321),
    TLS_PSK_DHE_WITH_AES_128_CCM_8(49322),
    TLS_PSK_DHE_WITH_AES_256_CCM_8(49323),
    TLS_PSK_DHE_WITH_AES_256_CCM_80(49323),
    TLS_ECDHE_ECDSA_WITH_AES_128_CCM(49324),
    TLS_ECDHE_ECDSA_WITH_AES_256_CCM(49325),
    TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8(49326),
    TLS_ECDHE_ECDSA_WITH_AES_256_CCM_8(49327),
    TLS_ECCPWD_WITH_AES_128_GCM_SHA256(49328),
    TLS_ECCPWD_WITH_AES_256_GCM_SHA384(49329),
    TLS_ECCPWD_WITH_AES_128_CCM_SHA256(49330),
    TLS_ECCPWD_WITH_AES_256_CCM_SHA384(49331),
    UNOFFICIAL_TLS_RSA_WITH_CHACHA20_POLY1305(52242),
    UNOFFICIAL_TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256(52243),
    UNOFFICIAL_TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256(52244),
    UNOFFICIAL_TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256(52245),
    UNOFFICIAL_TLS_DHE_PSK_WITH_CHACHA20_POLY1305_OLD(52246),
    UNOFFICIAL_TLS_PSK_WITH_CHACHA20_POLY1305_OLD(52247),
    UNOFFICIAL_TLS_ECDHE_PSK_WITH_CHACHA20_POLY1305_OLD(52248),
    UNOFFICIAL_TLS_RSA_PSK_WITH_CHACHA20_POLY1305_OLD(52249),
    TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256(52392),
    TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256(52393),
    TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256(52394),
    TLS_PSK_WITH_CHACHA20_POLY1305_SHA256(52395),
    TLS_ECDHE_PSK_WITH_CHACHA20_POLY1305_SHA256(52396),
    TLS_DHE_PSK_WITH_CHACHA20_POLY1305_SHA256(52397),
    TLS_RSA_PSK_WITH_CHACHA20_POLY1305_SHA256(52398),
    TLS_CECPQ1_RSA_WITH_CHACHA20_POLY1305_SHA256(5815),
    TLS_CECPQ1_ECDSA_WITH_CHACHA20_POLY1305_SHA256(5816),
    TLS_CECPQ1_RSA_WITH_AES_256_GCM_SHA384(5817),
    TLS_CECPQ1_ECDSA_WITH_AES_256_GCM_SHA384(5818),
    TLS_RSA_WITH_RABBIT_CBC_SHA(253),
    GREASE_00(2570),
    GREASE_01(6682),
    GREASE_02(10794),
    GREASE_03(14906),
    GREASE_04(19018),
    GREASE_05(23130),
    GREASE_06(27242),
    GREASE_07(31354),
    GREASE_08(35466),
    GREASE_09(39578),
    GREASE_10(43690),
    GREASE_11(47802),
    GREASE_12(51914),
    GREASE_13(56026),
    GREASE_14(60138),
    GREASE_15(64250),
    TLS_GOSTR341112_256_WITH_28147_CNT_IMIT(65413),
    TLS_GOSTR341112_256_WITH_NULL_GOSTR3411(65415);

    private int value;
    public static final int EXPORT_SYMMETRIC_KEY_SIZE_BYTES = 5;
    private static final Map<Integer, CipherSuite> MAP;
    public static final Set<CipherSuite> SSL3_SUPPORTED_CIPHERSUITES;

    private CipherSuite(int value) {
        this.value = value;
    }

    public static CipherSuite getRandom(Random random) {
        CipherSuite c = null;
        while (c == null) {
            Object[] o = MAP.values().toArray();
            c = (CipherSuite)((Object)o[random.nextInt(o.length)]);
        }
        return c;
    }

    private static int valueToInt(byte[] value) {
        if (value.length >= 2) {
            return (value[0] & 0xFF) << 8 | value[1] & 0xFF;
        }
        if (value.length == 1) {
            return value[0];
        }
        return 0;
    }

    public static List<CipherSuite> getCiphersuites(byte[] values) {
        LinkedList<CipherSuite> cipherSuites = new LinkedList<CipherSuite>();
        if (values.length % 2 != 0) {
            throw new UnknownCiphersuiteException("Last CipherSuit are unknown!");
        }
        for (int pointer = 0; pointer < values.length; pointer += 2) {
            byte[] suite = new byte[]{values[pointer], values[pointer + 1]};
            cipherSuites.add(CipherSuite.getCipherSuite(suite));
        }
        return cipherSuites;
    }

    public static CipherSuite getCipherSuite(byte[] value) {
        return CipherSuite.getCipherSuite(CipherSuite.valueToInt(value));
    }

    public static CipherSuite getCipherSuite(int value) {
        CipherSuite cs = MAP.get(value);
        return cs;
    }

    public byte[] getByteValue() {
        return ArrayConverter.intToBytes((int)this.value, (int)2);
    }

    public int getValue() {
        return this.value;
    }

    public boolean isEphemeral() {
        return this.name().contains("DHE_") || this.isAnon() || this.isPWD() || this.isTLS13();
    }

    public boolean isPskOrDhPsk() {
        if (!this.name().contains("RSA")) {
            return this.name().contains("PSK");
        }
        return false;
    }

    public boolean isPsk() {
        return this.name().contains("PSK");
    }

    public boolean isSrpSha() {
        return this.name().contains("SRP_SHA");
    }

    public boolean isSrp() {
        return this.name().contains("SRP_");
    }

    public boolean isExport() {
        return this.name().contains("EXPORT");
    }

    public boolean isGrease() {
        return this.name().contains("GREASE");
    }

    public boolean isExportSymmetricCipher() {
        return this.name().contains("DES40") || this.name().contains("RC4_40") || this.name().contains("RC2_CBC_40") || this.name().contains("DES_CBC_40");
    }

    public boolean isCBC() {
        return this.name().contains("_CBC");
    }

    public boolean isUsingPadding() {
        return this.name().contains("_CBC");
    }

    public boolean isUsingMac() {
        if (this.name().contains("NULL")) {
            String[] hashFunctionNames;
            String cipher = this.toString();
            if (cipher.endsWith("NULL")) {
                return false;
            }
            for (String hashFunction : hashFunctionNames = new String[]{"MD5", "SHA", "SHA256", "SHA384", "SHA512", "IMIT", "GOSTR3411"}) {
                if (!cipher.endsWith(hashFunction)) continue;
                return true;
            }
            return false;
        }
        return this.name().contains("_CBC") || this.name().contains("RC4") || this.name().contains("CNT");
    }

    public boolean isSCSV() {
        return this.name().contains("SCSV");
    }

    public boolean isGCM() {
        return this.name().contains("_GCM");
    }

    public boolean isCCM() {
        return this.name().contains("_CCM");
    }

    public boolean isCCM_8() {
        return this.name().contains("_CCM_8");
    }

    public boolean isOCB() {
        return this.name().contains("_OCB");
    }

    public boolean isSteamCipherWithIV() {
        return this.name().contains("28147_CNT");
    }

    public boolean isAEAD() {
        return this.isCCM() || this.isChachaPoly() || this.isGCM() || this.isOCB();
    }

    public boolean usesSHA384() {
        return this.name().endsWith("SHA384");
    }

    public boolean usesGOSTR3411() {
        return this.name().startsWith("TLS_GOSTR3410");
    }

    public boolean usesGOSTR34112012() {
        return this.name().startsWith("TLS_GOSTR3411");
    }

    public boolean usesStrictExplicitIv() {
        return this.name().contains("CHACHA20_POLY1305");
    }

    public boolean usesDH() {
        return this.name().contains("_DH");
    }

    public boolean isSupportedInProtocol(ProtocolVersion version) {
        if (version == ProtocolVersion.SSL3) {
            return SSL3_SUPPORTED_CIPHERSUITES.contains((Object)this);
        }
        if (this.name().endsWith("256") || this.name().endsWith("384") || this.isCCM() || this.isCCM_8() && !this.name().contains("IDEA") && !this.name().contains("_DES") && !this.isExportSymmetricCipher()) {
            return version == ProtocolVersion.TLS12;
        }
        return true;
    }

    public static List<CipherSuite> getImplemented() {
        LinkedList<CipherSuite> list = new LinkedList<CipherSuite>();
        list.add(TLS_RSA_WITH_3DES_EDE_CBC_SHA);
        list.add(TLS_RSA_WITH_AES_128_CBC_SHA);
        list.add(TLS_RSA_WITH_NULL_MD5);
        list.add(TLS_RSA_WITH_NULL_SHA);
        list.add(TLS_RSA_WITH_AES_128_CBC_SHA256);
        list.add(TLS_RSA_WITH_AES_256_CBC_SHA256);
        list.add(TLS_RSA_WITH_AES_256_CBC_SHA);
        list.add(TLS_RSA_WITH_CAMELLIA_128_CBC_SHA);
        list.add(TLS_RSA_WITH_CAMELLIA_256_CBC_SHA);
        list.add(TLS_RSA_WITH_IDEA_CBC_SHA);
        list.add(TLS_RSA_WITH_DES_CBC_SHA);
        list.add(TLS_RSA_WITH_SEED_CBC_SHA);
        list.add(TLS_RSA_WITH_RC4_128_MD5);
        list.add(TLS_RSA_WITH_RC4_128_SHA);
        list.add(TLS_RSA_WITH_AES_128_CCM);
        list.add(TLS_RSA_WITH_AES_256_CCM);
        list.add(TLS_RSA_WITH_AES_128_GCM_SHA256);
        list.add(TLS_RSA_WITH_AES_256_GCM_SHA384);
        list.add(TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA);
        list.add(TLS_DH_RSA_WITH_3DES_EDE_CBC_SHA);
        list.add(TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA);
        list.add(TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA);
        list.add(TLS_DH_anon_EXPORT_WITH_RC4_40_MD5);
        list.add(TLS_DH_anon_EXPORT_WITH_DES40_CBC_SHA);
        list.add(TLS_DH_anon_WITH_RC4_128_MD5);
        list.add(TLS_DH_anon_WITH_DES_CBC_SHA);
        list.add(TLS_DH_anon_WITH_3DES_EDE_CBC_SHA);
        list.add(TLS_DH_DSS_WITH_AES_128_CBC_SHA);
        list.add(TLS_DH_RSA_WITH_AES_128_CBC_SHA);
        list.add(TLS_DHE_DSS_WITH_AES_128_CBC_SHA);
        list.add(TLS_DHE_RSA_WITH_AES_128_CBC_SHA);
        list.add(TLS_DH_anon_WITH_AES_128_CBC_SHA);
        list.add(TLS_DH_DSS_WITH_AES_256_CBC_SHA);
        list.add(TLS_DH_RSA_WITH_AES_256_CBC_SHA);
        list.add(TLS_DHE_DSS_WITH_AES_256_CBC_SHA);
        list.add(TLS_DHE_RSA_WITH_AES_256_CBC_SHA);
        list.add(TLS_DH_anon_WITH_AES_256_CBC_SHA);
        list.add(TLS_ECDH_ECDSA_WITH_3DES_EDE_CBC_SHA);
        list.add(TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA);
        list.add(TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA);
        list.add(TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA);
        list.add(TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA);
        list.add(TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA);
        list.add(TLS_ECDH_RSA_WITH_3DES_EDE_CBC_SHA);
        list.add(TLS_ECDH_RSA_WITH_AES_128_CBC_SHA);
        list.add(TLS_ECDH_RSA_WITH_AES_256_CBC_SHA);
        list.add(TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA);
        list.add(TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA);
        list.add(TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA);
        list.add(TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256);
        list.add(TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384);
        list.add(TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384);
        list.add(TLS_DH_RSA_WITH_AES_256_GCM_SHA384);
        list.add(TLS_DH_RSA_WITH_AES_128_GCM_SHA256);
        list.add(TLS_DH_DSS_WITH_AES_256_GCM_SHA384);
        list.add(TLS_DH_anon_WITH_AES_128_GCM_SHA256);
        list.add(TLS_DH_anon_WITH_AES_256_GCM_SHA384);
        list.add(TLS_DHE_RSA_WITH_AES_128_GCM_SHA256);
        list.add(TLS_DHE_RSA_WITH_AES_256_GCM_SHA384);
        list.add(TLS_DHE_RSA_WITH_AES_128_CBC_SHA256);
        list.add(TLS_DHE_RSA_WITH_AES_256_CBC_SHA256);
        list.add(TLS_DH_anon_WITH_AES_128_CBC_SHA256);
        list.add(TLS_DH_anon_WITH_AES_256_CBC_SHA256);
        list.add(TLS_DHE_RSA_WITH_DES_CBC_SHA);
        list.add(TLS_DHE_RSA_WITH_AES_128_CCM);
        list.add(TLS_DHE_RSA_WITH_AES_256_CCM);
        list.add(TLS_DHE_RSA_WITH_SEED_CBC_SHA);
        list.add(TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA);
        list.add(TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA);
        list.add(TLS_DHE_DSS_WITH_AES_128_GCM_SHA256);
        list.add(TLS_DHE_DSS_WITH_AES_256_GCM_SHA384);
        list.add(TLS_DHE_DSS_WITH_RC4_128_SHA);
        list.add(TLS_ECDH_RSA_WITH_AES_128_GCM_SHA256);
        list.add(TLS_ECDH_RSA_WITH_AES_256_GCM_SHA384);
        list.add(TLS_ECDHE_RSA_WITH_RC4_128_SHA);
        list.add(TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256);
        list.add(TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384);
        list.add(TLS_ECDH_ECDSA_WITH_AES_128_GCM_SHA256);
        list.add(TLS_ECDH_ECDSA_WITH_AES_256_GCM_SHA384);
        list.add(TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256);
        list.add(TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384);
        list.add(TLS_ECDHE_ECDSA_WITH_AES_128_CCM);
        list.add(TLS_ECDHE_ECDSA_WITH_AES_256_CCM);
        list.add(TLS_AES_128_GCM_SHA256);
        list.add(TLS_AES_256_GCM_SHA384);
        list.add(TLS_CHACHA20_POLY1305_SHA256);
        list.add(TLS_AES_128_CCM_SHA256);
        list.add(TLS_AES_128_CCM_8_SHA256);
        list.add(TLS_PSK_WITH_AES_128_CBC_SHA);
        list.add(TLS_PSK_DHE_WITH_AES_128_CCM_8);
        list.add(TLS_PSK_DHE_WITH_AES_256_CCM_8);
        list.add(TLS_PSK_DHE_WITH_AES_256_CCM_80);
        list.add(TLS_PSK_WITH_3DES_EDE_CBC_SHA);
        list.add(TLS_PSK_WITH_AES_128_CBC_SHA256);
        list.add(TLS_PSK_WITH_AES_128_CCM);
        list.add(TLS_PSK_WITH_AES_128_CCM_8);
        list.add(TLS_PSK_WITH_AES_128_GCM_SHA256);
        list.add(TLS_PSK_WITH_AES_256_CBC_SHA);
        list.add(TLS_PSK_WITH_AES_256_CBC_SHA384);
        list.add(TLS_PSK_WITH_AES_256_CCM);
        list.add(TLS_PSK_WITH_AES_256_CCM_8);
        list.add(TLS_PSK_WITH_AES_256_GCM_SHA384);
        list.add(TLS_PSK_WITH_RC4_128_SHA);
        list.add(TLS_DHE_PSK_WITH_3DES_EDE_CBC_SHA);
        list.add(TLS_DHE_PSK_WITH_AES_128_CBC_SHA);
        list.add(TLS_DHE_PSK_WITH_AES_128_CCM);
        list.add(TLS_DHE_PSK_WITH_AES_128_GCM_SHA256);
        list.add(TLS_DHE_PSK_WITH_AES_256_CBC_SHA);
        list.add(TLS_DHE_PSK_WITH_AES_256_CBC_SHA384);
        list.add(TLS_DHE_PSK_WITH_AES_256_CCM);
        list.add(TLS_DHE_PSK_WITH_AES_256_GCM_SHA384);
        list.add(TLS_DHE_PSK_WITH_RC4_128_SHA);
        list.add(TLS_ECDHE_PSK_WITH_3DES_EDE_CBC_SHA);
        list.add(TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA);
        list.add(TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256);
        list.add(TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA);
        list.add(TLS_ECDHE_PSK_WITH_AES_256_CBC_SHA384);
        list.add(TLS_ECDHE_PSK_WITH_RC4_128_SHA);
        list.add(TLS_DH_RSA_WITH_DES_CBC_SHA);
        list.add(TLS_DH_RSA_WITH_AES_128_CBC_SHA256);
        list.add(TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA);
        list.add(UNOFFICIAL_TLS_ECDH_ECDSA_WITH_RC4_128_SHA);
        list.add(UNOFFICIAL_TLS_ECDH_ECDSA_WITH_DES_CBC_SHA);
        list.add(UNOFFICIAL_TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA);
        list.add(TLS_DH_DSS_WITH_AES_256_CBC_SHA256);
        list.add(TLS_DH_RSA_WITH_AES_256_CBC_SHA256);
        list.add(TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA);
        list.add(TLS_RSA_PSK_WITH_RC4_128_SHA);
        list.add(TLS_RSA_PSK_WITH_3DES_EDE_CBC_SHA);
        list.add(TLS_RSA_PSK_WITH_AES_128_CBC_SHA);
        list.add(TLS_RSA_PSK_WITH_AES_256_CBC_SHA);
        list.add(TLS_DH_RSA_WITH_SEED_CBC_SHA);
        list.add(TLS_RSA_PSK_WITH_AES_128_GCM_SHA256);
        list.add(TLS_RSA_PSK_WITH_AES_256_GCM_SHA384);
        list.add(TLS_DHE_PSK_WITH_AES_128_CBC_SHA256);
        list.add(TLS_RSA_PSK_WITH_AES_128_CBC_SHA256);
        list.add(TLS_RSA_PSK_WITH_AES_256_CBC_SHA384);
        list.add(TLS_RSA_WITH_CAMELLIA_128_CBC_SHA256);
        list.add(TLS_DH_RSA_WITH_CAMELLIA_128_CBC_SHA256);
        list.add(TLS_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA256);
        list.add(TLS_RSA_WITH_CAMELLIA_256_CBC_SHA256);
        list.add(TLS_DH_RSA_WITH_CAMELLIA_256_CBC_SHA256);
        list.add(TLS_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA256);
        list.add(TLS_ECDH_ECDSA_WITH_RC4_128_SHA);
        list.add(TLS_ECDHE_ECDSA_WITH_RC4_128_SHA);
        list.add(TLS_ECDH_RSA_WITH_RC4_128_SHA);
        list.add(TLS_ECDH_anon_WITH_NULL_SHA);
        list.add(TLS_SRP_SHA_WITH_AES_128_CBC_SHA);
        list.add(TLS_SRP_SHA_WITH_AES_256_CBC_SHA);
        list.add(TLS_ECDH_ECDSA_WITH_AES_128_CBC_SHA256);
        list.add(TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA384);
        list.add(TLS_ECDH_RSA_WITH_AES_128_CBC_SHA256);
        list.add(TLS_ECDH_RSA_WITH_AES_256_CBC_SHA384);
        list.add(TLS_ECDHE_PSK_WITH_AES_128_CBC_SHA256);
        list.add(TLS_RSA_WITH_ARIA_128_CBC_SHA256);
        list.add(TLS_RSA_WITH_ARIA_256_CBC_SHA384);
        list.add(TLS_ECDHE_ECDSA_WITH_ARIA_128_CBC_SHA256);
        list.add(TLS_ECDHE_ECDSA_WITH_ARIA_256_CBC_SHA384);
        list.add(TLS_ECDH_ECDSA_WITH_ARIA_128_CBC_SHA256);
        list.add(TLS_ECDH_ECDSA_WITH_ARIA_256_CBC_SHA384);
        list.add(TLS_ECDHE_RSA_WITH_ARIA_128_CBC_SHA256);
        list.add(TLS_ECDHE_RSA_WITH_ARIA_256_CBC_SHA384);
        list.add(TLS_ECDH_RSA_WITH_ARIA_128_CBC_SHA256);
        list.add(TLS_ECDH_RSA_WITH_ARIA_256_CBC_SHA384);
        list.add(TLS_RSA_WITH_ARIA_128_GCM_SHA256);
        list.add(TLS_RSA_WITH_ARIA_256_GCM_SHA384);
        list.add(TLS_DHE_RSA_WITH_ARIA_128_GCM_SHA256);
        list.add(TLS_DHE_RSA_WITH_ARIA_256_GCM_SHA384);
        list.add(TLS_DH_RSA_WITH_ARIA_128_GCM_SHA256);
        list.add(TLS_DH_RSA_WITH_ARIA_256_GCM_SHA384);
        list.add(TLS_ECDHE_ECDSA_WITH_ARIA_128_GCM_SHA256);
        list.add(TLS_ECDHE_ECDSA_WITH_ARIA_256_GCM_SHA384);
        list.add(TLS_ECDH_ECDSA_WITH_ARIA_128_GCM_SHA256);
        list.add(TLS_ECDH_ECDSA_WITH_ARIA_256_GCM_SHA384);
        list.add(TLS_ECDHE_RSA_WITH_ARIA_128_GCM_SHA256);
        list.add(TLS_ECDHE_RSA_WITH_ARIA_256_GCM_SHA384);
        list.add(TLS_ECDH_RSA_WITH_ARIA_128_GCM_SHA256);
        list.add(TLS_ECDH_RSA_WITH_ARIA_256_GCM_SHA384);
        list.add(TLS_PSK_WITH_ARIA_128_CBC_SHA256);
        list.add(TLS_PSK_WITH_ARIA_256_CBC_SHA384);
        list.add(TLS_DHE_PSK_WITH_ARIA_128_CBC_SHA256);
        list.add(TLS_DHE_PSK_WITH_ARIA_256_CBC_SHA384);
        list.add(TLS_RSA_PSK_WITH_ARIA_128_CBC_SHA256);
        list.add(TLS_RSA_PSK_WITH_ARIA_256_CBC_SHA384);
        list.add(TLS_PSK_WITH_ARIA_128_GCM_SHA256);
        list.add(TLS_PSK_WITH_ARIA_256_GCM_SHA384);
        list.add(TLS_DHE_PSK_WITH_ARIA_128_GCM_SHA256);
        list.add(TLS_DHE_PSK_WITH_ARIA_256_GCM_SHA384);
        list.add(TLS_RSA_PSK_WITH_ARIA_128_GCM_SHA256);
        list.add(TLS_RSA_PSK_WITH_ARIA_256_GCM_SHA384);
        list.add(TLS_ECDHE_PSK_WITH_ARIA_128_CBC_SHA256);
        list.add(TLS_ECDHE_PSK_WITH_ARIA_256_CBC_SHA384);
        list.add(TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_CBC_SHA256);
        list.add(TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_CBC_SHA384);
        list.add(TLS_ECDH_ECDSA_WITH_CAMELLIA_128_CBC_SHA256);
        list.add(TLS_ECDH_ECDSA_WITH_CAMELLIA_256_CBC_SHA384);
        list.add(TLS_ECDHE_RSA_WITH_CAMELLIA_128_CBC_SHA256);
        list.add(TLS_ECDHE_RSA_WITH_CAMELLIA_256_CBC_SHA384);
        list.add(TLS_ECDH_RSA_WITH_CAMELLIA_128_CBC_SHA256);
        list.add(TLS_ECDH_RSA_WITH_CAMELLIA_256_CBC_SHA384);
        list.add(TLS_RSA_WITH_CAMELLIA_128_GCM_SHA256);
        list.add(TLS_RSA_WITH_CAMELLIA_256_GCM_SHA384);
        list.add(TLS_DHE_RSA_WITH_CAMELLIA_128_GCM_SHA256);
        list.add(TLS_DHE_RSA_WITH_CAMELLIA_256_GCM_SHA384);
        list.add(TLS_DH_RSA_WITH_CAMELLIA_128_GCM_SHA256);
        list.add(TLS_DH_RSA_WITH_CAMELLIA_256_GCM_SHA384);
        list.add(TLS_ECDHE_ECDSA_WITH_CAMELLIA_128_GCM_SHA256);
        list.add(TLS_ECDHE_ECDSA_WITH_CAMELLIA_256_GCM_SHA384);
        list.add(TLS_ECDH_ECDSA_WITH_CAMELLIA_128_GCM_SHA256);
        list.add(TLS_ECDH_ECDSA_WITH_CAMELLIA_256_GCM_SHA384);
        list.add(TLS_ECDHE_RSA_WITH_CAMELLIA_128_GCM_SHA256);
        list.add(TLS_ECDHE_RSA_WITH_CAMELLIA_256_GCM_SHA384);
        list.add(TLS_ECDH_RSA_WITH_CAMELLIA_128_GCM_SHA256);
        list.add(TLS_ECDH_RSA_WITH_CAMELLIA_256_GCM_SHA384);
        list.add(TLS_PSK_WITH_CAMELLIA_128_GCM_SHA256);
        list.add(TLS_PSK_WITH_CAMELLIA_256_GCM_SHA384);
        list.add(TLS_DHE_PSK_WITH_CAMELLIA_128_GCM_SHA256);
        list.add(TLS_DHE_PSK_WITH_CAMELLIA_256_GCM_SHA384);
        list.add(TLS_RSA_PSK_WITH_CAMELLIA_128_GCM_SHA256);
        list.add(TLS_RSA_PSK_WITH_CAMELLIA_256_GCM_SHA384);
        list.add(TLS_PSK_WITH_CAMELLIA_128_CBC_SHA256);
        list.add(TLS_PSK_WITH_CAMELLIA_256_CBC_SHA384);
        list.add(TLS_DHE_PSK_WITH_CAMELLIA_128_CBC_SHA256);
        list.add(TLS_DHE_PSK_WITH_CAMELLIA_256_CBC_SHA384);
        list.add(TLS_RSA_PSK_WITH_CAMELLIA_128_CBC_SHA256);
        list.add(TLS_RSA_PSK_WITH_CAMELLIA_256_CBC_SHA384);
        list.add(TLS_ECDHE_PSK_WITH_CAMELLIA_128_CBC_SHA256);
        list.add(TLS_ECDHE_PSK_WITH_CAMELLIA_256_CBC_SHA384);
        list.add(TLS_PSK_WITH_NULL_SHA);
        list.add(TLS_DHE_PSK_WITH_NULL_SHA);
        list.add(TLS_RSA_PSK_WITH_NULL_SHA);
        list.add(TLS_RSA_WITH_NULL_SHA256);
        list.add(UNOFFICIAL_TLS_ECDH_ECDSA_WITH_NULL_SHA);
        list.add(TLS_PSK_WITH_NULL_SHA256);
        list.add(TLS_PSK_WITH_NULL_SHA384);
        list.add(TLS_DHE_PSK_WITH_NULL_SHA256);
        list.add(TLS_DHE_PSK_WITH_NULL_SHA384);
        list.add(TLS_RSA_PSK_WITH_NULL_SHA256);
        list.add(TLS_RSA_PSK_WITH_NULL_SHA384);
        list.add(TLS_ECDH_ECDSA_WITH_NULL_SHA);
        list.add(TLS_ECDHE_ECDSA_WITH_NULL_SHA);
        list.add(TLS_ECDH_RSA_WITH_NULL_SHA);
        list.add(TLS_ECDHE_RSA_WITH_NULL_SHA);
        list.add(TLS_ECDHE_PSK_WITH_NULL_SHA);
        list.add(TLS_ECDHE_PSK_WITH_NULL_SHA256);
        list.add(TLS_ECDHE_PSK_WITH_NULL_SHA384);
        list.add(TLS_DH_DSS_WITH_DES_CBC_SHA);
        list.add(TLS_DHE_DSS_WITH_DES_CBC_SHA);
        list.add(TLS_DH_DSS_WITH_AES_128_CBC_SHA256);
        list.add(TLS_DHE_DSS_WITH_AES_128_CBC_SHA256);
        list.add(TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA);
        list.add(TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA);
        list.add(TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA);
        list.add(UNOFFICIAL_TLS_ECDH_anon_WITH_NULL_SHA);
        list.add(UNOFFICIAL_TLS_ECDH_anon_WITH_RC4_128_SHA);
        list.add(UNOFFICIAL_TLS_ECDH_anon_WITH_DES_CBC_SHA);
        list.add(UNOFFICIAL_TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA);
        list.add(TLS_DHE_DSS_WITH_AES_256_CBC_SHA256);
        list.add(TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA);
        list.add(TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA);
        list.add(TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA);
        list.add(TLS_DH_DSS_WITH_SEED_CBC_SHA);
        list.add(TLS_DHE_DSS_WITH_SEED_CBC_SHA);
        list.add(TLS_DH_anon_WITH_SEED_CBC_SHA);
        list.add(TLS_DH_DSS_WITH_AES_128_GCM_SHA256);
        list.add(TLS_DH_DSS_WITH_CAMELLIA_128_CBC_SHA256);
        list.add(TLS_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA256);
        list.add(TLS_DH_anon_WITH_CAMELLIA_128_CBC_SHA256);
        list.add(TLS_DH_DSS_WITH_CAMELLIA_256_CBC_SHA256);
        list.add(TLS_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA256);
        list.add(TLS_DH_anon_WITH_CAMELLIA_256_CBC_SHA256);
        list.add(TLS_ECDH_anon_WITH_RC4_128_SHA);
        list.add(TLS_ECDH_anon_WITH_3DES_EDE_CBC_SHA);
        list.add(TLS_ECDH_anon_WITH_AES_128_CBC_SHA);
        list.add(TLS_ECDH_anon_WITH_AES_256_CBC_SHA);
        list.add(TLS_DH_DSS_WITH_ARIA_128_CBC_SHA256);
        list.add(TLS_DH_DSS_WITH_ARIA_256_CBC_SHA384);
        list.add(TLS_DH_RSA_WITH_ARIA_128_CBC_SHA256);
        list.add(TLS_DH_RSA_WITH_ARIA_256_CBC_SHA384);
        list.add(TLS_DHE_DSS_WITH_ARIA_128_CBC_SHA256);
        list.add(TLS_DHE_DSS_WITH_ARIA_256_CBC_SHA384);
        list.add(TLS_DHE_RSA_WITH_ARIA_128_CBC_SHA256);
        list.add(TLS_DHE_RSA_WITH_ARIA_256_CBC_SHA384);
        list.add(TLS_DH_anon_WITH_ARIA_128_CBC_SHA256);
        list.add(TLS_DH_anon_WITH_ARIA_256_CBC_SHA384);
        list.add(TLS_DHE_DSS_WITH_ARIA_128_GCM_SHA256);
        list.add(TLS_DHE_DSS_WITH_ARIA_256_GCM_SHA384);
        list.add(TLS_DH_DSS_WITH_ARIA_128_GCM_SHA256);
        list.add(TLS_DH_DSS_WITH_ARIA_256_GCM_SHA384);
        list.add(TLS_DH_anon_WITH_ARIA_128_GCM_SHA256);
        list.add(TLS_DH_anon_WITH_ARIA_256_GCM_SHA384);
        list.add(TLS_DHE_DSS_WITH_CAMELLIA_128_GCM_SHA256);
        list.add(TLS_DHE_DSS_WITH_CAMELLIA_256_GCM_SHA384);
        list.add(TLS_DH_DSS_WITH_CAMELLIA_128_GCM_SHA256);
        list.add(TLS_DH_DSS_WITH_CAMELLIA_256_GCM_SHA384);
        list.add(TLS_DH_anon_WITH_CAMELLIA_128_GCM_SHA256);
        list.add(TLS_DH_anon_WITH_CAMELLIA_256_GCM_SHA384);
        list.add(TLS_GOSTR341001_WITH_28147_CNT_IMIT);
        list.add(TLS_GOSTR341001_WITH_NULL_GOSTR3411);
        list.add(TLS_GOSTR341112_256_WITH_28147_CNT_IMIT);
        list.add(TLS_GOSTR341112_256_WITH_NULL_GOSTR3411);
        list.add(TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256);
        list.add(TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256);
        list.add(TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256);
        list.add(TLS_ECCPWD_WITH_AES_128_GCM_SHA256);
        list.add(TLS_ECCPWD_WITH_AES_256_GCM_SHA384);
        list.add(TLS_ECCPWD_WITH_AES_128_CCM_SHA256);
        list.add(TLS_ECCPWD_WITH_AES_256_CCM_SHA384);
        list.add(TLS_RSA_WITH_AES_128_CCM_8);
        list.add(TLS_RSA_WITH_AES_256_CCM_8);
        list.add(TLS_DHE_RSA_WITH_AES_128_CCM_8);
        list.add(TLS_DHE_RSA_WITH_AES_256_CCM_8);
        list.add(TLS_ECDHE_ECDSA_WITH_AES_128_CCM_8);
        list.add(TLS_ECDHE_ECDSA_WITH_AES_256_CCM_8);
        list.add(TLS_PSK_WITH_CHACHA20_POLY1305_SHA256);
        list.add(TLS_ECDHE_PSK_WITH_CHACHA20_POLY1305_SHA256);
        list.add(TLS_DHE_PSK_WITH_CHACHA20_POLY1305_SHA256);
        list.add(TLS_RSA_PSK_WITH_CHACHA20_POLY1305_SHA256);
        list.add(UNOFFICIAL_TLS_RSA_WITH_CHACHA20_POLY1305);
        list.add(UNOFFICIAL_TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256);
        list.add(UNOFFICIAL_TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256);
        list.add(UNOFFICIAL_TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256);
        list.add(UNOFFICIAL_TLS_DHE_PSK_WITH_CHACHA20_POLY1305_OLD);
        list.add(UNOFFICIAL_TLS_PSK_WITH_CHACHA20_POLY1305_OLD);
        list.add(UNOFFICIAL_TLS_ECDHE_PSK_WITH_CHACHA20_POLY1305_OLD);
        list.add(UNOFFICIAL_TLS_RSA_PSK_WITH_CHACHA20_POLY1305_OLD);
        list.add(TLS_NULL_WITH_NULL_NULL);
        return list;
    }

    public static List<CipherSuite> getEsniImplemented() {
        LinkedList<CipherSuite> list = new LinkedList<CipherSuite>();
        list.add(TLS_AES_128_GCM_SHA256);
        list.add(TLS_AES_256_GCM_SHA384);
        list.add(TLS_CHACHA20_POLY1305_SHA256);
        list.add(TLS_AES_128_CCM_SHA256);
        list.add(TLS_AES_128_CCM_8_SHA256);
        return list;
    }

    public static List<CipherSuite> getTls13CipherSuites() {
        LinkedList<CipherSuite> list = new LinkedList<CipherSuite>();
        list.add(TLS_AES_128_GCM_SHA256);
        list.add(TLS_AES_256_GCM_SHA384);
        list.add(TLS_CHACHA20_POLY1305_SHA256);
        list.add(TLS_AES_128_CCM_SHA256);
        list.add(TLS_AES_128_CCM_8_SHA256);
        return list;
    }

    public static List<CipherSuite> getImplementedTls13CipherSuites() {
        LinkedList<CipherSuite> list = new LinkedList<CipherSuite>();
        list.add(TLS_AES_128_GCM_SHA256);
        list.add(TLS_AES_256_GCM_SHA384);
        list.add(TLS_CHACHA20_POLY1305_SHA256);
        list.add(TLS_AES_128_CCM_SHA256);
        list.add(TLS_AES_128_CCM_8_SHA256);
        return list;
    }

    public static List<CipherSuite> getNotImplemented() {
        LinkedList<CipherSuite> notImplemented = new LinkedList<CipherSuite>();
        for (CipherSuite suite : CipherSuite.values()) {
            if (CipherSuite.getImplemented().contains((Object)suite)) continue;
            notImplemented.add(suite);
        }
        return notImplemented;
    }

    public boolean isTLS13() {
        return this.getByteValue()[0] == 19 && this.getByteValue()[1] != 0;
    }

    public boolean isImplemented() {
        return CipherSuite.getImplemented().contains((Object)this);
    }

    public boolean isSHA() {
        return this.name().endsWith("SHA");
    }

    public boolean isSHA256() {
        return this.name().contains("SHA256");
    }

    public boolean isChachaPoly() {
        return this.name().contains("CHACHA");
    }

    public boolean isSHA384() {
        return this.name().contains("SHA384");
    }

    public boolean isSHA512() {
        return this.name().contains("SHA512");
    }

    public boolean isECDSA() {
        return this.name().contains("ECDSA");
    }

    public boolean isAnon() {
        return this.name().contains("anon");
    }

    public boolean isNull() {
        return this.name().toLowerCase().contains("null");
    }

    public boolean isPWD() {
        return this.name().contains("PWD");
    }

    public boolean isWeak() {
        return this.isExport() || this.isExportSymmetricCipher() || this.isAnon() || this.isNull();
    }

    static {
        MAP = new HashMap<Integer, CipherSuite>();
        for (CipherSuite c : CipherSuite.values()) {
            MAP.put(c.value, c);
        }
        SSL3_SUPPORTED_CIPHERSUITES = Collections.unmodifiableSet(new HashSet<CipherSuite>(Arrays.asList(TLS_NULL_WITH_NULL_NULL, TLS_RSA_WITH_NULL_MD5, TLS_RSA_WITH_NULL_SHA, TLS_RSA_EXPORT_WITH_RC4_40_MD5, TLS_RSA_WITH_RC4_128_MD5, TLS_RSA_WITH_RC4_128_SHA, TLS_RSA_EXPORT_WITH_RC2_CBC_40_MD5, TLS_RSA_WITH_IDEA_CBC_SHA, TLS_RSA_EXPORT_WITH_DES40_CBC_SHA, TLS_RSA_WITH_DES_CBC_SHA, TLS_RSA_WITH_3DES_EDE_CBC_SHA, TLS_DH_DSS_EXPORT_WITH_DES40_CBC_SHA, TLS_DH_DSS_WITH_DES_CBC_SHA, TLS_DH_DSS_WITH_3DES_EDE_CBC_SHA, TLS_DH_RSA_EXPORT_WITH_DES40_CBC_SHA, TLS_DH_RSA_WITH_DES_CBC_SHA, TLS_DH_RSA_WITH_3DES_EDE_CBC_SHA, TLS_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA, TLS_DHE_DSS_WITH_DES_CBC_SHA, TLS_DHE_DSS_WITH_3DES_EDE_CBC_SHA, TLS_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA, TLS_DHE_RSA_WITH_DES_CBC_SHA, TLS_DHE_RSA_WITH_3DES_EDE_CBC_SHA, TLS_DH_anon_EXPORT_WITH_RC4_40_MD5, TLS_DH_anon_WITH_RC4_128_MD5, TLS_DH_anon_EXPORT_WITH_DES40_CBC_SHA, TLS_DH_anon_WITH_DES_CBC_SHA, TLS_DH_anon_WITH_3DES_EDE_CBC_SHA, TLS_ECCPWD_WITH_AES_128_CCM_SHA256, TLS_ECCPWD_WITH_AES_128_GCM_SHA256, TLS_ECCPWD_WITH_AES_256_CCM_SHA384, TLS_ECCPWD_WITH_AES_256_GCM_SHA384)));
    }
}

