/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.sample;

import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.reader.UniversalProjectReader;
import net.sf.mpxj.writer.ProjectWriter;
import net.sf.mpxj.writer.ProjectWriterUtility;

public final class MpxjConvert {
    public static void main(String[] stringArray) {
        try {
            if (stringArray.length != 2) {
                System.out.println("Usage: MpxjConvert <input file name> <output file name>");
            } else {
                MpxjConvert mpxjConvert = new MpxjConvert();
                mpxjConvert.process(stringArray[0], stringArray[1]);
            }
            System.exit(0);
        }
        catch (Exception exception) {
            System.out.println();
            System.out.print("Conversion Error: ");
            exception.printStackTrace(System.out);
            System.out.println();
            System.exit(1);
        }
    }

    public void process(String string, String string2) throws Exception {
        System.out.println("Reading input file started.");
        long l = System.currentTimeMillis();
        ProjectFile projectFile = this.readFile(string);
        long l2 = System.currentTimeMillis() - l;
        System.out.println("Reading input file completed in " + l2 + "ms.");
        System.out.println("Writing output file started.");
        l = System.currentTimeMillis();
        ProjectWriter projectWriter = ProjectWriterUtility.getProjectWriter(string2);
        projectWriter.write(projectFile, string2);
        l2 = System.currentTimeMillis() - l;
        System.out.println("Writing output completed in " + l2 + "ms.");
    }

    private ProjectFile readFile(String string) throws MPXJException {
        UniversalProjectReader universalProjectReader = new UniversalProjectReader();
        ProjectFile projectFile = universalProjectReader.read(string);
        if (projectFile == null) {
            throw new IllegalArgumentException("Unsupported file type");
        }
        return projectFile;
    }
}

