/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.tax.beans.customizer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.modules.xml.tax.beans.Lib;
import org.netbeans.modules.xml.tax.beans.customizer.AbstractTreeCustomizer;
import org.netbeans.modules.xml.tax.beans.customizer.Util;
import org.netbeans.modules.xml.tax.util.TAXUtil;
import org.netbeans.tax.TreeElement;
import org.netbeans.tax.TreeException;
import org.netbeans.tax.TreeNamedObjectMap;

public class TreeElementCustomizer
extends AbstractTreeCustomizer {
    private static final long serialVersionUID = -2086561604130767387L;
    private JLabel nameLabel;
    private JLabel tableLabel;
    private JTextField nameField;
    private JPanel attributeListPanel;
    private JPanel jPanel2;
    private JPanel jPanel1;
    private Component attributesCustomizer;

    public TreeElementCustomizer() {
        this.initComponents();
        this.nameLabel.setDisplayedMnemonic(Util.THIS.getChar("MNE_xmlName"));
        this.tableLabel.setDisplayedMnemonic(Util.THIS.getChar("MNE_element_attributelist_label"));
        this.initAccessibility();
    }

    protected final TreeElement getElement() {
        return (TreeElement)this.getTreeObject();
    }

    @Override
    protected final void safePropertyChange(PropertyChangeEvent pche) {
        super.safePropertyChange(pche);
        if (pche.getPropertyName().equals("tagName")) {
            this.updateNameComponent();
        }
    }

    protected final void updateElementName() {
        try {
            this.getElement().setQName(this.nameField.getText());
        }
        catch (TreeException exc) {
            this.updateNameComponent();
            TAXUtil.notifyTreeException(exc);
        }
    }

    protected final void updateNameComponent() {
        this.nameField.setText(this.getElement().getQName());
    }

    @Override
    protected final void initComponentValues() {
        this.updateNameComponent();
    }

    @Override
    protected void ownInitComponents() {
        TreeNamedObjectMap attributes = this.getElement().getAttributes();
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TreeElementCustomizer::ownInitComponents: attributes = " + attributes);
        }
        this.attributesCustomizer = Lib.getCustomizer(TreeElement.class, attributes, "attributes");
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TreeElementCustomizer::ownInitComponents: attributesCustomizer = " + this.attributesCustomizer);
        }
        if (this.attributesCustomizer != null) {
            this.attributeListPanel.add(this.attributesCustomizer, "Center");
        }
    }

    @Override
    protected void updateReadOnlyStatus(boolean editable) {
        this.nameField.setEditable(editable);
        if (this.attributesCustomizer != null) {
            this.attributesCustomizer.setEnabled(editable);
        }
    }

    private void initComponents() {
        this.nameLabel = new JLabel();
        this.nameField = new JTextField();
        this.jPanel2 = new JPanel();
        this.jPanel1 = new JPanel();
        this.tableLabel = new JLabel();
        this.attributeListPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(350, 230));
        this.nameLabel.setText(Util.THIS.getString("PROP_xmlName"));
        this.nameLabel.setLabelFor(this.nameField);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.nameLabel, gridBagConstraints);
        this.nameField.setColumns(20);
        this.nameField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreeElementCustomizer.this.nameFieldActionPerformed(evt);
            }
        });
        this.nameField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                TreeElementCustomizer.this.nameFieldFocusGained(evt);
            }

            @Override
            public void focusLost(FocusEvent evt) {
                TreeElementCustomizer.this.nameFieldFocusLost(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.add((Component)this.nameField, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.tableLabel.setText(Util.THIS.getString("TEXT_element_attributelist_label"));
        this.tableLabel.setLabelFor(this.attributeListPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        this.jPanel1.add((Component)this.tableLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.jPanel2.add((Component)this.jPanel1, gridBagConstraints);
        this.attributeListPanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel2.add((Component)this.attributeListPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel2, gridBagConstraints);
    }

    private void nameFieldFocusGained(FocusEvent evt) {
        if ("new".equals(this.getClientProperty("xml-edit-mode"))) {
            this.nameField.selectAll();
        }
    }

    private void nameFieldFocusLost(FocusEvent evt) {
        this.updateElementName();
    }

    private void nameFieldActionPerformed(ActionEvent evt) {
        this.updateElementName();
    }

    public void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_TreeElementCustomizer"));
        this.nameField.getAccessibleContext().setAccessibleDescription(Util.THIS.getString("ACSD_nameField7"));
    }
}

