/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.editor.indent;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.docker.editor.lexer.DockerfileTokenId;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.netbeans.spi.editor.typinghooks.TypedBreakInterceptor;
import org.openide.util.Pair;

public final class DockerfileTypedBreakInterceptor
implements TypedBreakInterceptor {
    DockerfileTypedBreakInterceptor() {
    }

    public boolean beforeInsert(TypedBreakInterceptor.Context context) throws BadLocationException {
        return false;
    }

    public void insert(TypedBreakInterceptor.MutableContext context) throws BadLocationException {
        int indent;
        Token token;
        int lineEnd;
        int offset;
        BaseDocument doc = (BaseDocument)context.getDocument();
        int lineStart = LineDocumentUtils.getLineStart((LineDocument)doc, (int)(offset = context.getCaretOffset()));
        if (lineStart == (lineEnd = LineDocumentUtils.getLineEnd((LineDocument)doc, (int)offset))) {
            return;
        }
        TokenSequence seq = TokenHierarchy.get((Document)doc).tokenSequence(DockerfileTokenId.language());
        if (seq == null) {
            return;
        }
        seq.move(offset);
        if (!seq.moveNext() && !seq.movePrevious()) {
            return;
        }
        int tokenEnd = seq.index();
        while ((token = seq.token()) != null && token.id() == DockerfileTokenId.WHITESPACE && seq.movePrevious()) {
        }
        boolean lineContinuation = this.isLineContinuation((Token<DockerfileTokenId>)token, offset - seq.offset());
        Pair<Integer, TokenSequence<DockerfileTokenId>> p = DockerfileTypedBreakInterceptor.findImportantLine((TokenSequence<DockerfileTokenId>)seq, doc, lineStart, tokenEnd);
        if (lineContinuation) {
            indent = IndentUtils.lineIndent((Document)doc, (int)((Integer)p.first()));
            if (((DockerfileTokenId)((TokenSequence)p.second()).token().id()).isKeyword()) {
                indent += IndentUtils.indentLevelSize((Document)doc);
            }
        } else {
            int kwOffset;
            token = ((TokenSequence)p.second()).token();
            indent = token.id() == DockerfileTokenId.WHITESPACE ? IndentUtils.lineIndent((Document)doc, (int)lineStart) : (!((DockerfileTokenId)token.id()).isKeyword() && token.id() != DockerfileTokenId.LINE_COMMENT ? ((kwOffset = DockerfileTypedBreakInterceptor.findPrevKeyword((TokenSequence<DockerfileTokenId>)((TokenSequence)p.second()))) != -1 ? IndentUtils.lineIndent((Document)doc, (int)kwOffset) : IndentUtils.lineIndent((Document)doc, (int)((Integer)p.first())) - IndentUtils.indentLevelSize((Document)doc)) : IndentUtils.lineIndent((Document)doc, (int)((Integer)p.first())));
        }
        StringBuilder sb = new StringBuilder("\n");
        sb.append(IndentUtils.createIndentString((Document)doc, (int)indent));
        context.setText(sb.toString(), 0, sb.length(), new int[0]);
    }

    public void afterInsert(TypedBreakInterceptor.Context context) throws BadLocationException {
    }

    public void cancelled(TypedBreakInterceptor.Context context) {
    }

    private boolean isLineContinuation(@NullAllowed Token<DockerfileTokenId> token, int offsetInToken) {
        if (token == null) {
            return false;
        }
        if (token.id() == DockerfileTokenId.ESCAPE) {
            return true;
        }
        return token.id() == DockerfileTokenId.STRING_LITERAL && TokenUtilities.endsWith((CharSequence)TokenUtilities.trim((CharSequence)token.text().subSequence(0, offsetInToken)), (CharSequence)"\\");
    }

    @NonNull
    private static Pair<Integer, TokenSequence<DockerfileTokenId>> findImportantLine(@NonNull TokenSequence<DockerfileTokenId> seq, @NonNull BaseDocument doc, int lineStart, int tokenEnd) {
        Token token;
        seq.move(lineStart);
        seq.moveNext();
        int newTokenEnd = seq.offset();
        while ((token = seq.token()) != null && token.id() == DockerfileTokenId.WHITESPACE) {
            if (seq.index() == tokenEnd) {
                int offset = lineStart - 1;
                if (offset < 0) {
                    return Pair.of((Object)lineStart, seq);
                }
                lineStart = LineDocumentUtils.getLineStart((LineDocument)doc, (int)offset);
                return DockerfileTypedBreakInterceptor.findImportantLine(seq, doc, lineStart, newTokenEnd);
            }
            if (seq.moveNext()) continue;
            break;
        }
        return Pair.of((Object)lineStart, seq);
    }

    private static int findPrevKeyword(@NonNull TokenSequence<DockerfileTokenId> seq) {
        Token token;
        while ((token = seq.token()) != null && !((DockerfileTokenId)token.id()).isKeyword() && seq.movePrevious()) {
        }
        return token != null && ((DockerfileTokenId)token.id()).isKeyword() ? seq.offset() : -1;
    }

    public static final class Factory
    implements TypedBreakInterceptor.Factory {
        public TypedBreakInterceptor createTypedBreakInterceptor(MimePath mimePath) {
            return new DockerfileTypedBreakInterceptor();
        }
    }
}

