/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetVnicRequest
extends BmcRequest<Void> {
    private String vnicId;

    public String getVnicId() {
        return this.vnicId;
    }

    public Builder toBuilder() {
        return new Builder().vnicId(this.vnicId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",vnicId=").append(String.valueOf(this.vnicId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetVnicRequest)) {
            return false;
        }
        GetVnicRequest other = (GetVnicRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.vnicId, other.vnicId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.vnicId == null ? 43 : this.vnicId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetVnicRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String vnicId = null;

        public Builder vnicId(String vnicId) {
            this.vnicId = vnicId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetVnicRequest o) {
            this.vnicId(o.getVnicId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetVnicRequest build() {
            GetVnicRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetVnicRequest buildWithoutInvocationCallback() {
            GetVnicRequest request = new GetVnicRequest();
            request.vnicId = this.vnicId;
            return request;
        }
    }
}

