/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.palette.items;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.html.palette.BrowseFolders;
import org.netbeans.modules.html.palette.HtmlPaletteUtilities;
import org.netbeans.modules.html.palette.items.IMG;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class IMGCustomizer
extends JPanel {
    private Dialog dialog = null;
    private DialogDescriptor descriptor = null;
    private boolean dialogOK = false;
    IMG img;
    JTextComponent target;
    private JButton jButton1;
    private JFileChooser jFileChooser1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JTextField jTextField1;
    private JTextField jTextField2;
    private JTextField jTextField3;
    private JTextField jTextField4;

    public IMGCustomizer(IMG img, JTextComponent target) {
        this.img = img;
        this.target = target;
        this.initComponents();
        this.jFileChooser1.setAcceptAllFileFilterUsed(false);
        this.jFileChooser1.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                FileObject fo = FileUtil.toFileObject((File)pathname);
                return pathname.isDirectory() || fo != null && fo.getMIMEType().startsWith("image/");
            }

            @Override
            public String getDescription() {
                String desc = NbBundle.getMessage(IMGCustomizer.class, (String)"LBL_IMG_FileChooserDesc");
                return desc;
            }
        });
    }

    public boolean showDialog() {
        this.dialogOK = false;
        String displayName = "";
        try {
            displayName = NbBundle.getBundle((String)"org.netbeans.modules.html.palette.items.resources.Bundle").getString("NAME_html-IMG");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.descriptor = new DialogDescriptor((Object)this, NbBundle.getMessage(IMGCustomizer.class, (String)"LBL_Customizer_InsertPrefix") + " " + displayName, true, 2, DialogDescriptor.OK_OPTION, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (IMGCustomizer.this.descriptor.getValue().equals(DialogDescriptor.OK_OPTION)) {
                    IMGCustomizer.this.evaluateInput();
                    IMGCustomizer.this.dialogOK = true;
                }
                IMGCustomizer.this.dialog.dispose();
            }
        });
        this.dialog = DialogDisplayer.getDefault().createDialog(this.descriptor);
        this.dialog.setVisible(true);
        this.repaint();
        return this.dialogOK;
    }

    private void evaluateInput() {
        String loc = this.jTextField1.getText();
        this.img.setLocation(loc);
        String width = this.jTextField2.getText();
        this.img.setWidth(width);
        String height = this.jTextField3.getText();
        this.img.setHeight(height);
        String alt = this.jTextField4.getText();
        this.img.setAlttext(alt);
    }

    private void initComponents() {
        this.jFileChooser1 = new JFileChooser();
        this.jLabel4 = new JLabel();
        this.jTextField1 = new JTextField();
        this.jButton1 = new JButton();
        this.jTextField2 = new JTextField();
        this.jTextField3 = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jTextField4 = new JTextField();
        this.jFileChooser1.setCurrentDirectory(null);
        this.setLayout(new GridBagLayout());
        this.jLabel4.setLabelFor(this.jTextField4);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(IMGCustomizer.class, (String)"LBL_IMG_Alt"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 12, 0);
        this.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel4.getAccessibleContext().setAccessibleName(NbBundle.getMessage(IMGCustomizer.class, (String)"ACSN_IMG_Alt"));
        this.jLabel4.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IMGCustomizer.class, (String)"ACSD_IMG_Alt"));
        this.jTextField1.setColumns(30);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.jTextField1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(IMGCustomizer.class, (String)"LBL_IMG_Browse"));
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IMGCustomizer.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        this.add((Component)this.jButton1, gridBagConstraints);
        this.jButton1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(IMGCustomizer.class, (String)"ACSN_IMG_Browse"));
        this.jButton1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IMGCustomizer.class, (String)"ACSD_IMG_Browse"));
        this.jTextField2.setColumns(10);
        this.jTextField2.setMinimumSize(new Dimension(100, 19));
        this.jTextField2.setPreferredSize(new Dimension(100, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.jTextField2, gridBagConstraints);
        this.jTextField3.setColumns(10);
        this.jTextField3.setMinimumSize(new Dimension(100, 19));
        this.jTextField3.setPreferredSize(new Dimension(100, 19));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.add((Component)this.jTextField3, gridBagConstraints);
        this.jLabel1.setLabelFor(this.jTextField1);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(IMGCustomizer.class, (String)"LBL_IMG_Location"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel1.getAccessibleContext().setAccessibleName(NbBundle.getMessage(IMGCustomizer.class, (String)"ACSN_IMG_Location"));
        this.jLabel1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IMGCustomizer.class, (String)"ACSD_IMG_Location"));
        this.jLabel2.setLabelFor(this.jTextField2);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(IMGCustomizer.class, (String)"LBL_IMG_Width"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel2.getAccessibleContext().setAccessibleName(NbBundle.getMessage(IMGCustomizer.class, (String)"ACSN_IMG_Width"));
        this.jLabel2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IMGCustomizer.class, (String)"ACSD_IMG_Width"));
        this.jLabel3.setLabelFor(this.jTextField3);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(IMGCustomizer.class, (String)"LBL_IMG_Height"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel3.getAccessibleContext().setAccessibleName(NbBundle.getMessage(IMGCustomizer.class, (String)"ACSN_IMG_Height"));
        this.jLabel3.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IMGCustomizer.class, (String)"ACSD_IMG_Height"));
        this.jTextField4.setColumns(30);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 12, 0);
        this.add((Component)this.jTextField4, gridBagConstraints);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        Document targetDoc = this.target.getDocument();
        FileObject targetDocFO = NbEditorUtilities.getFileObject((Document)targetDoc);
        SourceGroup[] sg = HtmlPaletteUtilities.getSourceGroups(targetDocFO);
        File file = null;
        if (sg.length > 0) {
            FileObject fo = BrowseFolders.showDialog(sg, BrowseFolders.imageFileFilter);
            if (fo != null) {
                file = FileUtil.toFile((FileObject)fo);
            }
        } else {
            this.jFileChooser1.setCurrentDirectory(FileUtil.toFile((FileObject)targetDocFO.getParent()));
            int returnVal = this.jFileChooser1.showOpenDialog(this);
            if (returnVal == 0) {
                file = this.jFileChooser1.getSelectedFile();
            }
        }
        if (file != null) {
            String path = file.getAbsolutePath();
            FileObject imgFO = FileUtil.toFileObject((File)file);
            try {
                String relPathToImg = HtmlPaletteUtilities.getRelativePath(targetDocFO, imgFO);
                if (relPathToImg.length() > 0) {
                    path = relPathToImg;
                }
            }
            catch (Exception relPathToImg) {
                // empty catch block
            }
            this.jTextField1.setText(path);
            try {
                Image img = new ImageIcon(file.getAbsolutePath()).getImage();
                int width = img.getWidth(null);
                this.jTextField2.setText(width != -1 ? Integer.valueOf(width).toString() : "");
                int height = img.getHeight(null);
                this.jTextField3.setText(height != -1 ? Integer.valueOf(height).toString() : "");
                this.jTextField4.setText(imgFO.getName());
            }
            catch (Exception ex) {
                Logger.getLogger("global").log(Level.INFO, null, ex);
            }
        }
    }
}

