/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.environment;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.php.project.environment.PhpEnvironment;
import org.netbeans.modules.php.project.environment.SolarisPhpEnvironment;
import org.openide.util.NbBundle;

final class UnixPhpEnvironment
extends PhpEnvironment {
    private static final String PHP = "php";

    UnixPhpEnvironment() {
    }

    @Override
    @SuppressWarnings(value={"DMI_HARDCODED_ABSOLUTE_FILENAME"})
    protected List<PhpEnvironment.DocumentRoot> getDocumentRoots(String projectName) {
        ArrayList<PhpEnvironment.DocumentRoot> roots = new ArrayList<PhpEnvironment.DocumentRoot>(2);
        PhpEnvironment.DocumentRoot userPublicHtml = UnixPhpEnvironment.getUserPublicHtmlDocumentRoot(projectName);
        if (userPublicHtml != null) {
            roots.add(userPublicHtml);
        }
        File www = new File("/var/www");
        File wwwLocalhost = new File(www, "localhost");
        String documentRoot = null;
        boolean canWrite = false;
        if (wwwLocalhost.isDirectory()) {
            documentRoot = UnixPhpEnvironment.getFolderName(wwwLocalhost, projectName);
            canWrite = wwwLocalhost.canWrite();
        } else if (www.isDirectory()) {
            documentRoot = UnixPhpEnvironment.getFolderName(www, projectName);
            canWrite = www.canWrite();
        }
        if (documentRoot != null) {
            String url = UnixPhpEnvironment.getDefaultUrl(projectName);
            String hint = NbBundle.getMessage(SolarisPhpEnvironment.class, (String)"TXT_HtDocs");
            roots.add(new PhpEnvironment.DocumentRoot(documentRoot, url, hint, roots.isEmpty() && canWrite));
        }
        if (!roots.isEmpty()) {
            return roots;
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> getAllPhpInterpreters() {
        return UnixPhpEnvironment.getAllPhpInterpreters(PHP);
    }
}

