/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.load_management;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.videobridge.load_management.JvbLoadMeasurement;
import org.jitsi.videobridge.load_management.PacketRateMeasurementConfig;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0011\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0001H\u0096\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jitsi/videobridge/load_management/PacketRateMeasurement;", "Lorg/jitsi/videobridge/load_management/JvbLoadMeasurement;", "packetRate", "", "<init>", "(J)V", "getLoad", "", "div", "other", "toString", "", "Companion", "jitsi-videobridge"})
public final class PacketRateMeasurement
implements JvbLoadMeasurement {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long packetRate;
    @NotNull
    private static final PacketRateMeasurementConfig config = new PacketRateMeasurementConfig();
    @NotNull
    private static final PacketRateMeasurement loadedThreshold = config.getLoadThreshold();
    @NotNull
    private static final PacketRateMeasurement recoveryThreshold = config.getRecoverThreshold();

    public PacketRateMeasurement(long packetRate) {
        this.packetRate = packetRate;
    }

    @Override
    public double getLoad() {
        return this.packetRate;
    }

    @Override
    public double div(@NotNull JvbLoadMeasurement other) {
        Intrinsics.checkNotNullParameter(other, "other");
        if (!(other instanceof PacketRateMeasurement)) {
            throw new UnsupportedOperationException("Can only divide load measurements of same type");
        }
        return (double)this.packetRate / (double)((PacketRateMeasurement)other).packetRate;
    }

    @NotNull
    public String toString() {
        return "RTP packet rate (up + down) of " + this.packetRate + " pps";
    }

    @NotNull
    public static final PacketRateMeasurement getLoadedThreshold() {
        return Companion.getLoadedThreshold();
    }

    @NotNull
    public static final PacketRateMeasurement getRecoveryThreshold() {
        return Companion.getRecoveryThreshold();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\b\u0010\u0003\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\u0003\u001a\u0004\b\r\u0010\n\u00a8\u0006\u000e"}, d2={"Lorg/jitsi/videobridge/load_management/PacketRateMeasurement$Companion;", "", "<init>", "()V", "config", "Lorg/jitsi/videobridge/load_management/PacketRateMeasurementConfig;", "loadedThreshold", "Lorg/jitsi/videobridge/load_management/PacketRateMeasurement;", "getLoadedThreshold$annotations", "getLoadedThreshold", "()Lorg/jitsi/videobridge/load_management/PacketRateMeasurement;", "recoveryThreshold", "getRecoveryThreshold$annotations", "getRecoveryThreshold", "jitsi-videobridge"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PacketRateMeasurement getLoadedThreshold() {
            return loadedThreshold;
        }

        @JvmStatic
        public static /* synthetic */ void getLoadedThreshold$annotations() {
        }

        @NotNull
        public final PacketRateMeasurement getRecoveryThreshold() {
            return recoveryThreshold;
        }

        @JvmStatic
        public static /* synthetic */ void getRecoveryThreshold$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

