/*
 * Decompiled with CFR 0.152.
 */
package sunw.demo.searchdemo;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import sunw.demo.searchdemo.WordInventory;

public class Word {
    protected String word;
    protected Vector wordInventory;

    public Word(String string) {
        this.word = string;
        this.wordInventory = new Vector();
    }

    public Word(DataInputStream dataInputStream) throws IOException {
        char c;
        StringBuffer stringBuffer = new StringBuffer();
        while ((c = dataInputStream.readChar()) != '\u0000') {
            stringBuffer.append(c);
        }
        this.word = new String(stringBuffer);
        int n = dataInputStream.readShort();
        this.wordInventory = new Vector(n);
        for (int i = 0; i < n; ++i) {
            this.wordInventory.addElement(new WordInventory(dataInputStream, this));
        }
    }

    public void writeWord(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeChars(this.word);
        dataOutputStream.writeChar(0);
        dataOutputStream.writeShort(this.wordInventory.size());
        for (int i = 0; i < this.wordInventory.size(); ++i) {
            ((WordInventory)this.wordInventory.elementAt(i)).writeWordInventory(dataOutputStream);
        }
    }

    public void augmentWordInventory(short s, short s2, short s3, short s4) {
        for (int i = 0; i < this.wordInventory.size(); ++i) {
            WordInventory wordInventory = (WordInventory)this.wordInventory.elementAt(i);
            if (wordInventory.getDocId() != s) continue;
            wordInventory.updateInventory(s2, s3, s4);
            return;
        }
        this.wordInventory.addElement(new WordInventory(s, s2, s3, s4, this));
    }

    public void addWordInventory(short s, Word word) {
        this.wordInventory.addElement(new WordInventory(s, word));
    }

    public String getWord() {
        return this.word;
    }

    public Vector getWordInventory() {
        return this.wordInventory;
    }

    public Vector AndIntersection(Vector vector) {
        Vector<WordInventory> vector2 = new Vector<WordInventory>();
        block0: for (int i = 0; i < vector.size(); ++i) {
            WordInventory wordInventory = (WordInventory)vector.elementAt(i);
            for (int j = 0; j < this.wordInventory.size(); ++j) {
                WordInventory wordInventory2 = (WordInventory)this.wordInventory.elementAt(j);
                if (wordInventory2.docId != wordInventory.docId) continue;
                vector2.addElement(wordInventory2);
                vector2.addElement(wordInventory);
                continue block0;
            }
        }
        return vector2;
    }

    public Vector OrIntersection(Vector vector) {
        WordInventory wordInventory;
        int n;
        Vector<WordInventory> vector2 = new Vector<WordInventory>();
        for (n = 0; n < vector.size(); ++n) {
            wordInventory = (WordInventory)vector.elementAt(n);
            vector2.addElement(wordInventory);
        }
        for (n = 0; n < this.wordInventory.size(); ++n) {
            wordInventory = (WordInventory)this.wordInventory.elementAt(n);
            vector2.addElement(wordInventory);
        }
        return vector2;
    }

    public Vector NotIntersection(Vector vector) {
        Vector<WordInventory> vector2 = new Vector<WordInventory>();
        for (int i = 0; i < vector.size(); ++i) {
            WordInventory wordInventory = (WordInventory)vector.elementAt(i);
            boolean bl = true;
            for (int j = 0; j < this.wordInventory.size(); ++j) {
                WordInventory wordInventory2 = (WordInventory)this.wordInventory.elementAt(j);
                if (wordInventory2.docId != wordInventory.docId) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            vector2.addElement(wordInventory);
        }
        return vector2;
    }

    public Vector NearWord(Vector vector, int n) {
        Vector<WordInventory> vector2 = new Vector<WordInventory>();
        for (int i = 0; i < vector.size(); ++i) {
            WordInventory wordInventory = (WordInventory)vector.elementAt(i);
            block1: for (int j = 0; j < this.wordInventory.size(); ++j) {
                int n2;
                int n3;
                WordInventory wordInventory2 = (WordInventory)this.wordInventory.elementAt(j);
                if (wordInventory2.docId != wordInventory.docId) continue;
                int n4 = 0;
                int n5 = 0;
                do {
                    if (Math.abs((n3 = ((Short)wordInventory2.wordPos.elementAt(n5)).intValue()) - (n2 = ((Short)wordInventory.wordPos.elementAt(n4)).intValue())) > n) continue;
                    vector2.addElement(wordInventory2);
                    vector2.addElement(wordInventory);
                    continue block1;
                } while (!(Math.min(n3, n2) == n3 ? wordInventory2.wordPos.size() == ++n5 : wordInventory.wordPos.size() == ++n4));
            }
        }
        return vector2;
    }

    public String toString() {
        String string = new String("Word: " + this.word);
        for (int i = 0; i < this.wordInventory.size(); ++i) {
            string = string.concat(((WordInventory)this.wordInventory.elementAt(i)).toString());
        }
        return string;
    }
}

