/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.compilerapi.deps;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.internal.tasks.compile.incremental.compilerapi.deps.GeneratedResource;

public abstract class DependentsSet {
    public static DependentsSet dependentClasses(Set<String> privateDependentClasses, Set<String> accessibleDependentClasses) {
        return DependentsSet.dependents(privateDependentClasses, accessibleDependentClasses, Collections.emptySet());
    }

    public static DependentsSet dependents(Set<String> privateDependentClasses, Set<String> accessibleDependentClasses, Set<GeneratedResource> dependentResources) {
        if (privateDependentClasses.isEmpty() && accessibleDependentClasses.isEmpty() && dependentResources.isEmpty()) {
            return DependentsSet.empty();
        }
        return new DefaultDependentsSet((Set)ImmutableSet.copyOf(privateDependentClasses), (Set)ImmutableSet.copyOf(accessibleDependentClasses), (Set)ImmutableSet.copyOf(dependentResources));
    }

    public static DependentsSet dependencyToAll(String reason) {
        return new DependencyToAll(reason);
    }

    public static DependentsSet empty() {
        return EmptyDependentsSet.INSTANCE;
    }

    public static DependentsSet merge(Collection<DependentsSet> sets) {
        if (sets.isEmpty()) {
            return DependentsSet.empty();
        }
        if (sets.size() == 1) {
            return sets.iterator().next();
        }
        int privateCount = 0;
        int accessibleCount = 0;
        int resourceCount = 0;
        for (DependentsSet set : sets) {
            if (set.isDependencyToAll()) {
                return set;
            }
            privateCount += set.getPrivateDependentClasses().size();
            accessibleCount += set.getAccessibleDependentClasses().size();
            resourceCount += set.getDependentResources().size();
        }
        ImmutableSet.Builder privateDependentClasses = ImmutableSet.builderWithExpectedSize((int)privateCount);
        ImmutableSet.Builder accessibleDependentClasses = ImmutableSet.builderWithExpectedSize((int)accessibleCount);
        ImmutableSet.Builder dependentResources = ImmutableSet.builderWithExpectedSize((int)resourceCount);
        for (DependentsSet set : sets) {
            privateDependentClasses.addAll(set.getPrivateDependentClasses());
            accessibleDependentClasses.addAll(set.getAccessibleDependentClasses());
            dependentResources.addAll(set.getDependentResources());
        }
        return DependentsSet.dependents((Set<String>)privateDependentClasses.build(), (Set<String>)accessibleDependentClasses.build(), (Set<GeneratedResource>)dependentResources.build());
    }

    public abstract boolean isEmpty();

    public abstract boolean hasDependentClasses();

    public abstract Set<String> getPrivateDependentClasses();

    public abstract Set<String> getAccessibleDependentClasses();

    public abstract Set<GeneratedResource> getDependentResources();

    public abstract boolean isDependencyToAll();

    public abstract String getDescription();

    private DependentsSet() {
    }

    public abstract Set<String> getAllDependentClasses();

    private static class DefaultDependentsSet
    extends DependentsSet {
        private final Set<String> privateDependentClasses;
        private final Set<String> accessibleDependentClasses;
        private final Set<GeneratedResource> dependentResources;

        private DefaultDependentsSet(Set<String> privateDependentClasses, Set<String> accessibleDependentClasses, Set<GeneratedResource> dependentResources) {
            this.privateDependentClasses = privateDependentClasses;
            this.accessibleDependentClasses = accessibleDependentClasses;
            this.dependentResources = dependentResources;
        }

        @Override
        public boolean isEmpty() {
            return !this.hasDependentClasses() && this.dependentResources.isEmpty();
        }

        @Override
        public boolean hasDependentClasses() {
            return !this.privateDependentClasses.isEmpty() || !this.accessibleDependentClasses.isEmpty();
        }

        @Override
        public Set<String> getPrivateDependentClasses() {
            return this.privateDependentClasses;
        }

        @Override
        public Set<String> getAccessibleDependentClasses() {
            return this.accessibleDependentClasses;
        }

        @Override
        public Set<String> getAllDependentClasses() {
            if (this.privateDependentClasses.isEmpty()) {
                return this.accessibleDependentClasses;
            }
            if (this.accessibleDependentClasses.isEmpty()) {
                return this.privateDependentClasses;
            }
            HashSet<String> r = new HashSet<String>(this.accessibleDependentClasses);
            r.addAll(this.privateDependentClasses);
            return r;
        }

        @Override
        public Set<GeneratedResource> getDependentResources() {
            return this.dependentResources;
        }

        @Override
        public boolean isDependencyToAll() {
            return false;
        }

        @Override
        public String getDescription() {
            throw new UnsupportedOperationException("This dependents does not have a problem description.");
        }
    }

    private static class DependencyToAll
    extends DependentsSet {
        private final String reason;

        private DependencyToAll(String reason) {
            this.reason = (String)Preconditions.checkNotNull((Object)reason);
        }

        private DependencyToAll() {
            this((String)null);
        }

        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException("This dependents set does not have dependent classes information.");
        }

        @Override
        public boolean hasDependentClasses() {
            throw new UnsupportedOperationException("This dependents set does not have dependent classes information.");
        }

        @Override
        public Set<String> getPrivateDependentClasses() {
            throw new UnsupportedOperationException("This dependents set does not have dependent classes information.");
        }

        @Override
        public Set<String> getAccessibleDependentClasses() {
            throw new UnsupportedOperationException("This dependents set does not have dependent classes information.");
        }

        @Override
        public Set<String> getAllDependentClasses() {
            throw new UnsupportedOperationException("This dependents set does not have dependent classes information.");
        }

        @Override
        public Set<GeneratedResource> getDependentResources() {
            throw new UnsupportedOperationException("This dependents set does not have dependent resources information.");
        }

        @Override
        public boolean isDependencyToAll() {
            return true;
        }

        @Override
        public String getDescription() {
            return this.reason;
        }
    }

    private static class EmptyDependentsSet
    extends DependentsSet {
        private static final EmptyDependentsSet INSTANCE = new EmptyDependentsSet();

        private EmptyDependentsSet() {
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean hasDependentClasses() {
            return false;
        }

        @Override
        public Set<String> getPrivateDependentClasses() {
            return Collections.emptySet();
        }

        @Override
        public Set<String> getAccessibleDependentClasses() {
            return Collections.emptySet();
        }

        @Override
        public Set<String> getAllDependentClasses() {
            return Collections.emptySet();
        }

        @Override
        public Set<GeneratedResource> getDependentResources() {
            return Collections.emptySet();
        }

        @Override
        public boolean isDependencyToAll() {
            return false;
        }

        @Override
        public String getDescription() {
            throw new UnsupportedOperationException("This dependents does not have a problem description.");
        }
    }
}

