/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.profile;

import ca.sqlpower.architect.profile.ColumnProfileResult;
import ca.sqlpower.object.AbstractSPObject;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.annotation.Accessor;
import ca.sqlpower.object.annotation.Constructor;
import ca.sqlpower.object.annotation.ConstructorParameter;
import ca.sqlpower.object.annotation.Mutator;
import ca.sqlpower.swingui.table.TableModelSortDecorator;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ColumnValueCount
extends AbstractSPObject {
    public static final List<Class<? extends SPObject>> allowedChildTypes = Collections.emptyList();
    public static final String OTHER_VALUE_OBJECT = "Other Values";
    private final Object value;
    private final int count;
    private final double percent;
    private final boolean otherValues;

    @Constructor
    public ColumnValueCount(@ConstructorParameter(propertyName="value") Object value, @ConstructorParameter(propertyName="count") int count, @ConstructorParameter(propertyName="percent") double percent, @ConstructorParameter(propertyName="otherValues") boolean otherValues) {
        this.setName("New Column Value Count");
        this.count = count;
        this.percent = percent;
        if (otherValues && !value.equals(OTHER_VALUE_OBJECT)) {
            throw new IllegalArgumentException("The other values object should equal the static value in this class.");
        }
        this.value = otherValues ? OTHER_VALUE_OBJECT : value;
        this.otherValues = otherValues;
    }

    public ColumnValueCount(ColumnValueCount cvcToCopy) {
        this.setName(cvcToCopy.getName());
        this.value = cvcToCopy.value;
        this.count = cvcToCopy.count;
        this.percent = cvcToCopy.percent;
        this.otherValues = cvcToCopy.isOtherValues();
    }

    @Accessor
    public int getCount() {
        return this.count;
    }

    @Accessor
    public Object getValue() {
        return this.value;
    }

    @Accessor
    public double getPercent() {
        return this.percent;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ColumnValueCount)) {
            return false;
        }
        ColumnValueCount other = (ColumnValueCount)((Object)obj);
        return (this.value == null ? other.value == null : this.value.equals(other.value)) && this.count == other.count && this.percent == other.percent;
    }

    public int hashCode() {
        int result = 17;
        if (this.value != null) {
            result = 37 * result + this.value.hashCode();
        }
        result = 37 * result + this.count;
        return result;
    }

    protected boolean removeChildImpl(SPObject child) {
        return false;
    }

    public List<Class<? extends SPObject>> getAllowedChildTypes() {
        return Collections.emptyList();
    }

    public List<? extends SPObject> getChildren() {
        return Collections.emptyList();
    }

    public List<? extends SPObject> getDependencies() {
        return Collections.emptyList();
    }

    public void removeDependency(SPObject dependency) {
    }

    @Accessor
    public ColumnProfileResult getParent() {
        return (ColumnProfileResult)super.getParent();
    }

    @Mutator
    public void setParent(SPObject parent) {
        if (!(parent instanceof ColumnProfileResult) && parent != null) {
            throw new IllegalArgumentException("The parent of " + (Object)((Object)this) + " must be a " + ColumnProfileResult.class + " object.");
        }
        super.setParent(parent);
    }

    @Accessor
    public boolean isOtherValues() {
        return this.otherValues;
    }

    public static class ColumnValueComparator
    implements Comparator<Object> {
        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof String && ColumnValueCount.OTHER_VALUE_OBJECT.equals((String)o1)) {
                return 1;
            }
            if (o2 instanceof String && ColumnValueCount.OTHER_VALUE_OBJECT.equals((String)o2)) {
                return -1;
            }
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            if (o1.getClass().equals(o2.getClass()) && Comparable.class.isAssignableFrom(o1.getClass())) {
                return TableModelSortDecorator.COMPARABLE_COMAPRATOR.compare(o1, o2);
            }
            return TableModelSortDecorator.LEXICAL_COMPARATOR.compare(o1, o2);
        }
    }
}

