/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.security.GeneralSecurityException;
import java.security.Principal;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.crypto.SecretKey;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.scandium.auth.PrincipalSerializer;
import org.eclipse.californium.scandium.dtls.CompressionMethod;
import org.eclipse.californium.scandium.dtls.ProtocolVersion;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.util.SecretUtil;
import org.eclipse.californium.scandium.util.ServerNames;

public final class SessionTicket
implements Destroyable {
    private final int hashCode;
    private final ProtocolVersion protocolVersion;
    private final SecretKey masterSecret;
    private final CipherSuite cipherSuite;
    private final CompressionMethod compressionMethod;
    private final ServerNames serverNames;
    private final Principal clientIdentity;
    private final long timestampMillis;

    SessionTicket(ProtocolVersion protocolVersion, CipherSuite cipherSuite, CompressionMethod compressionMethod, SecretKey masterSecret, ServerNames serverNames, Principal clientIdentity, long timestampMillis) {
        if (protocolVersion == null) {
            throw new NullPointerException("Protcol version must not be null");
        }
        if (cipherSuite == null) {
            throw new NullPointerException("Cipher suite must not be null");
        }
        if (compressionMethod == null) {
            throw new NullPointerException("Compression method must not be null");
        }
        if (masterSecret == null) {
            throw new NullPointerException("Master secret must not be null");
        }
        this.protocolVersion = protocolVersion;
        this.masterSecret = SecretUtil.create(masterSecret);
        this.cipherSuite = cipherSuite;
        this.compressionMethod = compressionMethod;
        this.serverNames = serverNames;
        this.clientIdentity = clientIdentity;
        this.timestampMillis = timestampMillis;
        this.hashCode = this.masterSecret.hashCode();
    }

    public void encode(DatagramWriter writer) {
        writer.write(this.protocolVersion.getMajor(), 8);
        writer.write(this.protocolVersion.getMinor(), 8);
        writer.write(this.cipherSuite.getCode(), 16);
        writer.write(this.compressionMethod.getCode(), 8);
        byte[] secret = this.masterSecret.getEncoded();
        writer.writeBytes(secret);
        Bytes.clear((byte[])secret);
        PrincipalSerializer.serialize(this.clientIdentity, writer);
        writer.writeLong(TimeUnit.MILLISECONDS.toSeconds(this.timestampMillis), 32);
        if (this.serverNames != null) {
            this.serverNames.encode(writer);
        }
    }

    public static SessionTicket decode(DatagramReader source) {
        if (source == null) {
            throw new NullPointerException("reader must not be null");
        }
        int major = source.read(8);
        int minor = source.read(8);
        ProtocolVersion ver = ProtocolVersion.valueOf(major, minor);
        CipherSuite cipherSuite = CipherSuite.getTypeByCode(source.read(16));
        if (cipherSuite == null) {
            return null;
        }
        CompressionMethod compressionMethod = CompressionMethod.getMethodByCode(source.read(8));
        if (compressionMethod == null) {
            return null;
        }
        byte[] secret = source.readBytes(48);
        SecretKey masterSecret = SecretUtil.create(secret, "MAC");
        Bytes.clear((byte[])secret);
        Principal identity = null;
        try {
            identity = PrincipalSerializer.deserialize(source);
        }
        catch (GeneralSecurityException e) {
            return null;
        }
        long timestampMillis = TimeUnit.SECONDS.toMillis(source.readLong(32));
        ServerNames serverNames = null;
        if (source.bytesAvailable()) {
            serverNames = ServerNames.newInstance();
            try {
                serverNames.decode(source);
            }
            catch (IllegalArgumentException e) {
                serverNames = null;
            }
        }
        SessionTicket ticket = new SessionTicket(ver, cipherSuite, compressionMethod, masterSecret, serverNames, identity, timestampMillis);
        SecretUtil.destroy(masterSecret);
        return ticket;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        byte[] secret2;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SessionTicket other = (SessionTicket)obj;
        if (this.hashCode != other.hashCode) {
            return false;
        }
        byte[] secret1 = this.masterSecret.getEncoded();
        if (!Arrays.equals(secret1, secret2 = other.masterSecret.getEncoded())) {
            Bytes.clear((byte[])secret1);
            Bytes.clear((byte[])secret2);
            return false;
        }
        Bytes.clear((byte[])secret1);
        Bytes.clear((byte[])secret2);
        if (!this.protocolVersion.equals(other.protocolVersion)) {
            return false;
        }
        if (!this.cipherSuite.equals((Object)other.cipherSuite)) {
            return false;
        }
        if (!this.compressionMethod.equals((Object)other.compressionMethod)) {
            return false;
        }
        if (!this.clientIdentity.equals(other.clientIdentity)) {
            return false;
        }
        return this.timestampMillis == other.timestampMillis;
    }

    @Override
    public void destroy() throws DestroyFailedException {
        SecretUtil.destroy(this.masterSecret);
    }

    @Override
    public boolean isDestroyed() {
        return SecretUtil.isDestroyed(this.masterSecret);
    }

    public final ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    public final SecretKey getMasterSecret() {
        return this.masterSecret;
    }

    public final CipherSuite getCipherSuite() {
        return this.cipherSuite;
    }

    public final CompressionMethod getCompressionMethod() {
        return this.compressionMethod;
    }

    public final ServerNames getServerNames() {
        return this.serverNames;
    }

    public final Principal getClientIdentity() {
        return this.clientIdentity;
    }

    public final long getTimestamp() {
        return this.timestampMillis;
    }
}

