/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.consumer.internals.FetchMetricsManager;
import org.apache.kafka.common.TopicPartition;

class FetchMetricsAggregator {
    private final FetchMetricsManager metricsManager;
    private final Set<TopicPartition> unrecordedPartitions;
    private final FetchMetrics fetchFetchMetrics = new FetchMetrics();
    private final Map<String, FetchMetrics> perTopicFetchMetrics = new HashMap<String, FetchMetrics>();

    FetchMetricsAggregator(FetchMetricsManager metricsManager, Set<TopicPartition> partitions) {
        this.metricsManager = metricsManager;
        this.unrecordedPartitions = new HashSet<TopicPartition>(partitions);
    }

    void record(TopicPartition partition, int bytes, int records) {
        this.fetchFetchMetrics.increment(bytes, records);
        this.perTopicFetchMetrics.computeIfAbsent(partition.topic(), t -> new FetchMetrics()).increment(bytes, records);
        this.maybeRecordMetrics(partition);
    }

    private void maybeRecordMetrics(TopicPartition partition) {
        this.unrecordedPartitions.remove(partition);
        if (!this.unrecordedPartitions.isEmpty()) {
            return;
        }
        this.metricsManager.recordBytesFetched(this.fetchFetchMetrics.bytes);
        this.metricsManager.recordRecordsFetched(this.fetchFetchMetrics.records);
        for (Map.Entry<String, FetchMetrics> entry : this.perTopicFetchMetrics.entrySet()) {
            String topic = entry.getKey();
            FetchMetrics fetchMetrics = entry.getValue();
            this.metricsManager.recordBytesFetched(topic, fetchMetrics.bytes);
            this.metricsManager.recordRecordsFetched(topic, fetchMetrics.records);
        }
    }

    private static class FetchMetrics {
        private int bytes;
        private int records;

        private FetchMetrics() {
        }

        private void increment(int bytes, int records) {
            this.bytes += bytes;
            this.records += records;
        }
    }
}

