/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.treenode;

import java.io.File;
import java.util.Collection;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jd.gui.api.API;
import org.jd.gui.api.feature.UriGettable;
import org.jd.gui.api.model.Container;
import org.jd.gui.service.treenode.DirectoryTreeNodeFactoryProvider;
import org.jd.gui.util.container.JarContainerEntryUtil;
import org.jd.gui.view.data.TreeNodeBean;

public class PackageTreeNodeFactoryProvider
extends DirectoryTreeNodeFactoryProvider {
    protected static final ImageIcon ICON = new ImageIcon(PackageTreeNodeFactoryProvider.class.getClassLoader().getResource("org/jd/gui/images/package_obj.png"));

    @Override
    public String[] getSelectors() {
        return this.appendSelectors("jar:dir:*");
    }

    @Override
    public Pattern getPathPattern() {
        if (this.externalPathPattern == null) {
            return Pattern.compile("(META-INF\\/versions\\/.*)|(?!META-INF)..*");
        }
        return this.externalPathPattern;
    }

    @Override
    public <T extends DefaultMutableTreeNode & UriGettable> T make(API api, Container.Entry entry) {
        Container.Entry child;
        int lastSlashIndex = entry.getPath().lastIndexOf("/");
        Collection<Container.Entry> entries = entry.getChildren();
        while (entries.size() == 1 && (child = entries.iterator().next()).isDirectory() && api.getTreeNodeFactory(child) == this && entry.getContainer() == child.getContainer()) {
            entry = child;
            entries = entry.getChildren();
        }
        String label = entry.getPath().substring(lastSlashIndex + 1).replace("/", ".");
        String location = new File(entry.getUri()).getPath();
        TreeNode node = new TreeNode(entry, new TreeNodeBean(label, "Location: " + location, this.getIcon(), this.getOpenIcon()));
        if (entries.size() > 0) {
            node.add(new DefaultMutableTreeNode());
        }
        return (T)node;
    }

    @Override
    public ImageIcon getIcon() {
        return ICON;
    }

    @Override
    public ImageIcon getOpenIcon() {
        return null;
    }

    protected static class TreeNode
    extends DirectoryTreeNodeFactoryProvider.TreeNode {
        public TreeNode(Container.Entry entry, Object userObject) {
            super(entry, userObject);
        }

        @Override
        public Collection<Container.Entry> getChildren() {
            return JarContainerEntryUtil.removeInnerTypeEntries(this.entry.getChildren());
        }
    }
}

