/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.actions;

import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import org.jd.gui.api.API;
import org.jd.gui.api.model.Container;
import org.jd.gui.api.model.Type;
import org.jd.gui.service.actions.InvalidFormatException;
import org.jd.gui.spi.ContextualActionsFactory;
import org.jd.gui.spi.TypeFactory;

public class CopyQualifiedNameContextualActionsFactory
implements ContextualActionsFactory {
    @Override
    public Collection<Action> make(API api, Container.Entry entry, String fragment) {
        return Collections.singletonList(new CopyQualifiedNameAction(api, entry, fragment));
    }

    public static class CopyQualifiedNameAction
    extends AbstractAction {
        protected static final ImageIcon ICON = new ImageIcon(CopyQualifiedNameAction.class.getClassLoader().getResource("org/jd/gui/images/cpyqual_menu.png"));
        protected API api;
        protected Container.Entry entry;
        protected String fragment;

        public CopyQualifiedNameAction(API api, Container.Entry entry, String fragment) {
            this.api = api;
            this.entry = entry;
            this.fragment = fragment;
            this.putValue("GroupNameKey", "Edit > CutCopyPaste");
            this.putValue("Name", "Copy Qualified Name");
            this.putValue("SmallIcon", ICON);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String rootPath;
            Type type;
            TypeFactory typeFactory = this.api.getTypeFactory(this.entry);
            if (typeFactory != null && (type = typeFactory.make(this.api, this.entry, this.fragment)) != null) {
                int dashIndex;
                StringBuilder sb = new StringBuilder(type.getDisplayPackageName());
                if (sb.length() > 0) {
                    sb.append('.');
                }
                sb.append(type.getDisplayTypeName());
                if (this.fragment != null && (dashIndex = this.fragment.indexOf(45)) != -1) {
                    int lastDashIndex = this.fragment.lastIndexOf(45);
                    if (dashIndex == lastDashIndex) {
                        throw new InvalidFormatException("fragment: " + this.fragment);
                    }
                    String name = this.fragment.substring(dashIndex + 1, lastDashIndex);
                    String descriptor = this.fragment.substring(lastDashIndex + 1);
                    if (descriptor.startsWith("(")) {
                        for (Type.Method method : type.getMethods()) {
                            if (!method.getName().equals(name) || !method.getDescriptor().equals(descriptor)) continue;
                            sb.append('.').append(method.getDisplayName());
                            break;
                        }
                    } else {
                        for (Type.Field field : type.getFields()) {
                            if (!field.getName().equals(name) || !field.getDescriptor().equals(descriptor)) continue;
                            sb.append('.').append(field.getDisplayName());
                            break;
                        }
                    }
                }
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(sb.toString()), null);
                return;
            }
            String path = this.entry.getUri().getPath();
            String qualifiedName = path.substring((rootPath = this.entry.getContainer().getRoot().getUri().getPath()).length()).replace('/', '.');
            if (qualifiedName.endsWith(".class")) {
                qualifiedName = qualifiedName.substring(0, qualifiedName.length() - 6);
            }
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(qualifiedName), null);
        }
    }
}

