/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core.jrrd;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.rrd4j.core.RrdException;
import org.rrd4j.core.jrrd.Archive;
import org.rrd4j.core.jrrd.ConsolidationFunctionType;
import org.rrd4j.core.jrrd.DataChunk;
import org.rrd4j.core.jrrd.DataSource;
import org.rrd4j.core.jrrd.Header;
import org.rrd4j.core.jrrd.RRDFile;

public class RRDatabase
implements Closeable {
    final RRDFile rrdFile;
    private final String name;
    final Header header;
    private final ArrayList<DataSource> dataSources;
    private final ArrayList<Archive> archives;
    final Date lastUpdate;
    private final Map<String, Integer> nameindex;

    public RRDatabase(String name) throws IOException {
        this(new File(name));
    }

    public RRDatabase(File file) throws IOException {
        Archive archive;
        int i;
        int i2;
        this.name = file.getName();
        this.rrdFile = new RRDFile(file);
        this.header = new Header(this.rrdFile);
        this.nameindex = new HashMap<String, Integer>(this.header.dsCount);
        this.dataSources = new ArrayList(this.header.dsCount);
        for (i2 = 0; i2 < this.header.dsCount; ++i2) {
            DataSource ds = new DataSource(this.rrdFile);
            this.nameindex.put(ds.getName(), i2);
            this.dataSources.add(ds);
        }
        this.archives = new ArrayList(this.header.rraCount);
        for (i2 = 0; i2 < this.header.rraCount; ++i2) {
            Archive archive2 = new Archive(this);
            this.archives.add(archive2);
        }
        long last_up = (long)this.rrdFile.readLong() * 1000L;
        if (this.header.getVersionAsInt() >= 3) {
            long last_up_usec = this.rrdFile.readLong();
            last_up += last_up_usec / 1000L;
        }
        this.lastUpdate = new Date(last_up);
        for (i = 0; i < this.header.dsCount; ++i) {
            DataSource ds = this.dataSources.get(i);
            ds.loadPDPStatusBlock(this.rrdFile);
        }
        for (i = 0; i < this.header.rraCount; ++i) {
            archive = this.archives.get(i);
            archive.loadCDPStatusBlocks(this.rrdFile, this.header.dsCount);
        }
        for (i = 0; i < this.header.rraCount; ++i) {
            archive = this.archives.get(i);
            archive.loadCurrentRow(this.rrdFile);
        }
        for (i = 0; i < this.header.rraCount; ++i) {
            archive = this.archives.get(i);
            archive.loadData(this.rrdFile, this.header.dsCount);
        }
    }

    public Header getHeader() {
        return this.header;
    }

    public Set<String> getDataSourcesName() {
        return this.nameindex.keySet();
    }

    public Date getLastUpdate() {
        return this.lastUpdate;
    }

    public DataSource getDataSource(int index) {
        return this.dataSources.get(index);
    }

    public Iterator<DataSource> getDataSources() {
        return this.dataSources.iterator();
    }

    public Archive getArchive(int index) {
        return this.archives.get(index);
    }

    public Archive getArchive(String name) {
        return this.archives.get(this.nameindex.get(name));
    }

    public Iterator<Archive> getArchives() {
        return this.archives.iterator();
    }

    public int getNumArchives() {
        return this.header.rraCount;
    }

    public Iterator<Archive> getArchives(ConsolidationFunctionType type) {
        return this.getArchiveList(type).iterator();
    }

    ArrayList<Archive> getArchiveList(ConsolidationFunctionType type) {
        ArrayList<Archive> subset = new ArrayList<Archive>();
        for (Archive archive : this.archives) {
            if (!archive.getType().equals((Object)type)) continue;
            subset.add(archive);
        }
        return subset;
    }

    @Override
    public void close() throws IOException {
        this.rrdFile.close();
    }

    public void printInfo(PrintStream s) {
        DecimalFormat numberFormat = new DecimalFormat("0.0000000000E0");
        this.printInfo(s, numberFormat);
    }

    public DataChunk getData(ConsolidationFunctionType type) throws IOException {
        Calendar endCal = Calendar.getInstance();
        endCal.set(14, 0);
        Calendar startCal = (Calendar)endCal.clone();
        startCal.add(5, -1);
        return this.getData(type, startCal.getTime(), endCal.getTime(), 1L);
    }

    public DataChunk getData(ConsolidationFunctionType type, Date startDate, Date endDate, long step) throws IOException {
        long end = endDate.getTime() / 1000L;
        long start = startDate.getTime() / 1000L;
        return this.getData(type, start, end, step);
    }

    public DataChunk getData(ConsolidationFunctionType type, long startTime, long endTime, long stepSeconds) throws IOException {
        ArrayList<Archive> possibleArchives = this.getArchiveList(type);
        if (possibleArchives.size() == 0) {
            throw new IllegalArgumentException("Database does not contain an Archive of consolidation function type " + (Object)((Object)type));
        }
        Archive archive = this.findBestArchive(startTime, endTime, stepSeconds, possibleArchives);
        if (archive == null) {
            throw new RrdException("No matching archive found");
        }
        stepSeconds = (long)this.header.pdpStep * (long)archive.pdpCount;
        startTime -= startTime % stepSeconds;
        if (endTime % stepSeconds != 0L) {
            endTime += stepSeconds - endTime % stepSeconds;
        }
        int rows = (int)((endTime - startTime) / stepSeconds + 1L);
        long lastUpdateLong = this.lastUpdate.getTime() / 1000L;
        long archiveEndTime = lastUpdateLong - lastUpdateLong % stepSeconds;
        long archiveStartTime = archiveEndTime - stepSeconds * (long)(archive.rowCount - 1);
        int startOffset = (int)((startTime - archiveStartTime) / stepSeconds);
        int endOffset = (int)((archiveEndTime - endTime) / stepSeconds);
        DataChunk chunk = new DataChunk(this.nameindex, startTime, startOffset, endOffset, stepSeconds, this.header.dsCount, rows);
        archive.loadData(chunk);
        return chunk;
    }

    private Archive findBestArchive(long start, long end, long step, ArrayList<Archive> archives) {
        Archive archive = null;
        Archive bestFullArchive = null;
        Archive bestPartialArchive = null;
        long lastUpdateLong = this.lastUpdate.getTime() / 1000L;
        boolean firstPart = true;
        boolean firstFull = true;
        long bestMatch = 0L;
        long bestStepDiff = 0L;
        Iterator<Archive> iterator = archives.iterator();
        while (iterator.hasNext()) {
            Archive archive1;
            archive = archive1 = iterator.next();
            long calEnd = lastUpdateLong - lastUpdateLong % (long)(archive.pdpCount * this.header.pdpStep);
            long calStart = calEnd - (long)(archive.pdpCount * archive.rowCount * this.header.pdpStep);
            long fullMatch = end - start;
            if (calEnd >= end && calStart < start) {
                long tmpStepDiff = Math.abs(step - (long)(this.header.pdpStep * archive.pdpCount));
                if (!firstFull && tmpStepDiff >= bestStepDiff) continue;
                firstFull = false;
                bestStepDiff = tmpStepDiff;
                bestFullArchive = archive;
                continue;
            }
            long tmpMatch = fullMatch;
            if (calStart > start) {
                tmpMatch -= calStart - start;
            }
            if (calEnd < end) {
                tmpMatch -= end - calEnd;
            }
            if (!firstPart && bestMatch >= tmpMatch) continue;
            firstPart = false;
            bestMatch = tmpMatch;
            bestPartialArchive = archive;
        }
        if (!firstFull) {
            archive = bestFullArchive;
        } else if (!firstPart) {
            archive = bestPartialArchive;
        }
        return archive;
    }

    public void printInfo(PrintStream s, NumberFormat numberFormat) {
        s.print("filename = \"");
        s.print(this.name);
        s.println("\"");
        s.print("rrd_version = \"");
        s.print(this.header.version);
        s.println("\"");
        s.print("step = ");
        s.println(this.header.pdpStep);
        s.print("last_update = ");
        s.println(this.lastUpdate.getTime() / 1000L);
        for (DataSource ds : this.dataSources) {
            ds.printInfo(s, numberFormat);
        }
        int index = 0;
        for (Archive archive : this.archives) {
            archive.printInfo(s, numberFormat, index++);
        }
    }

    public void toXml(PrintStream s) {
        int i;
        s.println("<!--");
        s.println("  Round Robin RRDatabase Dump ");
        s.println("  Generated by jRRD <ciaran@codeloop.com>");
        s.println("-->");
        s.println("<rrd>");
        s.print("\t<version> ");
        s.print(this.header.version);
        s.println(" </version>");
        s.print("\t<step> ");
        s.print(this.header.pdpStep);
        s.println(" </step> <!-- Seconds -->");
        s.print("\t<lastupdate> ");
        s.print(this.lastUpdate.getTime() / 1000L);
        s.print(" </lastupdate> <!-- ");
        s.print(this.lastUpdate);
        s.println(" -->");
        s.println();
        for (i = 0; i < this.header.dsCount; ++i) {
            DataSource ds = this.dataSources.get(i);
            ds.toXml(s);
        }
        s.println("<!-- Round Robin Archives -->");
        for (i = 0; i < this.header.rraCount; ++i) {
            Archive archive = this.archives.get(i);
            archive.toXml(s);
        }
        s.println("</rrd>");
        s.flush();
    }

    public String toString() {
        String endianness = this.rrdFile.isBigEndian() ? "Big" : "Little";
        StringBuilder sb = new StringBuilder(endianness + " endian, " + this.rrdFile.getBits() + " bits\n");
        sb.append(this.header.toString());
        sb.append(", lastupdate: ");
        sb.append(this.lastUpdate.getTime() / 1000L);
        for (DataSource ds : this.dataSources) {
            sb.append("\n\t");
            sb.append(ds.toString());
        }
        for (Archive archive : this.archives) {
            sb.append("\n\t");
            sb.append(archive.toString());
        }
        return sb.toString();
    }
}

