from typing import Sequence, Optional, Tuple, Union, List
from typing_extensions import Protocol
from pygame.rect import Rect
from pygame._common import _Coordinate

_CanBeRect = Union[
    Rect,
    Tuple[int, int, int, int],
    List[int],
    Tuple[_Coordinate, _Coordinate],
    List[_Coordinate],
]

class _HasRectAttribute(Protocol):
    rect: _CanBeRect

_RectValue = Union[_CanBeRect, _HasRectAttribute]

def get_focused() -> bool: ...
def get_pressed() -> Sequence[bool]: ...
def get_mods() -> int: ...
def set_mods(mods: int) -> None: ...
def set_repeat(delay: int = 0, interval: int = 0) -> None: ...
def get_repeat() -> Tuple[int, int]: ...
def name(key: int) -> str: ...
def key_code(name: str) -> int: ...
def start_text_input() -> None: ...
def stop_text_input() -> None: ...
def set_text_input_rect(rect: _RectValue) -> None: ...
