/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.module.provider;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.Action;
import org.openhab.core.automation.Visibility;
import org.openhab.core.automation.annotation.ActionInput;
import org.openhab.core.automation.annotation.ActionOutput;
import org.openhab.core.automation.annotation.ActionOutputs;
import org.openhab.core.automation.annotation.ActionScope;
import org.openhab.core.automation.annotation.RuleAction;
import org.openhab.core.automation.module.provider.ActionModuleKind;
import org.openhab.core.automation.module.provider.ModuleInformation;
import org.openhab.core.automation.type.ActionType;
import org.openhab.core.automation.type.Input;
import org.openhab.core.automation.type.Output;
import org.openhab.core.automation.util.ActionInputsHelper;
import org.openhab.core.config.core.ConfigDescriptionParameter;
import org.openhab.core.config.core.ConfigDescriptionParameterBuilder;
import org.openhab.core.config.core.Configuration;
import org.openhab.core.config.core.ParameterOption;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(service={AnnotationActionModuleTypeHelper.class})
public class AnnotationActionModuleTypeHelper {
    private final Logger logger = LoggerFactory.getLogger(AnnotationActionModuleTypeHelper.class);
    private static final String SELECT_SERVICE_LABEL = "Select Service Instance";
    private static final String SELECT_THING_LABEL = "Select Thing";
    public static final String CONFIG_PARAM = "config";
    private final ActionInputsHelper actionInputsHelper;

    @Activate
    public AnnotationActionModuleTypeHelper(@Reference ActionInputsHelper actionInputsHelper) {
        this.actionInputsHelper = actionInputsHelper;
    }

    public Collection<ModuleInformation> parseAnnotations(Object actionProvider) {
        Class<?> clazz = actionProvider.getClass();
        if (clazz.isAnnotationPresent(ActionScope.class)) {
            ActionScope scope = clazz.getAnnotation(ActionScope.class);
            return this.parseAnnotations(scope.name(), actionProvider);
        }
        return List.of();
    }

    public Collection<ModuleInformation> parseAnnotations(String name, Object actionProvider) {
        Method[] methods;
        ArrayList<ModuleInformation> moduleInformation = new ArrayList<ModuleInformation>();
        Class<?> clazz = actionProvider.getClass();
        Method[] methodArray = methods = clazz.getDeclaredMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.isAnnotationPresent(RuleAction.class)) {
                List<Input> inputs = this.getInputsFromAction(method);
                List<Output> outputs = this.getOutputsFromAction(method);
                RuleAction ruleAction = method.getAnnotation(RuleAction.class);
                String uid = this.getModuleIdFromMethod(name, method);
                HashSet<String> tags = new HashSet<String>(Arrays.asList(ruleAction.tags()));
                ModuleInformation mi = new ModuleInformation(uid, actionProvider, method);
                mi.setLabel(ruleAction.label());
                mi.setDescription(ruleAction.description());
                mi.setVisibility(ruleAction.visibility());
                mi.setInputs(inputs);
                mi.setOutputs(outputs);
                mi.setTags(tags);
                moduleInformation.add(mi);
            }
            ++n2;
        }
        return moduleInformation;
    }

    public String getModuleIdFromMethod(String actionScope, Method method) {
        String uid = actionScope + "." + method.getName() + "#";
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        Class<?>[] classArray = method.getParameterTypes();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> parameter = classArray[n2];
            md5.update(parameter.getName().getBytes());
            ++n2;
        }
        return uid + String.format("%032x", new BigInteger(1, md5.digest()));
    }

    /*
     * WARNING - void declaration
     */
    private List<Input> getInputsFromAction(Method method) {
        ArrayList<Input> inputs = new ArrayList<Input>();
        Annotation[][] annotations = method.getParameterAnnotations();
        Parameter[] params = method.getParameters();
        int i = 0;
        while (i < annotations.length) {
            Annotation a;
            Annotation annotation;
            Parameter param = params[i];
            Annotation[] paramAnnotations = annotations[i];
            if (paramAnnotations.length == 0) {
                inputs.add(new Input("p" + i, param.getType().getCanonicalName(), "", "", Set.of(), false, "", ""));
            } else if (paramAnnotations.length == 1 && (annotation = (a = paramAnnotations[0])) instanceof ActionInput) {
                void inp;
                ActionInput cfr_ignored_0 = (ActionInput)annotation;
                ActionInput cfr_ignored_1 = (ActionInput)annotation;
                String type = !"".equals(inp.type()) ? inp.type() : param.getType().getCanonicalName();
                inputs.add(new Input(inp.name(), type, inp.label(), inp.description(), Arrays.stream(inp.tags()).collect(Collectors.toSet()), inp.required(), inp.reference(), inp.defaultValue()));
            }
            ++i;
        }
        return inputs;
    }

    private Output getOutputFromActionOutputAnnotation(ActionOutput ruleActionOutput, @Nullable String nameOverride) {
        return new Output(nameOverride != null ? nameOverride : ruleActionOutput.name(), ruleActionOutput.type(), ruleActionOutput.label(), ruleActionOutput.description(), Arrays.stream(ruleActionOutput.tags()).collect(Collectors.toSet()), ruleActionOutput.reference(), ruleActionOutput.defaultValue());
    }

    private List<Output> getOutputsFromAction(Method method) {
        ArrayList<Output> outputs = new ArrayList<Output>();
        if (method.isAnnotationPresent(ActionOutputs.class)) {
            ActionOutput[] actionOutputArray = method.getAnnotation(ActionOutputs.class).value();
            int n = actionOutputArray.length;
            int n2 = 0;
            while (n2 < n) {
                ActionOutput ruleActionOutput = actionOutputArray[n2];
                outputs.add(this.getOutputFromActionOutputAnnotation(ruleActionOutput, null));
                ++n2;
            }
        } else {
            if (method.getAnnotatedReturnType().toString().equals("java.util.Map<java.lang.String, java.lang.Object>")) {
                this.logger.warn("Method {}::{} returns a Map<String, Object> but is not annotated with ActionOutputs. This should be fixed in the binding.", (Object)method.getDeclaringClass().getSimpleName(), (Object)method.getName());
                return outputs;
            }
            if (method.isAnnotationPresent(ActionOutput.class)) {
                ActionOutput ruleActionOutput = method.getAnnotation(ActionOutput.class);
                if (!ruleActionOutput.name().equals("result")) {
                    this.logger.warn("Method {}::{} has a single output but does not use the default output name in the ActionOutput annotation. This should be fixed in the binding.", (Object)method.getDeclaringClass().getSimpleName(), (Object)method.getName());
                }
                outputs.add(this.getOutputFromActionOutputAnnotation(ruleActionOutput, "result"));
            }
        }
        return outputs;
    }

    public @Nullable ActionType buildModuleType(String uid, Map<String, Set<ModuleInformation>> moduleInformation) {
        Set<ModuleInformation> mis = moduleInformation.get(uid);
        ArrayList<ConfigDescriptionParameter> configDescriptions = new ArrayList<ConfigDescriptionParameter>();
        if (mis != null && !mis.isEmpty()) {
            ModuleInformation mi = (ModuleInformation)mis.toArray()[0];
            ActionModuleKind kind = ActionModuleKind.SINGLE;
            if (mi.getConfigName() != null && mi.getThingUID() != null) {
                this.logger.error("ModuleType with UID {} has thingUID ({}) and multi-service ({}) property set, ignoring it.", new Object[]{uid, mi.getConfigName(), mi.getThingUID()});
                return null;
            }
            if (mi.getConfigName() != null) {
                kind = ActionModuleKind.SERVICE;
            } else if (mi.getThingUID() != null) {
                kind = ActionModuleKind.THING;
            }
            ConfigDescriptionParameter configParam = this.buildConfigParam(mis, kind);
            if (configParam != null) {
                configDescriptions.add(configParam);
            }
            Visibility visibility = mi.getVisibility();
            if (kind == ActionModuleKind.THING) {
                try {
                    List<ConfigDescriptionParameter> inputConfigDescriptions = this.actionInputsHelper.mapActionInputsToConfigDescriptionParameters(mi.getInputs());
                    configDescriptions.addAll(inputConfigDescriptions);
                }
                catch (IllegalArgumentException e) {
                    visibility = Visibility.HIDDEN;
                    this.logger.debug("{} Thing action {} has an input with an unsupported type, hiding it in the UI.", (Object)e.getMessage(), (Object)uid);
                }
            }
            return new ActionType(uid, configDescriptions, mi.getLabel(), mi.getDescription(), mi.getTags(), visibility, mi.getInputs(), mi.getOutputs());
        }
        return null;
    }

    private @Nullable ConfigDescriptionParameter buildConfigParam(Set<ModuleInformation> moduleInformations, ActionModuleKind kind) {
        ArrayList<ParameterOption> options = new ArrayList<ParameterOption>();
        if (kind == ActionModuleKind.SINGLE) {
            if (moduleInformations.size() == 1 && ((ModuleInformation)moduleInformations.toArray()[0]).getConfigName() == null && ((ModuleInformation)moduleInformations.toArray()[0]).getThingUID() == null) {
                return null;
            }
        } else {
            if (kind == ActionModuleKind.SERVICE) {
                for (ModuleInformation mi : moduleInformations) {
                    String configName = mi.getConfigName();
                    options.add(new ParameterOption(configName, configName));
                }
                return ConfigDescriptionParameterBuilder.create((String)CONFIG_PARAM, (ConfigDescriptionParameter.Type)ConfigDescriptionParameter.Type.TEXT).withLabel(SELECT_SERVICE_LABEL).withOptions(options).withLimitToOptions(Boolean.valueOf(true)).withRequired(Boolean.valueOf(true)).build();
            }
            if (kind == ActionModuleKind.THING) {
                for (ModuleInformation mi : moduleInformations) {
                    String thingUID = mi.getThingUID();
                    options.add(new ParameterOption(thingUID, null));
                }
                return ConfigDescriptionParameterBuilder.create((String)CONFIG_PARAM, (ConfigDescriptionParameter.Type)ConfigDescriptionParameter.Type.TEXT).withLabel(SELECT_THING_LABEL).withContext("thing").withOptions(options).withLimitToOptions(Boolean.valueOf(true)).withRequired(Boolean.valueOf(true)).build();
            }
        }
        return null;
    }

    public @Nullable ModuleInformation getModuleInformationForIdentifier(Action module, Map<String, Set<ModuleInformation>> moduleInformation, boolean isThing) {
        Configuration c = module.getConfiguration();
        String config = (String)c.get(CONFIG_PARAM);
        Set<ModuleInformation> mis = moduleInformation.get(module.getTypeUID());
        ModuleInformation finalMI = null;
        if (mis.size() == 1 && config == null) {
            finalMI = (ModuleInformation)mis.toArray()[0];
        } else {
            for (ModuleInformation mi : mis) {
                if (isThing) {
                    if (!Objects.equals(mi.getThingUID(), config)) continue;
                    finalMI = mi;
                    break;
                }
                if (!Objects.equals(mi.getConfigName(), config)) continue;
                finalMI = mi;
                break;
            }
        }
        return finalMI;
    }
}

