/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.sdjwt;

public class IssuerSignedJwtVerificationOpts {
    private final boolean validateIssuedAtClaim;
    private final boolean validateExpirationClaim;
    private final boolean validateNotBeforeClaim;

    public IssuerSignedJwtVerificationOpts(boolean validateIssuedAtClaim, boolean validateExpirationClaim, boolean validateNotBeforeClaim) {
        this.validateIssuedAtClaim = validateIssuedAtClaim;
        this.validateExpirationClaim = validateExpirationClaim;
        this.validateNotBeforeClaim = validateNotBeforeClaim;
    }

    public boolean mustValidateIssuedAtClaim() {
        return this.validateIssuedAtClaim;
    }

    public boolean mustValidateExpirationClaim() {
        return this.validateExpirationClaim;
    }

    public boolean mustValidateNotBeforeClaim() {
        return this.validateNotBeforeClaim;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean validateIssuedAtClaim;
        private boolean validateExpirationClaim = true;
        private boolean validateNotBeforeClaim = true;

        public Builder withValidateIssuedAtClaim(boolean validateIssuedAtClaim) {
            this.validateIssuedAtClaim = validateIssuedAtClaim;
            return this;
        }

        public Builder withValidateExpirationClaim(boolean validateExpirationClaim) {
            this.validateExpirationClaim = validateExpirationClaim;
            return this;
        }

        public Builder withValidateNotBeforeClaim(boolean validateNotBeforeClaim) {
            this.validateNotBeforeClaim = validateNotBeforeClaim;
            return this;
        }

        public IssuerSignedJwtVerificationOpts build() {
            return new IssuerSignedJwtVerificationOpts(this.validateIssuedAtClaim, this.validateExpirationClaim, this.validateNotBeforeClaim);
        }
    }
}

