/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance.mappers;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.ProtocolMapper;
import org.keycloak.protocol.oid4vc.issuance.mappers.OID4VCMapper;
import org.keycloak.protocol.oid4vc.model.VerifiableCredential;
import org.keycloak.provider.ProviderConfigProperty;

public class OID4VCContextMapper
extends OID4VCMapper {
    public static final String MAPPER_ID = "oid4vc-context-mapper";
    public static final String TYPE_KEY = "context";
    private static final List<ProviderConfigProperty> CONFIG_PROPERTIES = new ArrayList<ProviderConfigProperty>();

    @Override
    protected List<ProviderConfigProperty> getIndividualConfigProperties() {
        return CONFIG_PROPERTIES;
    }

    @Override
    public void setClaimsForCredential(VerifiableCredential verifiableCredential, UserSessionModel userSessionModel) {
        HashSet<String> contexts = new HashSet<String>();
        if (verifiableCredential.getContext() != null) {
            contexts = new HashSet<String>(verifiableCredential.getContext());
        }
        contexts.add((String)this.mapperModel.getConfig().get(TYPE_KEY));
        verifiableCredential.setContext(new ArrayList<String>(contexts));
    }

    @Override
    public void setClaimsForSubject(Map<String, Object> claims, UserSessionModel userSessionModel) {
    }

    public String getDisplayType() {
        return "Credential Context Mapper";
    }

    public String getHelpText() {
        return "Assigns a context to the credential.";
    }

    public ProtocolMapper create(KeycloakSession session) {
        return new OID4VCContextMapper();
    }

    public String getId() {
        return MAPPER_ID;
    }

    static {
        ProviderConfigProperty contextPropertyNameConfig = new ProviderConfigProperty();
        contextPropertyNameConfig.setName(TYPE_KEY);
        contextPropertyNameConfig.setLabel("Verifiable Credentials Context");
        contextPropertyNameConfig.setHelpText("Context of the credential.");
        contextPropertyNameConfig.setType("String");
        contextPropertyNameConfig.setDefaultValue((Object)"https://www.w3.org/2018/credentials/v1");
        CONFIG_PROPERTIES.add(contextPropertyNameConfig);
    }
}

