/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.requiredactions.util;

import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.keycloak.authentication.requiredactions.util.UpdateProfileContext;
import org.keycloak.common.Profile;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.userprofile.UserProfileContext;

public class UserUpdateProfileContext
implements UpdateProfileContext {
    private final RealmModel realm;
    private final UserModel user;

    public UserUpdateProfileContext(RealmModel realm, UserModel user) {
        this.realm = realm;
        this.user = user;
    }

    @Override
    public boolean isEditUsernameAllowed() {
        return this.realm.isEditUsernameAllowed();
    }

    @Override
    public UserProfileContext getUserProfileContext() {
        return UserProfileContext.UPDATE_PROFILE;
    }

    @Override
    public String getUsername() {
        return this.user.getUsername();
    }

    @Override
    public void setUsername(String username) {
        this.user.setUsername(username);
    }

    @Override
    public boolean isEditEmailAllowed() {
        return !Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.UPDATE_EMAIL);
    }

    @Override
    public String getEmail() {
        return this.user.getEmail();
    }

    @Override
    public void setEmail(String email) {
        this.user.setEmail(email);
    }

    @Override
    public String getFirstName() {
        return this.user.getFirstName();
    }

    @Override
    public void setFirstName(String firstName) {
        this.user.setFirstName(firstName);
    }

    @Override
    public String getLastName() {
        return this.user.getLastName();
    }

    @Override
    public void setLastName(String lastName) {
        this.user.setLastName(lastName);
    }

    @Override
    public Map<String, List<String>> getAttributes() {
        return this.user.getAttributes();
    }

    @Override
    public void setSingleAttribute(String name, String value) {
        this.user.setSingleAttribute(name, value);
    }

    @Override
    public void setAttribute(String key, List<String> value) {
        this.user.setAttribute(key, value);
    }

    @Override
    public String getFirstAttribute(String name) {
        return this.user.getFirstAttribute(name);
    }

    @Override
    public Stream<String> getAttributeStream(String key) {
        return this.user.getAttributeStream(key);
    }
}

