/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bob.element;

import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.StanzaView;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.bob.BoBData;
import org.jivesoftware.smackx.bob.ContentId;

public class BoBDataExtension
implements ExtensionElement {
    public static final String ELEMENT = "data";
    public static final String NAMESPACE = "urn:xmpp:bob";
    private final ContentId cid;
    private final BoBData bobData;

    public BoBDataExtension(ContentId cid, BoBData bobData) {
        this.cid = Objects.requireNonNull(cid);
        this.bobData = Objects.requireNonNull(bobData);
    }

    @Override
    public String getElementName() {
        return ELEMENT;
    }

    @Override
    public String getNamespace() {
        return NAMESPACE;
    }

    public final ContentId getContentId() {
        return this.cid;
    }

    public final BoBData getBobData() {
        return this.bobData;
    }

    @Override
    public XmlStringBuilder toXML(XmlEnvironment enclosingNamespace) {
        XmlStringBuilder xml = new XmlStringBuilder(this);
        xml.attribute("cid", this.cid.getCid());
        xml.attribute("type", this.bobData.getType());
        xml.optAttribute("max-age", this.bobData.getMaxAge());
        xml.rightAngleBracket();
        xml.append(this.bobData.getContentBase64Encoded());
        xml.closeElement(this);
        return xml;
    }

    public static BoBDataExtension from(StanzaView stanza) {
        return stanza.getExtension(BoBDataExtension.class);
    }
}

